/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.binders;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.io.File;
import org.jclouds.ec2.binders.BindUserIdsToIndexedFormParams;
import org.jclouds.http.HttpRequest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class BindUserIdsToIndexedFormParamsTest {
    Injector injector = Guice.createInjector((Module[])new Module[0]);
    BindUserIdsToIndexedFormParams binder = (BindUserIdsToIndexedFormParams)this.injector.getInstance(BindUserIdsToIndexedFormParams.class);

    public void test() {
        HttpRequest request = HttpRequest.builder().method("POST").endpoint("http://localhost").build();
        request = this.binder.bindToRequest(request, (Object)ImmutableSet.of((Object)"alpha", (Object)"omega"));
        Assert.assertEquals((Object)request.getPayload().getRawContent(), (Object)"UserId.1=alpha&UserId.2=omega");
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testMustBeIterable() {
        HttpRequest request = HttpRequest.builder().method("POST").endpoint("http://localhost").build();
        this.binder.bindToRequest(request, (Object)new File("foo"));
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testNullIsBad() {
        HttpRequest request = HttpRequest.builder().method("GET").endpoint("http://momma").build();
        this.binder.bindToRequest(request, null);
    }
}

