/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.binders;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.io.File;
import org.jclouds.ec2.binders.IfNotNullBindAvailabilityZoneToFormParam;
import org.jclouds.http.HttpRequest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class IfNotNullBindAvailabilityZoneToFormParamTest {
    Injector injector = Guice.createInjector((Module[])new Module[0]);
    IfNotNullBindAvailabilityZoneToFormParam binder = (IfNotNullBindAvailabilityZoneToFormParam)this.injector.getInstance(IfNotNullBindAvailabilityZoneToFormParam.class);

    public void test() {
        HttpRequest request = HttpRequest.builder().method("POST").endpoint("http://localhost").build();
        request = this.binder.bindToRequest(request, (Object)"us-east-1a");
        Assert.assertEquals((Object)request.getPayload().getRawContent(), (Object)"Placement.AvailabilityZone=us-east-1a");
    }

    public void testWhenNullReturnsSame() {
        HttpRequest request = HttpRequest.builder().method("POST").endpoint("http://localhost").build();
        HttpRequest request2 = this.binder.bindToRequest(request, null);
        Assert.assertSame((Object)request, (Object)request2);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testMustBeString() {
        HttpRequest request = HttpRequest.builder().method("POST").endpoint("http://localhost").build();
        this.binder.bindToRequest(request, (Object)new File("foo"));
    }
}

