/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.compute;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.internal.BaseTemplateBuilderLiveTest;
import org.jclouds.ec2.options.DescribeAvailabilityZonesOptions;
import org.jclouds.ec2.options.DescribeImagesOptions;
import org.jclouds.ec2.options.DescribeRegionsOptions;
import org.jclouds.ec2.services.AMIAsyncClient;
import org.jclouds.ec2.services.AvailabilityZoneAndRegionAsyncClient;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.internal.TrackingJavaUrlHttpCommandExecutorService;
import org.jclouds.logging.log4j.config.Log4JLoggingModule;
import org.testng.Assert;
import org.testng.annotations.Test;

public abstract class EC2TemplateBuilderLiveTest
extends BaseTemplateBuilderLiveTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTemplateBuilderCanUseImageIdWithoutFetchingAllImages() throws Exception {
        Template defaultTemplate = ((ComputeServiceContext)this.view).getComputeService().templateBuilder().build();
        String defaultImageId = defaultTemplate.getImage().getId();
        String defaultImageProviderId = defaultTemplate.getImage().getProviderId();
        ComputeServiceContext context = null;
        try {
            ArrayList commandsInvoked = Lists.newArrayList();
            context = (ComputeServiceContext)this.createView(this.setupProperties(), (Iterable)ImmutableSet.of((Object)new Log4JLoggingModule(), (Object)TrackingJavaUrlHttpCommandExecutorService.newTrackingModule((List)commandsInvoked)));
            Template template = context.getComputeService().templateBuilder().imageId(defaultImageId).build();
            Assert.assertEquals((Object)template.getImage(), (Object)defaultTemplate.getImage());
            Collection filteredCommandsInvoked = Collections2.filter((Collection)commandsInvoked, (Predicate)new Predicate<HttpCommand>(){
                private final Collection<Method> ignored = ImmutableSet.of((Object)AvailabilityZoneAndRegionAsyncClient.class.getMethod("describeRegions", DescribeRegionsOptions[].class), (Object)AvailabilityZoneAndRegionAsyncClient.class.getMethod("describeAvailabilityZonesInRegion", String.class, DescribeAvailabilityZonesOptions[].class));

                public boolean apply(HttpCommand input) {
                    return !this.ignored.contains(TrackingJavaUrlHttpCommandExecutorService.getInvokerOfRequest((HttpCommand)input));
                }
            });
            assert (filteredCommandsInvoked.size() == 1) : commandsInvoked;
            Assert.assertEquals((Object)TrackingJavaUrlHttpCommandExecutorService.getInvokerOfRequestAtIndex((Collection)filteredCommandsInvoked, (int)0), (Object)AMIAsyncClient.class.getMethod("describeImagesInRegion", String.class, DescribeImagesOptions[].class));
            EC2TemplateBuilderLiveTest.assertDescribeImagesOptionsEquals((DescribeImagesOptions[])TrackingJavaUrlHttpCommandExecutorService.getArgsForRequestAtIndex((Collection)filteredCommandsInvoked, (int)0).get(1), defaultImageProviderId);
        }
        finally {
            if (context != null) {
                context.close();
            }
        }
    }

    private static void assertDescribeImagesOptionsEquals(DescribeImagesOptions[] actual, String expectedImageId) {
        Assert.assertEquals((int)actual.length, (int)1);
        Assert.assertEquals((Set)actual[0].getImageIds(), (Set)ImmutableSet.of((Object)expectedImageId));
    }
}

