/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.compute.extensions;

import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.Futures;
import java.util.Map;
import java.util.concurrent.Future;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.ImageTemplate;
import org.jclouds.compute.extensions.ImageExtension;
import org.jclouds.ec2.compute.internal.BaseEC2ComputeServiceExpectTest;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="EC2ImageExtensionExpectTest")
public class EC2ImageExtensionExpectTest
extends BaseEC2ComputeServiceExpectTest {
    public void testCreateImage() {
        ImmutableMap.Builder requestResponseMap = ImmutableMap.builder();
        requestResponseMap.put((Object)this.describeRegionsRequest, (Object)this.describeRegionsResponse);
        requestResponseMap.put((Object)this.describeAvailabilityZonesRequest, (Object)this.describeAvailabilityZonesResponse);
        requestResponseMap.put((Object)this.describeImagesRequest, (Object)this.describeImagesResponse);
        requestResponseMap.put((Object)this.createKeyPairRequest, (Object)this.createKeyPairResponse);
        requestResponseMap.put((Object)this.createSecurityGroupRequest, (Object)this.createSecurityGroupResponse);
        requestResponseMap.put((Object)this.describeSecurityGroupRequest, (Object)this.describeSecurityGroupResponse);
        requestResponseMap.put((Object)this.authorizeSecurityGroupIngressRequest22, (Object)this.authorizeSecurityGroupIngressResponse);
        requestResponseMap.put((Object)this.authorizeSecurityGroupIngressRequestGroup, (Object)this.authorizeSecurityGroupIngressResponse);
        requestResponseMap.put((Object)this.describeInstanceRequest, (Object)this.describeInstanceResponse);
        HttpRequest createImageRequest = this.formSigner.filter(((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ec2." + this.region + ".amazonaws.com/").addHeader("Host", new String[]{"ec2." + this.region + ".amazonaws.com"})).addFormParam("Action", new String[]{"CreateImage"}).addFormParam("InstanceId", new String[]{"i-2baa5550"}).addFormParam("Name", new String[]{"test"}).build());
        HttpResponse createImageResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(EC2ImageExtensionExpectTest.payloadFromStringWithContentType((String)"<CreateImageResponse><imageId>ami-be3adfd7</imageId></CreateImageResponse>", (String)"application/xml"))).build();
        requestResponseMap.put((Object)createImageRequest, (Object)createImageResponse);
        HttpRequest describeImageRequest = this.formSigner.filter(((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ec2." + this.region + ".amazonaws.com/").addHeader("Host", new String[]{"ec2." + this.region + ".amazonaws.com"})).addFormParam("Action", new String[]{"DescribeImages"}).addFormParam("ImageId.1", new String[]{"ami-be3adfd7"}).build());
        requestResponseMap.put((Object)describeImageRequest, (Object)this.describeImagesResponse);
        ImageExtension apiThatCreatesImage = (ImageExtension)((ComputeService)this.requestsSendResponses((Map)requestResponseMap.build())).getImageExtension().get();
        ImageTemplate newImageTemplate = apiThatCreatesImage.buildImageTemplateFromNode("test", "us-east-1/i-2baa5550");
        Image image = (Image)Futures.getUnchecked((Future)apiThatCreatesImage.createImage(newImageTemplate));
        Assert.assertEquals((String)image.getId(), (String)"us-east-1/ami-be3adfd7");
    }
}

