/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.compute.internal;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.inject.Provider;
import org.easymock.EasyMock;
import org.jclouds.collect.Memoized;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.compute.domain.TemplateBuilder;
import org.jclouds.compute.domain.internal.TemplateBuilderImplTest;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.domain.Location;
import org.jclouds.ec2.compute.domain.EC2HardwareBuilder;
import org.jclouds.ec2.compute.domain.RegionAndName;
import org.jclouds.ec2.compute.functions.ImagesToRegionAndIdMap;
import org.jclouds.ec2.compute.internal.EC2TemplateBuilderImpl;
import org.jclouds.ec2.compute.options.EC2TemplateOptions;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, singleThreaded=true)
public class EC2TemplateBuilderImplTest
extends TemplateBuilderImplTest {
    protected TemplateOptions provideTemplateOptions() {
        return new EC2TemplateOptions();
    }

    protected EC2TemplateBuilderImpl createTemplateBuilder(final Image knownImage, @Memoized Supplier<Set<? extends Location>> locations, @Memoized Supplier<Set<? extends Image>> images, @Memoized Supplier<Set<? extends Hardware>> sizes, Location defaultLocation, Provider<TemplateOptions> optionsProvider, Provider<TemplateBuilder> templateBuilderProvider) {
        LoadingCache imageMap;
        if (knownImage != null) {
            final RegionAndName knownRegionAndName = new RegionAndName(knownImage.getLocation().getId(), knownImage.getProviderId());
            imageMap = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<RegionAndName, Image>(){

                public Image load(RegionAndName from) {
                    return from.equals((Object)knownRegionAndName) ? knownImage : null;
                }
            });
        } else {
            imageMap = CacheBuilder.newBuilder().build(CacheLoader.from((Function)Functions.forMap((Map)ImagesToRegionAndIdMap.imagesToMap((Iterable)((Iterable)images.get())))));
        }
        return new EC2TemplateBuilderImpl(locations, images, sizes, Suppliers.ofInstance((Object)defaultLocation), optionsProvider, templateBuilderProvider, Suppliers.ofInstance((Object)imageMap));
    }

    protected String getProviderFormatId(String uniqueLabel) {
        return "us-east-1/" + uniqueLabel;
    }

    @Test
    public void testHardwareWithImageIdPredicateOnlyAcceptsImageWhenLocationNull() {
    }

    @Test
    public void testParseOnDemand() {
        Supplier locations = Suppliers.ofInstance((Object)ImmutableSet.of((Object)this.region));
        Supplier images = Suppliers.ofInstance((Object)Sets.newLinkedHashSet());
        Supplier sizes = Suppliers.ofInstance((Object)ImmutableSet.of((Object)EC2HardwareBuilder.c1_medium().build()));
        Provider optionsProvider = (Provider)EasyMock.createMock(Provider.class);
        Provider templateBuilderProvider = (Provider)EasyMock.createMock(Provider.class);
        TemplateOptions defaultOptions = (TemplateOptions)EasyMock.createMock(TemplateOptions.class);
        Image knownImage = (Image)EasyMock.createMock(Image.class);
        OperatingSystem os = (OperatingSystem)EasyMock.createMock(OperatingSystem.class);
        EasyMock.expect((Object)optionsProvider.get()).andReturn((Object)defaultOptions);
        EasyMock.expect((Object)knownImage.getId()).andReturn((Object)"us-east-1/ami").atLeastOnce();
        EasyMock.expect((Object)knownImage.getLocation()).andReturn((Object)this.region).atLeastOnce();
        EasyMock.expect((Object)knownImage.getName()).andReturn(null).atLeastOnce();
        EasyMock.expect((Object)knownImage.getDescription()).andReturn(null).atLeastOnce();
        EasyMock.expect((Object)knownImage.getVersion()).andReturn(null).atLeastOnce();
        EasyMock.expect((Object)knownImage.getProviderId()).andReturn((Object)"ami").atLeastOnce();
        EasyMock.expect((Object)knownImage.getOperatingSystem()).andReturn((Object)os).atLeastOnce();
        EasyMock.expect((Object)os.getName()).andReturn(null).atLeastOnce();
        EasyMock.expect((Object)os.getVersion()).andReturn(null).atLeastOnce();
        EasyMock.expect((Object)os.getFamily()).andReturn(null).atLeastOnce();
        EasyMock.expect((Object)os.getDescription()).andReturn(null).atLeastOnce();
        EasyMock.expect((Object)os.getArch()).andReturn((Object)"paravirtual").atLeastOnce();
        EasyMock.expect((Object)os.is64Bit()).andReturn((Object)false).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{knownImage});
        EasyMock.replay((Object[])new Object[]{os});
        EasyMock.replay((Object[])new Object[]{defaultOptions});
        EasyMock.replay((Object[])new Object[]{optionsProvider});
        EasyMock.replay((Object[])new Object[]{templateBuilderProvider});
        EC2TemplateBuilderImpl template = this.createTemplateBuilder(knownImage, (Supplier<Set<? extends Location>>)locations, (Supplier<Set<? extends Image>>)images, (Supplier<Set<? extends Hardware>>)sizes, this.region, (Provider<TemplateOptions>)optionsProvider, (Provider<TemplateBuilder>)templateBuilderProvider);
        Assert.assertEquals((Object)template.imageId("us-east-1/ami").build().getImage(), (Object)knownImage);
        EasyMock.verify((Object[])new Object[]{knownImage});
        EasyMock.verify((Object[])new Object[]{os});
        EasyMock.verify((Object[])new Object[]{defaultOptions});
        EasyMock.verify((Object[])new Object[]{optionsProvider});
        EasyMock.verify((Object[])new Object[]{templateBuilderProvider});
    }

    @Test
    public void testParseOnDemandWithoutRegionEncodedIntoId() {
        Supplier locations = Suppliers.ofInstance((Object)ImmutableSet.of((Object)this.region));
        Supplier images = Suppliers.ofInstance((Object)ImmutableSet.of());
        Supplier sizes = Suppliers.ofInstance((Object)ImmutableSet.of((Object)EC2HardwareBuilder.c1_medium().build()));
        Provider optionsProvider = (Provider)EasyMock.createMock(Provider.class);
        Provider templateBuilderProvider = (Provider)EasyMock.createMock(Provider.class);
        TemplateOptions defaultOptions = (TemplateOptions)EasyMock.createMock(TemplateOptions.class);
        Image knownImage = (Image)EasyMock.createMock(Image.class);
        EasyMock.expect((Object)knownImage.getId()).andReturn((Object)"region/ami").anyTimes();
        EasyMock.expect((Object)knownImage.getProviderId()).andReturn((Object)"ami").anyTimes();
        EasyMock.expect((Object)knownImage.getLocation()).andReturn((Object)this.region).anyTimes();
        EasyMock.expect((Object)optionsProvider.get()).andReturn((Object)defaultOptions);
        EasyMock.replay((Object[])new Object[]{knownImage});
        EasyMock.replay((Object[])new Object[]{defaultOptions});
        EasyMock.replay((Object[])new Object[]{optionsProvider});
        EasyMock.replay((Object[])new Object[]{templateBuilderProvider});
        EC2TemplateBuilderImpl template = this.createTemplateBuilder(knownImage, (Supplier<Set<? extends Location>>)locations, (Supplier<Set<? extends Image>>)images, (Supplier<Set<? extends Hardware>>)sizes, this.region, (Provider<TemplateOptions>)optionsProvider, (Provider<TemplateBuilder>)templateBuilderProvider);
        try {
            template.imageId("ami").build();
            Assert.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        EasyMock.verify((Object[])new Object[]{knownImage});
        EasyMock.verify((Object[])new Object[]{defaultOptions});
        EasyMock.verify((Object[])new Object[]{optionsProvider});
        EasyMock.verify((Object[])new Object[]{templateBuilderProvider});
    }

    @Test(expectedExceptions={NoSuchElementException.class})
    public void testParseOnDemandNotFound() {
        Supplier locations = Suppliers.ofInstance((Object)ImmutableSet.of((Object)this.region));
        Supplier images = Suppliers.ofInstance((Object)ImmutableSet.of());
        Supplier sizes = Suppliers.ofInstance((Object)ImmutableSet.of((Object)EC2HardwareBuilder.c1_medium().build()));
        Location defaultLocation = (Location)EasyMock.createMock(Location.class);
        Provider optionsProvider = (Provider)EasyMock.createMock(Provider.class);
        Provider templateBuilderProvider = (Provider)EasyMock.createMock(Provider.class);
        TemplateOptions defaultOptions = (TemplateOptions)EasyMock.createMock(TemplateOptions.class);
        Image knownImage = (Image)EasyMock.createMock(Image.class);
        EasyMock.expect((Object)knownImage.getId()).andReturn((Object)"region/ami").anyTimes();
        EasyMock.expect((Object)knownImage.getProviderId()).andReturn((Object)"ami").anyTimes();
        EasyMock.expect((Object)knownImage.getLocation()).andReturn((Object)this.region).anyTimes();
        EasyMock.expect((Object)defaultLocation.getId()).andReturn((Object)"region");
        EasyMock.expect((Object)optionsProvider.get()).andReturn((Object)defaultOptions);
        EasyMock.replay((Object[])new Object[]{knownImage});
        EasyMock.replay((Object[])new Object[]{defaultOptions});
        EasyMock.replay((Object[])new Object[]{defaultLocation});
        EasyMock.replay((Object[])new Object[]{optionsProvider});
        EasyMock.replay((Object[])new Object[]{templateBuilderProvider});
        EC2TemplateBuilderImpl template = this.createTemplateBuilder(knownImage, (Supplier<Set<? extends Location>>)locations, (Supplier<Set<? extends Image>>)images, (Supplier<Set<? extends Hardware>>)sizes, defaultLocation, (Provider<TemplateOptions>)optionsProvider, (Provider<TemplateBuilder>)templateBuilderProvider);
        Assert.assertEquals((Object)template.imageId("region/bad").build().getImage(), (Object)knownImage);
        EasyMock.verify((Object[])new Object[]{knownImage});
        EasyMock.verify((Object[])new Object[]{defaultOptions});
        EasyMock.verify((Object[])new Object[]{defaultLocation});
        EasyMock.verify((Object[])new Object[]{optionsProvider});
        EasyMock.verify((Object[])new Object[]{templateBuilderProvider});
    }
}

