/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.compute.loaders;

import com.google.common.collect.ImmutableSet;
import org.easymock.EasyMock;
import org.jclouds.ec2.EC2Client;
import org.jclouds.ec2.compute.domain.RegionAndName;
import org.jclouds.ec2.compute.loaders.LoadPublicIpForInstanceOrNull;
import org.jclouds.ec2.domain.PublicIpInstanceIdPair;
import org.jclouds.ec2.services.ElasticIPAddressClient;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, singleThreaded=true, testName="LoadPublicIpForInstanceOrNullTest")
public class LoadPublicIpForInstanceOrNullTest {
    @Test
    public void testReturnsPublicIpOnMatch() throws Exception {
        EC2Client client = (EC2Client)EasyMock.createMock(EC2Client.class);
        ElasticIPAddressClient ipClient = (ElasticIPAddressClient)EasyMock.createMock(ElasticIPAddressClient.class);
        EasyMock.expect((Object)client.getElasticIPAddressServices()).andReturn((Object)ipClient).atLeastOnce();
        EasyMock.expect((Object)ipClient.describeAddressesInRegion("region", new String[0])).andReturn((Object)ImmutableSet.of((Object)new PublicIpInstanceIdPair("region", "1.1.1.1", "i-blah"))).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{client});
        EasyMock.replay((Object[])new Object[]{ipClient});
        LoadPublicIpForInstanceOrNull parser = new LoadPublicIpForInstanceOrNull(client);
        Assert.assertEquals((String)parser.load(new RegionAndName("region", "i-blah")), (String)"1.1.1.1");
        EasyMock.verify((Object[])new Object[]{client});
        EasyMock.verify((Object[])new Object[]{ipClient});
    }

    @Test
    public void testReturnsNullWhenNotFound() throws Exception {
        EC2Client client = (EC2Client)EasyMock.createMock(EC2Client.class);
        ElasticIPAddressClient ipClient = (ElasticIPAddressClient)EasyMock.createMock(ElasticIPAddressClient.class);
        EasyMock.expect((Object)client.getElasticIPAddressServices()).andReturn((Object)ipClient).atLeastOnce();
        EasyMock.expect((Object)ipClient.describeAddressesInRegion("region", new String[0])).andReturn((Object)ImmutableSet.of()).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{client});
        EasyMock.replay((Object[])new Object[]{ipClient});
        LoadPublicIpForInstanceOrNull parser = new LoadPublicIpForInstanceOrNull(client);
        Assert.assertEquals((String)parser.load(new RegionAndName("region", "i-blah")), null);
        EasyMock.verify((Object[])new Object[]{client});
        EasyMock.verify((Object[])new Object[]{ipClient});
    }

    @Test
    public void testReturnsNullWhenNotAssigned() throws Exception {
        EC2Client client = (EC2Client)EasyMock.createMock(EC2Client.class);
        ElasticIPAddressClient ipClient = (ElasticIPAddressClient)EasyMock.createMock(ElasticIPAddressClient.class);
        EasyMock.expect((Object)client.getElasticIPAddressServices()).andReturn((Object)ipClient).atLeastOnce();
        EasyMock.expect((Object)ipClient.describeAddressesInRegion("region", new String[0])).andReturn((Object)ImmutableSet.of((Object)new PublicIpInstanceIdPair("region", "1.1.1.1", null))).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{client});
        EasyMock.replay((Object[])new Object[]{ipClient});
        LoadPublicIpForInstanceOrNull parser = new LoadPublicIpForInstanceOrNull(client);
        Assert.assertEquals((String)parser.load(new RegionAndName("region", "i-blah")), null);
        EasyMock.verify((Object[])new Object[]{client});
        EasyMock.verify((Object[])new Object[]{ipClient});
    }
}

