/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.compute.loaders;

import com.google.common.collect.ImmutableSet;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.easymock.EasyMock;
import org.jclouds.compute.domain.Image;
import org.jclouds.ec2.EC2Client;
import org.jclouds.ec2.compute.domain.RegionAndName;
import org.jclouds.ec2.compute.functions.EC2ImageParser;
import org.jclouds.ec2.compute.loaders.RegionAndIdToImage;
import org.jclouds.ec2.options.DescribeImagesOptions;
import org.jclouds.ec2.services.AMIClient;
import org.jclouds.rest.ResourceNotFoundException;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class RegionAndIdToImageTest {
    @Test
    public void testApply() throws ExecutionException {
        EC2ImageParser parser = (EC2ImageParser)EasyMock.createMock(EC2ImageParser.class);
        EC2Client caller = (EC2Client)EasyMock.createMock(EC2Client.class);
        AMIClient client = (AMIClient)EasyMock.createMock(AMIClient.class);
        org.jclouds.ec2.domain.Image ec2Image = (org.jclouds.ec2.domain.Image)EasyMock.createMock(org.jclouds.ec2.domain.Image.class);
        Image image = (Image)EasyMock.createNiceMock(Image.class);
        ImmutableSet images = ImmutableSet.of((Object)ec2Image);
        EasyMock.expect((Object)caller.getAMIServices()).andReturn((Object)client).atLeastOnce();
        EasyMock.expect((Object)client.describeImagesInRegion("region", new DescribeImagesOptions[]{DescribeImagesOptions.Builder.imageIds((String[])new String[]{"ami"})})).andReturn(Set.class.cast(images));
        EasyMock.expect((Object)parser.apply(ec2Image)).andReturn((Object)image);
        EasyMock.replay((Object[])new Object[]{caller});
        EasyMock.replay((Object[])new Object[]{image});
        EasyMock.replay((Object[])new Object[]{parser});
        EasyMock.replay((Object[])new Object[]{client});
        RegionAndIdToImage function = new RegionAndIdToImage(parser, caller);
        Assert.assertEquals((Object)function.load(new RegionAndName("region", "ami")), (Object)image);
        EasyMock.verify((Object[])new Object[]{caller});
        EasyMock.verify((Object[])new Object[]{image});
        EasyMock.verify((Object[])new Object[]{image});
        EasyMock.verify((Object[])new Object[]{client});
    }

    @Test(expectedExceptions={ExecutionException.class})
    public void testApplyNotFoundMakesExecutionException() throws ExecutionException {
        EC2ImageParser parser = (EC2ImageParser)EasyMock.createMock(EC2ImageParser.class);
        EC2Client caller = (EC2Client)EasyMock.createMock(EC2Client.class);
        AMIClient client = (AMIClient)EasyMock.createMock(AMIClient.class);
        org.jclouds.ec2.domain.Image ec2Image = (org.jclouds.ec2.domain.Image)EasyMock.createMock(org.jclouds.ec2.domain.Image.class);
        Image image = (Image)EasyMock.createNiceMock(Image.class);
        ImmutableSet images = ImmutableSet.of((Object)ec2Image);
        EasyMock.expect((Object)caller.getAMIServices()).andReturn((Object)client).atLeastOnce();
        EasyMock.expect((Object)client.describeImagesInRegion("region", new DescribeImagesOptions[]{DescribeImagesOptions.Builder.imageIds((String[])new String[]{"ami"})})).andReturn(Set.class.cast(images));
        EasyMock.expect((Object)parser.apply(ec2Image)).andThrow((Throwable)new ResourceNotFoundException());
        EasyMock.replay((Object[])new Object[]{caller});
        EasyMock.replay((Object[])new Object[]{image});
        EasyMock.replay((Object[])new Object[]{parser});
        EasyMock.replay((Object[])new Object[]{client});
        RegionAndIdToImage function = new RegionAndIdToImage(parser, caller);
        Assert.assertEquals((Object)function.load(new RegionAndName("region", "ami")), null);
        EasyMock.verify((Object[])new Object[]{caller});
        EasyMock.verify((Object[])new Object[]{image});
        EasyMock.verify((Object[])new Object[]{parser});
        EasyMock.verify((Object[])new Object[]{client});
    }

    @Test(expectedExceptions={ExecutionException.class})
    public void testApplyNoSuchElementExceptionMakesExecutionException() throws ExecutionException {
        EC2ImageParser parser = (EC2ImageParser)EasyMock.createMock(EC2ImageParser.class);
        EC2Client caller = (EC2Client)EasyMock.createMock(EC2Client.class);
        AMIClient client = (AMIClient)EasyMock.createMock(AMIClient.class);
        org.jclouds.ec2.domain.Image ec2Image = (org.jclouds.ec2.domain.Image)EasyMock.createMock(org.jclouds.ec2.domain.Image.class);
        Image image = (Image)EasyMock.createNiceMock(Image.class);
        ImmutableSet images = ImmutableSet.of((Object)ec2Image);
        EasyMock.expect((Object)caller.getAMIServices()).andReturn((Object)client).atLeastOnce();
        EasyMock.expect((Object)client.describeImagesInRegion("region", new DescribeImagesOptions[]{DescribeImagesOptions.Builder.imageIds((String[])new String[]{"ami"})})).andReturn(Set.class.cast(images));
        EasyMock.expect((Object)parser.apply(ec2Image)).andThrow((Throwable)new NoSuchElementException());
        EasyMock.replay((Object[])new Object[]{caller});
        EasyMock.replay((Object[])new Object[]{image});
        EasyMock.replay((Object[])new Object[]{parser});
        EasyMock.replay((Object[])new Object[]{client});
        RegionAndIdToImage function = new RegionAndIdToImage(parser, caller);
        Assert.assertEquals((Object)function.load(new RegionAndName("region", "ami")), null);
        EasyMock.verify((Object[])new Object[]{caller});
        EasyMock.verify((Object[])new Object[]{image});
        EasyMock.verify((Object[])new Object[]{parser});
        EasyMock.verify((Object[])new Object[]{client});
    }
}

