/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.features;

import org.jclouds.ec2.EC2Api;
import org.jclouds.ec2.features.WindowsApi;
import org.jclouds.ec2.internal.BaseEC2ApiExpectTest;
import org.jclouds.ec2.parse.GetPasswordDataResponseTest;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="WindowsApiExpectTest")
public class WindowsApiExpectTest
extends BaseEC2ApiExpectTest<EC2Api> {
    HttpRequest get = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ec2.us-east-1.amazonaws.com/").addHeader("Host", new String[]{"ec2.us-east-1.amazonaws.com"})).payload(WindowsApiExpectTest.payloadFromStringWithContentType((String)"Action=GetPasswordData&InstanceId=i-2574e22a&Signature=vX1Tskc4VuBUWPqsJ%2BzcjEj6/2iMCKzqjWnKFXRkDdA%3D&SignatureMethod=HmacSHA256&SignatureVersion=2&Timestamp=2012-04-16T15%3A54%3A08.897Z&Version=2010-06-15&AWSAccessKeyId=identity", (String)"application/x-www-form-urlencoded"))).build();

    public void testGetPasswordDataWhenResponseIs2xx() throws Exception {
        HttpResponse getResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResourceWithContentType("/get_passworddata.xml", "text/xml"))).build();
        EC2Api apiWhenExist = (EC2Api)this.requestSendsResponse(this.get, getResponse);
        Assert.assertEquals((String)((WindowsApi)apiWhenExist.getWindowsApi().get()).getPasswordDataForInstance("i-2574e22a").toString(), (String)new GetPasswordDataResponseTest().expected().toString());
    }

    public void testGetPasswordDataWhenResponseIs404() throws Exception {
        HttpResponse getResponse = HttpResponse.builder().statusCode(404).build();
        EC2Api apiWhenDontExist = (EC2Api)this.requestSendsResponse(this.get, getResponse);
        Assert.assertNull((Object)((WindowsApi)apiWhenDontExist.getWindowsApi().get()).getPasswordDataForInstance("i-2574e22a"));
    }
}

