/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.options;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import org.jclouds.ec2.options.CreateImageOptions;
import org.jclouds.http.options.HttpRequestOptions;
import org.testng.Assert;
import org.testng.annotations.Test;

public class CreateImageOptionsTest {
    @Test
    public void testAssignability() {
        assert (HttpRequestOptions.class.isAssignableFrom(CreateImageOptions.class));
        assert (!String.class.isAssignableFrom(CreateImageOptions.class));
    }

    @Test
    public void testWithDescription() {
        CreateImageOptions options = new CreateImageOptions();
        options.withDescription("test");
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"Description"), (Collection)ImmutableList.of((Object)"test"));
    }

    @Test
    public void testNullWithDescription() {
        CreateImageOptions options = new CreateImageOptions();
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"Description"), (Collection)ImmutableList.of());
    }

    @Test
    public void testWithDescriptionStatic() {
        CreateImageOptions options = CreateImageOptions.Builder.withDescription((String)"test");
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"Description"), (Collection)ImmutableList.of((Object)"test"));
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testWithDescriptionNPE() {
        CreateImageOptions.Builder.withDescription(null);
    }

    @Test
    public void testNoReboot() {
        CreateImageOptions options = new CreateImageOptions();
        options.noReboot();
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"NoReboot"), (Collection)ImmutableList.of((Object)"true"));
    }

    @Test
    public void testNoRebootStatic() {
        CreateImageOptions options = CreateImageOptions.Builder.noReboot();
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"NoReboot"), (Collection)ImmutableList.of((Object)"true"));
    }
}

