/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.options;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import org.jclouds.ec2.options.DetachVolumeOptions;
import org.jclouds.http.options.HttpRequestOptions;
import org.testng.Assert;
import org.testng.annotations.Test;

public class DetachVolumeOptionsTest {
    @Test
    public void testAssignability() {
        assert (HttpRequestOptions.class.isAssignableFrom(DetachVolumeOptions.class));
        assert (!String.class.isAssignableFrom(DetachVolumeOptions.class));
    }

    @Test
    public void testFromDevice() {
        DetachVolumeOptions options = new DetachVolumeOptions();
        options.fromDevice("test");
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"Device"), (Collection)ImmutableList.of((Object)"test"));
    }

    @Test
    public void testNullFromDevice() {
        DetachVolumeOptions options = new DetachVolumeOptions();
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"Device"), (Collection)ImmutableList.of());
    }

    @Test
    public void testFromDeviceStatic() {
        DetachVolumeOptions options = DetachVolumeOptions.Builder.fromDevice((String)"test");
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"Device"), (Collection)ImmutableList.of((Object)"test"));
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testFromDeviceNPE() {
        DetachVolumeOptions.Builder.fromDevice(null);
    }

    @Test
    public void testFromInstance() {
        DetachVolumeOptions options = new DetachVolumeOptions();
        options.fromInstance("test");
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"InstanceId"), (Collection)ImmutableList.of((Object)"test"));
    }

    @Test
    public void testNullFromInstance() {
        DetachVolumeOptions options = new DetachVolumeOptions();
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"InstanceId"), (Collection)ImmutableList.of());
    }

    @Test
    public void testFromInstanceStatic() {
        DetachVolumeOptions options = DetachVolumeOptions.Builder.fromInstance((String)"test");
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"InstanceId"), (Collection)ImmutableList.of((Object)"test"));
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testFromInstanceNPE() {
        DetachVolumeOptions.Builder.fromInstance(null);
    }
}

