/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.services;

import com.google.common.collect.Sets;
import java.util.LinkedHashSet;
import java.util.TreeSet;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.compute.internal.BaseComputeServiceContextLiveTest;
import org.jclouds.ec2.EC2ApiMetadata;
import org.jclouds.ec2.EC2Client;
import org.jclouds.ec2.domain.KeyPair;
import org.jclouds.ec2.services.KeyPairClient;
import org.jclouds.rest.RestContext;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"live"}, singleThreaded=true, testName="KeyPairClientLiveTest")
public class KeyPairClientLiveTest
extends BaseComputeServiceContextLiveTest {
    private EC2Client ec2Client;
    private KeyPairClient client;
    public static final String PREFIX = System.getProperty("user.name") + "-ec2";

    public KeyPairClientLiveTest() {
        this.provider = "ec2";
    }

    @BeforeClass(groups={"integration", "live"})
    public void setupContext() {
        super.setupContext();
        this.ec2Client = (EC2Client)((RestContext)((ComputeServiceContext)this.view).unwrap(EC2ApiMetadata.CONTEXT_TOKEN)).getApi();
        this.client = this.ec2Client.getKeyPairServices();
    }

    @Test
    void testDescribeKeyPairs() {
        for (String region : this.ec2Client.getConfiguredRegions()) {
            TreeSet allResults = Sets.newTreeSet((Iterable)this.client.describeKeyPairsInRegion(region, new String[0]));
            Assert.assertNotNull((Object)allResults);
            if (allResults.size() < 1) continue;
            KeyPair pair = (KeyPair)allResults.last();
            TreeSet result = Sets.newTreeSet((Iterable)this.client.describeKeyPairsInRegion(region, new String[]{pair.getKeyName()}));
            Assert.assertNotNull((Object)result);
            KeyPair compare = (KeyPair)result.last();
            Assert.assertEquals((Object)compare, (Object)pair);
        }
    }

    @Test
    void testCreateKeyPair() {
        String keyName = PREFIX + "1";
        try {
            this.client.deleteKeyPairInRegion(null, keyName);
        }
        catch (Exception e) {
            // empty catch block
        }
        this.client.deleteKeyPairInRegion(null, keyName);
        KeyPair result = this.client.createKeyPairInRegion(null, keyName);
        Assert.assertNotNull((Object)result);
        Assert.assertNotNull((Object)result.getKeyMaterial());
        Assert.assertNotNull((Object)result.getSha1OfPrivateKey());
        Assert.assertEquals((String)result.getKeyName(), (String)keyName);
        LinkedHashSet twoResults = Sets.newLinkedHashSet((Iterable)this.client.describeKeyPairsInRegion(null, new String[]{keyName}));
        Assert.assertNotNull((Object)twoResults);
        Assert.assertEquals((int)twoResults.size(), (int)1);
        KeyPair listPair = (KeyPair)twoResults.iterator().next();
        Assert.assertEquals((String)listPair.getKeyName(), (String)result.getKeyName());
        Assert.assertEquals((String)listPair.getSha1OfPrivateKey(), (String)result.getSha1OfPrivateKey());
    }
}

