/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.services;

import com.google.common.collect.Lists;
import com.google.common.reflect.Invokable;
import java.io.IOException;
import java.util.List;
import org.jclouds.Fallbacks;
import org.jclouds.ec2.domain.IpProtocol;
import org.jclouds.ec2.domain.UserIdGroupPair;
import org.jclouds.ec2.services.BaseEC2AsyncClientTest;
import org.jclouds.ec2.services.SecurityGroupAsyncClient;
import org.jclouds.ec2.xml.DescribeSecurityGroupsResponseHandler;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpRequestFilter;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.http.functions.ReleasePayloadAndReturn;
import org.jclouds.reflect.Reflection2;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="SecurityGroupAsyncClientTest")
public class SecurityGroupAsyncClientTest
extends BaseEC2AsyncClientTest<SecurityGroupAsyncClient> {
    HttpRequest createSecurityGroup = ((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ec2.us-east-1.amazonaws.com/").addHeader("Host", new String[]{"ec2.us-east-1.amazonaws.com"})).addFormParam("Action", new String[]{"CreateSecurityGroup"}).addFormParam("GroupDescription", new String[]{"description"}).addFormParam("GroupName", new String[]{"name"}).addFormParam("Signature", new String[]{"F3o0gnZcX9sWrtDUhVwi3k5GY2JKLP0Dhi6CcEqK2vE%3D"}).addFormParam("SignatureMethod", new String[]{"HmacSHA256"}).addFormParam("SignatureVersion", new String[]{"2"}).addFormParam("Timestamp", new String[]{"2009-11-08T15%3A54%3A08.897Z"}).addFormParam("Version", new String[]{"2010-06-15"}).addFormParam("AWSAccessKeyId", new String[]{"identity"}).build();
    HttpRequest authorizeSecurityGroupIngressCidr = ((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ec2.us-east-1.amazonaws.com/").addHeader("Host", new String[]{"ec2.us-east-1.amazonaws.com"})).addFormParam("Action", new String[]{"AuthorizeSecurityGroupIngress"}).addFormParam("CidrIp", new String[]{"0.0.0.0/0"}).addFormParam("FromPort", new String[]{"6000"}).addFormParam("GroupName", new String[]{"group"}).addFormParam("IpProtocol", new String[]{"tcp"}).addFormParam("Signature", new String[]{"6NQega9YUGDxdwk3Y0Hv71u/lHi%2B0D6qMCJLpJVD/aI%3D"}).addFormParam("SignatureMethod", new String[]{"HmacSHA256"}).addFormParam("SignatureVersion", new String[]{"2"}).addFormParam("Timestamp", new String[]{"2009-11-08T15%3A54%3A08.897Z"}).addFormParam("ToPort", new String[]{"7000"}).addFormParam("Version", new String[]{"2010-06-15"}).addFormParam("AWSAccessKeyId", new String[]{"identity"}).build();
    HttpRequest revokeSecurityGroupIngressCidr = ((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ec2.us-east-1.amazonaws.com/").addHeader("Host", new String[]{"ec2.us-east-1.amazonaws.com"})).addFormParam("Action", new String[]{"RevokeSecurityGroupIngress"}).addFormParam("CidrIp", new String[]{"0.0.0.0/0"}).addFormParam("FromPort", new String[]{"6000"}).addFormParam("GroupName", new String[]{"group"}).addFormParam("IpProtocol", new String[]{"tcp"}).addFormParam("Signature", new String[]{"WPlDYXI8P6Ip4F2JIEP3lWrVlP/7gxbZvlshKYlrvxk%3D"}).addFormParam("SignatureMethod", new String[]{"HmacSHA256"}).addFormParam("SignatureVersion", new String[]{"2"}).addFormParam("Timestamp", new String[]{"2009-11-08T15%3A54%3A08.897Z"}).addFormParam("ToPort", new String[]{"7000"}).addFormParam("Version", new String[]{"2010-06-15"}).addFormParam("AWSAccessKeyId", new String[]{"identity"}).build();

    public void testDeleteSecurityGroup() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(SecurityGroupAsyncClient.class, (String)"deleteSecurityGroupInRegion", (Class[])new Class[]{String.class, String.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)Lists.newArrayList((Object[])new Object[]{null, "name"}));
        this.assertRequestLineEquals((HttpRequest)request, "POST https://ec2.us-east-1.amazonaws.com/ HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Host: ec2.us-east-1.amazonaws.com\n");
        this.assertPayloadEquals((HttpRequest)request, "Action=DeleteSecurityGroup&GroupName=name", "application/x-www-form-urlencoded", false);
        this.assertResponseParserClassEquals(method, request, ReleasePayloadAndReturn.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, Fallbacks.VoidOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testCreateSecurityGroup() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(SecurityGroupAsyncClient.class, (String)"createSecurityGroupInRegion", (Class[])new Class[]{String.class, String.class, String.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)Lists.newArrayList((Object[])new Object[]{null, "name", "description"}));
        request = (GeneratedHttpRequest)((HttpRequestFilter)request.getFilters().get(0)).filter((HttpRequest)request);
        this.assertRequestLineEquals((HttpRequest)request, "POST https://ec2.us-east-1.amazonaws.com/ HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Host: ec2.us-east-1.amazonaws.com\n");
        this.assertPayloadEquals((HttpRequest)request, this.createSecurityGroup.getPayload().getRawContent().toString(), "application/x-www-form-urlencoded", false);
        this.assertResponseParserClassEquals(method, request, ReleasePayloadAndReturn.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testDescribeSecurityGroups() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(SecurityGroupAsyncClient.class, (String)"describeSecurityGroupsInRegion", (Class[])new Class[]{String.class, String[].class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)Lists.newArrayList((Object[])new Object[]{null}));
        this.assertRequestLineEquals((HttpRequest)request, "POST https://ec2.us-east-1.amazonaws.com/ HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Host: ec2.us-east-1.amazonaws.com\n");
        this.assertPayloadEquals((HttpRequest)request, "Action=DescribeSecurityGroups", "application/x-www-form-urlencoded", false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, DescribeSecurityGroupsResponseHandler.class);
        this.assertFallbackClassEquals(method, Fallbacks.EmptySetOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testDescribeSecurityGroupsArgs() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(SecurityGroupAsyncClient.class, (String)"describeSecurityGroupsInRegion", (Class[])new Class[]{String.class, String[].class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)Lists.newArrayList((Object[])new Object[]{null, "1", "2"}));
        this.assertRequestLineEquals((HttpRequest)request, "POST https://ec2.us-east-1.amazonaws.com/ HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Host: ec2.us-east-1.amazonaws.com\n");
        this.assertPayloadEquals((HttpRequest)request, "Action=DescribeSecurityGroups&GroupName.1=1&GroupName.2=2", "application/x-www-form-urlencoded", false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, DescribeSecurityGroupsResponseHandler.class);
        this.assertFallbackClassEquals(method, Fallbacks.EmptySetOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testAuthorizeSecurityGroupIngressGroup() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(SecurityGroupAsyncClient.class, (String)"authorizeSecurityGroupIngressInRegion", (Class[])new Class[]{String.class, String.class, UserIdGroupPair.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)Lists.newArrayList((Object[])new Object[]{null, "group", new UserIdGroupPair("sourceUser", "sourceGroup")}));
        this.assertRequestLineEquals((HttpRequest)request, "POST https://ec2.us-east-1.amazonaws.com/ HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Host: ec2.us-east-1.amazonaws.com\n");
        this.assertPayloadEquals((HttpRequest)request, "Action=AuthorizeSecurityGroupIngress&GroupName=group&SourceSecurityGroupOwnerId=sourceUser&SourceSecurityGroupName=sourceGroup", "application/x-www-form-urlencoded", false);
        this.assertResponseParserClassEquals(method, request, ReleasePayloadAndReturn.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testAuthorizeSecurityGroupIngressCidr() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(SecurityGroupAsyncClient.class, (String)"authorizeSecurityGroupIngressInRegion", (Class[])new Class[]{String.class, String.class, IpProtocol.class, Integer.TYPE, Integer.TYPE, String.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)Lists.newArrayList((Object[])new Object[]{null, "group", IpProtocol.TCP, 6000, 7000, "0.0.0.0/0"}));
        request = (GeneratedHttpRequest)((HttpRequestFilter)request.getFilters().get(0)).filter((HttpRequest)request);
        this.assertRequestLineEquals((HttpRequest)request, "POST https://ec2.us-east-1.amazonaws.com/ HTTP/1.1");
        this.assertPayloadEquals((HttpRequest)request, this.authorizeSecurityGroupIngressCidr.getPayload().getRawContent().toString(), "application/x-www-form-urlencoded", false);
        this.assertResponseParserClassEquals(method, request, ReleasePayloadAndReturn.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testRevokeSecurityGroupIngressGroup() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(SecurityGroupAsyncClient.class, (String)"revokeSecurityGroupIngressInRegion", (Class[])new Class[]{String.class, String.class, UserIdGroupPair.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)Lists.newArrayList((Object[])new Object[]{null, "group", new UserIdGroupPair("sourceUser", "sourceGroup")}));
        this.assertRequestLineEquals((HttpRequest)request, "POST https://ec2.us-east-1.amazonaws.com/ HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Host: ec2.us-east-1.amazonaws.com\n");
        this.assertPayloadEquals((HttpRequest)request, "Action=RevokeSecurityGroupIngress&GroupName=group&SourceSecurityGroupOwnerId=sourceUser&SourceSecurityGroupName=sourceGroup", "application/x-www-form-urlencoded", false);
        this.assertResponseParserClassEquals(method, request, ReleasePayloadAndReturn.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testRevokeSecurityGroupIngressCidr() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(SecurityGroupAsyncClient.class, (String)"revokeSecurityGroupIngressInRegion", (Class[])new Class[]{String.class, String.class, IpProtocol.class, Integer.TYPE, Integer.TYPE, String.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)Lists.newArrayList((Object[])new Object[]{null, "group", IpProtocol.TCP, 6000, 7000, "0.0.0.0/0"}));
        request = (GeneratedHttpRequest)((HttpRequestFilter)request.getFilters().get(0)).filter((HttpRequest)request);
        this.assertRequestLineEquals((HttpRequest)request, "POST https://ec2.us-east-1.amazonaws.com/ HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Host: ec2.us-east-1.amazonaws.com\n");
        this.assertPayloadEquals((HttpRequest)request, this.revokeSecurityGroupIngressCidr.getPayload().getRawContent().toString(), "application/x-www-form-urlencoded", false);
        this.assertResponseParserClassEquals(method, request, ReleasePayloadAndReturn.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }
}

