/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.services;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Set;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.compute.internal.BaseComputeServiceContextLiveTest;
import org.jclouds.ec2.EC2ApiMetadata;
import org.jclouds.ec2.EC2Client;
import org.jclouds.ec2.domain.IpPermission;
import org.jclouds.ec2.domain.IpProtocol;
import org.jclouds.ec2.domain.SecurityGroup;
import org.jclouds.ec2.domain.UserIdGroupPair;
import org.jclouds.ec2.services.SecurityGroupClient;
import org.jclouds.rest.RestContext;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"live"}, singleThreaded=true, testName="SecurityGroupClientLiveTest")
public class SecurityGroupClientLiveTest
extends BaseComputeServiceContextLiveTest {
    private EC2Client ec2Client;
    protected SecurityGroupClient client;
    private static final int INCONSISTENCY_WINDOW = 5000;
    public static final String PREFIX = System.getProperty("user.name") + "-ec2";

    public SecurityGroupClientLiveTest() {
        this.provider = "ec2";
    }

    @BeforeClass(groups={"integration", "live"})
    public void setupContext() {
        super.setupContext();
        this.ec2Client = (EC2Client)((RestContext)((ComputeServiceContext)this.view).unwrap(EC2ApiMetadata.CONTEXT_TOKEN)).getApi();
        this.client = this.ec2Client.getSecurityGroupServices();
    }

    @Test
    void testDescribe() {
        for (String region : this.ec2Client.getConfiguredRegions()) {
            Set allResults = this.client.describeSecurityGroupsInRegion(region, new String[0]);
            Assert.assertNotNull((Object)allResults);
            if (allResults.size() < 1) continue;
            final SecurityGroup group = (SecurityGroup)Iterables.getLast((Iterable)allResults);
            ImmutableSet expected = FluentIterable.from((Iterable)allResults).filter((Predicate)new Predicate<SecurityGroup>(){

                public boolean apply(SecurityGroup in) {
                    return group.getName().equals(in.getName());
                }
            }).toSet();
            ImmutableSet result = ImmutableSet.copyOf((Collection)this.client.describeSecurityGroupsInRegion(region, new String[]{group.getName()}));
            Assert.assertTrue((boolean)expected.containsAll((Collection)result));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testCreateSecurityGroup() {
        String groupName = PREFIX + "1";
        this.cleanupAndSleep(groupName);
        try {
            String groupDescription = PREFIX + "1 description";
            this.client.deleteSecurityGroupInRegion(null, groupName);
            this.client.createSecurityGroupInRegion(null, groupName, groupDescription);
            this.verifySecurityGroup(groupName, groupDescription);
        }
        finally {
            this.client.deleteSecurityGroupInRegion(null, groupName);
        }
    }

    protected void cleanupAndSleep(String groupName) {
        try {
            this.client.deleteSecurityGroupInRegion(null, groupName);
            Thread.sleep(2000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testAuthorizeSecurityGroupIngressCidr() {
        String groupName = PREFIX + "ingress";
        this.cleanupAndSleep(groupName);
        try {
            this.client.createSecurityGroupInRegion(null, groupName, groupName);
            this.client.authorizeSecurityGroupIngressInRegion(null, groupName, IpProtocol.TCP, 80, 80, "0.0.0.0/0");
            SecurityGroupClientLiveTest.assertEventually(new GroupHasPermission(this.client, groupName, new TCPPort80AllIPs()));
            this.client.revokeSecurityGroupIngressInRegion(null, groupName, IpProtocol.TCP, 80, 80, "0.0.0.0/0");
            SecurityGroupClientLiveTest.assertEventually(new GroupHasNoPermissions(this.client, groupName));
        }
        finally {
            this.client.deleteSecurityGroupInRegion(null, groupName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testAuthorizeSecurityGroupIngressSourcePort() {
        String groupName = PREFIX + "ingress";
        this.cleanupAndSleep(groupName);
        try {
            this.client.createSecurityGroupInRegion(null, groupName, groupName);
            this.client.authorizeSecurityGroupIngressInRegion(null, groupName, IpProtocol.TCP, 80, 80, "0.0.0.0/0");
            SecurityGroupClientLiveTest.assertEventually(new GroupHasPermission(this.client, groupName, new TCPPort80AllIPs()));
            this.client.revokeSecurityGroupIngressInRegion(null, groupName, IpProtocol.TCP, 80, 80, "0.0.0.0/0");
            SecurityGroupClientLiveTest.assertEventually(new GroupHasNoPermissions(this.client, groupName));
        }
        finally {
            this.client.deleteSecurityGroupInRegion(null, groupName);
        }
    }

    private void verifySecurityGroup(String groupName, String description) {
        Set oneResult = this.client.describeSecurityGroupsInRegion(null, new String[]{groupName});
        Assert.assertNotNull((Object)oneResult);
        Assert.assertEquals((int)oneResult.size(), (int)1);
        SecurityGroup listPair = (SecurityGroup)oneResult.iterator().next();
        Assert.assertEquals((String)listPair.getName(), (String)groupName);
        Assert.assertEquals((String)listPair.getDescription(), (String)description);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testAuthorizeSecurityGroupIngressSourceGroup() {
        final String group1Name = PREFIX + "ingress1";
        String group2Name = PREFIX + "ingress2";
        this.cleanupAndSleep(group2Name);
        this.cleanupAndSleep(group1Name);
        try {
            this.client.createSecurityGroupInRegion(null, group1Name, group1Name);
            this.client.createSecurityGroupInRegion(null, group2Name, group2Name);
            this.ensureGroupsExist(group1Name, group2Name);
            this.client.authorizeSecurityGroupIngressInRegion(null, group1Name, IpProtocol.TCP, 80, 80, "0.0.0.0/0");
            SecurityGroupClientLiveTest.assertEventually(new GroupHasPermission(this.client, group1Name, new TCPPort80AllIPs()));
            Set oneResult = this.client.describeSecurityGroupsInRegion(null, new String[]{group1Name});
            Assert.assertNotNull((Object)oneResult);
            Assert.assertEquals((int)oneResult.size(), (int)1);
            final SecurityGroup group = (SecurityGroup)oneResult.iterator().next();
            Assert.assertEquals((String)group.getName(), (String)group1Name);
            UserIdGroupPair to = new UserIdGroupPair(group.getOwnerId(), group1Name);
            this.client.authorizeSecurityGroupIngressInRegion(null, group2Name, to);
            SecurityGroupClientLiveTest.assertEventually(new GroupHasPermission(this.client, group2Name, new Predicate<IpPermission>(){

                public boolean apply(IpPermission arg0) {
                    return arg0.getUserIdGroupPairs().equals((Object)ImmutableMultimap.of((Object)group.getOwnerId(), (Object)group1Name));
                }
            }));
            this.client.revokeSecurityGroupIngressInRegion(null, group2Name, new UserIdGroupPair(group.getOwnerId(), group1Name));
            SecurityGroupClientLiveTest.assertEventually(new GroupHasNoPermissions(this.client, group2Name));
        }
        finally {
            this.client.deleteSecurityGroupInRegion(null, group2Name);
            this.client.deleteSecurityGroupInRegion(null, group1Name);
        }
    }

    protected void ensureGroupsExist(String group1Name, String group2Name) {
        Set twoResults = this.client.describeSecurityGroupsInRegion(null, new String[]{group1Name, group2Name});
        Assert.assertNotNull((Object)twoResults);
        Assert.assertTrue((twoResults.size() >= 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)Iterables.all((Iterable)twoResults, (Predicate)Predicates.compose((Predicate)Predicates.in((Collection)ImmutableSet.of((Object)group1Name, (Object)group2Name)), (Function)new Function<SecurityGroup, String>(){

            public String apply(SecurityGroup in) {
                return in.getName();
            }
        })));
    }

    protected static void assertEventually(Runnable assertion) {
        long start = System.currentTimeMillis();
        AssertionError error = null;
        for (int i = 0; i < 30; ++i) {
            try {
                assertion.run();
                if (i > 0) {
                    System.err.printf("%d attempts and %dms asserting %s%n", i + 1, System.currentTimeMillis() - start, assertion.getClass().getSimpleName());
                }
                return;
            }
            catch (AssertionError e) {
                error = e;
                try {
                    Thread.sleep(166L);
                }
                catch (InterruptedException e2) {
                    // empty catch block
                }
                continue;
            }
        }
        if (error != null) {
            throw error;
        }
    }

    public static final class GroupHasNoPermissions
    implements Runnable {
        private final SecurityGroupClient client;
        private final String group;

        public GroupHasNoPermissions(SecurityGroupClient client, String group) {
            this.client = client;
            this.group = group;
        }

        @Override
        public void run() {
            try {
                Set oneResult = this.client.describeSecurityGroupsInRegion(null, new String[]{this.group});
                Assert.assertNotNull((Object)oneResult);
                Assert.assertEquals((int)oneResult.size(), (int)1);
                SecurityGroup listPair = (SecurityGroup)oneResult.iterator().next();
                Assert.assertEquals((int)listPair.size(), (int)0);
            }
            catch (Exception e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    public static final class GroupHasPermission
    implements Runnable {
        private final SecurityGroupClient client;
        private final String group;
        private final Predicate<IpPermission> permission;

        public GroupHasPermission(SecurityGroupClient client, String group, Predicate<IpPermission> permission) {
            this.client = client;
            this.group = group;
            this.permission = permission;
        }

        @Override
        public void run() {
            try {
                Set oneResult = this.client.describeSecurityGroupsInRegion(null, new String[]{this.group});
                assert (Iterables.all((Iterable)((Iterable)Iterables.getOnlyElement((Iterable)oneResult)), this.permission)) : this.permission + ": " + oneResult;
            }
            catch (Exception e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    public final class TCPPort80AllIPs
    implements Predicate<IpPermission> {
        public boolean apply(IpPermission arg0) {
            return arg0.getIpProtocol() == IpProtocol.TCP && arg0.getFromPort() == 80 && arg0.getToPort() == 80 && arg0.getIpRanges().equals(ImmutableSet.of((Object)"0.0.0.0/0"));
        }
    }
}

