/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.util;

import com.google.common.collect.ImmutableSet;
import org.jclouds.ec2.domain.IpPermission;
import org.jclouds.ec2.domain.IpProtocol;
import org.jclouds.ec2.util.IpPermissions;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(testName="IpPermissionsTest")
public class IpPermissionsTest {
    public void testAllProtocol() {
        IpPermissions.ToSourceSelection authorization = IpPermissions.permitAnyProtocol();
        Assert.assertEquals((String)IpPermissions.buildFormParametersForIndex((int)0, (IpPermission)authorization).toString(), (String)"{IpPermissions.0.IpProtocol=[-1], IpPermissions.0.FromPort=[1], IpPermissions.0.ToPort=[65535], IpPermissions.0.IpRanges.0.CidrIp=[0.0.0.0/0]}");
    }

    public void testAllProtocolCidrBound() {
        IpPermissions authorization = IpPermissions.permit((IpProtocol)IpProtocol.ALL).originatingFromCidrBlock("1.1.1.1/32");
        Assert.assertEquals((String)IpPermissions.buildFormParametersForIndex((int)0, (IpPermission)authorization).toString(), (String)"{IpPermissions.0.IpProtocol=[-1], IpPermissions.0.FromPort=[1], IpPermissions.0.ToPort=[65535], IpPermissions.0.IpRanges.0.CidrIp=[1.1.1.1/32]}");
    }

    public void testJustProtocolAndCidr() {
        IpPermissions authorization = IpPermissions.permit((IpProtocol)IpProtocol.TCP).originatingFromCidrBlock("1.1.1.1/32");
        Assert.assertEquals((String)IpPermissions.buildFormParametersForIndex((int)0, (IpPermission)authorization).toString(), (String)"{IpPermissions.0.IpProtocol=[tcp], IpPermissions.0.FromPort=[1], IpPermissions.0.ToPort=[65535], IpPermissions.0.IpRanges.0.CidrIp=[1.1.1.1/32]}");
    }

    public void testAnyProtocol() {
        IpPermissions authorization = IpPermissions.permitAnyProtocol().originatingFromCidrBlock("1.1.1.1/32");
        Assert.assertEquals((String)IpPermissions.buildFormParametersForIndex((int)0, (IpPermission)authorization).toString(), (String)"{IpPermissions.0.IpProtocol=[-1], IpPermissions.0.FromPort=[1], IpPermissions.0.ToPort=[65535], IpPermissions.0.IpRanges.0.CidrIp=[1.1.1.1/32]}");
    }

    public void testMultipleCidrs() {
        IpPermissions authorization = IpPermissions.permit((IpProtocol)IpProtocol.TCP).originatingFromCidrBlocks((Iterable)ImmutableSet.of((Object)"1.1.1.1/32", (Object)"1.1.1.2/32"));
        Assert.assertEquals((String)IpPermissions.buildFormParametersForIndex((int)0, (IpPermission)authorization).toString(), (String)"{IpPermissions.0.IpProtocol=[tcp], IpPermissions.0.FromPort=[1], IpPermissions.0.ToPort=[65535], IpPermissions.0.IpRanges.0.CidrIp=[1.1.1.1/32], IpPermissions.0.IpRanges.1.CidrIp=[1.1.1.2/32]}");
    }

    public void testProtocolFromAndToPortAndGroupIds() {
        IpPermissions authorization = IpPermissions.permit((IpProtocol)IpProtocol.UDP).fromPort(11).to(53).originatingFromSecurityGroupId("groupId");
        Assert.assertEquals((String)IpPermissions.buildFormParametersForIndex((int)0, (IpPermission)authorization).toString(), (String)"{IpPermissions.0.IpProtocol=[udp], IpPermissions.0.FromPort=[11], IpPermissions.0.ToPort=[53], IpPermissions.0.Groups.0.GroupId=[groupId]}");
    }

    public void testProtocolICMPAny() {
        IpPermissions authorization = IpPermissions.permitICMP().originatingFromSecurityGroupId("groupId");
        Assert.assertEquals((String)IpPermissions.buildFormParametersForIndex((int)0, (IpPermission)authorization).toString(), (String)"{IpPermissions.0.IpProtocol=[icmp], IpPermissions.0.FromPort=[-1], IpPermissions.0.ToPort=[-1], IpPermissions.0.Groups.0.GroupId=[groupId]}");
    }

    public void testProtocolICMPTypeAnyCode() {
        IpPermissions authorization = IpPermissions.permitICMP().type(8).originatingFromSecurityGroupId("groupId");
        Assert.assertEquals((String)IpPermissions.buildFormParametersForIndex((int)0, (IpPermission)authorization).toString(), (String)"{IpPermissions.0.IpProtocol=[icmp], IpPermissions.0.FromPort=[8], IpPermissions.0.ToPort=[-1], IpPermissions.0.Groups.0.GroupId=[groupId]}");
    }

    public void testProtocolICMPTypeCode() {
        IpPermissions authorization = IpPermissions.permitICMP().type(8).andCode(0).originatingFromSecurityGroupId("groupId");
        Assert.assertEquals((String)IpPermissions.buildFormParametersForIndex((int)0, (IpPermission)authorization).toString(), (String)"{IpPermissions.0.IpProtocol=[icmp], IpPermissions.0.FromPort=[8], IpPermissions.0.ToPort=[0], IpPermissions.0.Groups.0.GroupId=[groupId]}");
    }

    public void testProtocolFromAndToPortAndUserGroups() {
        IpPermissions authorization = IpPermissions.permit((IpProtocol)IpProtocol.ICMP).originatingFromUserAndSecurityGroup("userId", "groupId");
        Assert.assertEquals((String)IpPermissions.buildFormParametersForIndex((int)0, (IpPermission)authorization).toString(), (String)"{IpPermissions.0.IpProtocol=[icmp], IpPermissions.0.FromPort=[-1], IpPermissions.0.ToPort=[-1], IpPermissions.0.Groups.0.UserId=[userId], IpPermissions.0.Groups.0.GroupName=[groupId]}");
    }
}

