/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.xml;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import java.io.InputStream;
import java.util.Map;
import java.util.Set;
import org.jclouds.ec2.compute.functions.EC2ImageParserTest;
import org.jclouds.ec2.domain.Hypervisor;
import org.jclouds.ec2.domain.Image;
import org.jclouds.ec2.domain.RootDeviceType;
import org.jclouds.ec2.domain.VirtualizationType;
import org.jclouds.ec2.xml.DescribeImagesResponseHandler;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.http.functions.config.SaxParserModule;
import org.jclouds.location.Region;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="DescribeImagesResponseHandlerTest")
public class DescribeImagesResponseHandlerTest {
    public void testUNIX() {
        ImmutableSet contents = ImmutableSet.of((Object)new Image("us-east-1", Image.Architecture.I386, null, null, "ami-be3adfd7", "ec2-public-images/fedora-8-i386-base-v1.04.manifest.xml", "206029621532", Image.ImageState.AVAILABLE, "available", Image.ImageType.MACHINE, false, (Iterable)Sets.newHashSet((Object[])new String[]{"9961934F"}), "aki-4438dd2d", null, "ari-4538dd2c", RootDeviceType.INSTANCE_STORE, null, (Map)ImmutableMap.of(), VirtualizationType.PARAVIRTUAL, Hypervisor.XEN));
        Set<Image> result = DescribeImagesResponseHandlerTest.parseImages("/describe_images.xml");
        Assert.assertEquals((String)result.toString(), (String)contents.toString());
        Assert.assertEquals((Object)((Image)Iterables.get(result, (int)0)).getImageState(), (Object)Image.ImageState.AVAILABLE);
        Assert.assertEquals((String)((Image)Iterables.get(result, (int)0)).getRawState(), (String)"available");
    }

    public void testWindows() {
        ImmutableSet contents = ImmutableSet.of((Object)new Image("us-east-1", Image.Architecture.X86_64, null, null, "ami-02eb086b", "aws-solutions-amis/SqlSvrStd2003r2-x86_64-Win_SFWBasic5.1-v1.0.manifest.xml", "771350841976", Image.ImageState.AVAILABLE, "available", Image.ImageType.MACHINE, true, (Iterable)Sets.newHashSet((Object[])new String[]{"5771E9A6"}), null, "windows", null, RootDeviceType.INSTANCE_STORE, null, (Map)ImmutableMap.of(), VirtualizationType.PARAVIRTUAL, Hypervisor.XEN));
        Set<Image> result = DescribeImagesResponseHandlerTest.parseImages("/describe_images_windows.xml");
        Assert.assertEquals((String)result.toString(), (String)contents.toString());
        Assert.assertEquals((Object)((Image)Iterables.get(result, (int)0)).getImageState(), (Object)Image.ImageState.AVAILABLE);
        Assert.assertEquals((String)((Image)Iterables.get(result, (int)0)).getRawState(), (String)"available");
    }

    public void testEBS() {
        ImmutableSet contents = ImmutableSet.of((Object)new Image("us-east-1", Image.Architecture.I386, "websrv_2009-12-10", "Web Server AMI", "ami-246f8d4d", "706093390852/websrv_2009-12-10", "706093390852", Image.ImageState.AVAILABLE, "available", Image.ImageType.MACHINE, true, (Iterable)Sets.newHashSet(), null, "windows", null, RootDeviceType.EBS, "/dev/sda1", (Map)ImmutableMap.of((Object)"/dev/sda1", (Object)new Image.EbsBlockDevice("snap-d01272b9", 30L, true), (Object)"xvdf", (Object)new Image.EbsBlockDevice("snap-d31272ba", 250L, false)), VirtualizationType.HVM, Hypervisor.XEN));
        Set<Image> result = DescribeImagesResponseHandlerTest.parseImages("/describe_images_ebs.xml");
        Assert.assertEquals((String)result.toString(), (String)contents.toString());
        Assert.assertEquals((Object)((Image)Iterables.get(result, (int)0)).getImageState(), (Object)Image.ImageState.AVAILABLE);
        Assert.assertEquals((String)((Image)Iterables.get(result, (int)0)).getRawState(), (String)"available");
    }

    public void testDiabloWithIncorrectDisplayNameField() {
        ImmutableSet contents = ImmutableSet.of((Object)new Image("us-east-1", Image.Architecture.X86_64, "CentOS 6.2 Server 64-bit 20120125", "", "ami-0000054e", "local (CentOS 6.2 Server 64-bit 20120125)", "", Image.ImageState.AVAILABLE, "available", Image.ImageType.MACHINE, true, (Iterable)Sets.newHashSet(), "aki-0000054c", null, "ari-0000054d", RootDeviceType.INSTANCE_STORE, "/dev/sda1", (Map)ImmutableMap.of(), VirtualizationType.PARAVIRTUAL, Hypervisor.XEN));
        Set<Image> result = DescribeImagesResponseHandlerTest.parseImages("/describe_images_nova.xml");
        Assert.assertEquals((String)result.toString(), (String)contents.toString());
        Assert.assertEquals((Object)((Image)Iterables.get(result, (int)0)).getImageState(), (Object)Image.ImageState.AVAILABLE);
        Assert.assertEquals((String)((Image)Iterables.get(result, (int)0)).getRawState(), (String)"available");
    }

    static ParseSax<Set<Image>> createParser() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new SaxParserModule(), new AbstractModule(){

            protected void configure() {
                this.bind((TypeLiteral)new TypeLiteral<Supplier<String>>(){}).annotatedWith(Region.class).toInstance((Object)Suppliers.ofInstance((Object)"us-east-1"));
            }
        }});
        ParseSax parser = ((ParseSax.Factory)injector.getInstance(ParseSax.Factory.class)).create((ParseSax.HandlerWithResult)injector.getInstance(DescribeImagesResponseHandler.class));
        return parser;
    }

    public static Set<Image> parseImages(String resource) {
        InputStream is = EC2ImageParserTest.class.getResourceAsStream(resource);
        return (Set)DescribeImagesResponseHandlerTest.createParser().parse(is);
    }
}

