/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.xml;

import com.google.common.collect.Sets;
import java.io.InputStream;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jclouds.date.DateService;
import org.jclouds.ec2.domain.Attachment;
import org.jclouds.ec2.domain.Volume;
import org.jclouds.ec2.xml.BaseEC2HandlerTest;
import org.jclouds.ec2.xml.DescribeVolumesResponseHandler;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.functions.ParseSax;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="DescribeVolumesResponseHandlerTest")
public class DescribeVolumesResponseHandlerTest
extends BaseEC2HandlerTest {
    public void testApplyInputStream() {
        DateService dateService = (DateService)this.injector.getInstance(DateService.class);
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/describe_volumes.xml");
        LinkedHashSet expected = Sets.newLinkedHashSet();
        expected.add(new Volume(this.defaultRegion, "vol-2a21e543", 1, null, "us-east-1a", Volume.Status.AVAILABLE, dateService.iso8601DateParse("2009-12-28T05:42:53.000Z"), (Iterable)Sets.newLinkedHashSet()));
        expected.add(new Volume(this.defaultRegion, "vol-4282672b", 800, "snap-536d1b3a", "us-east-1a", Volume.Status.IN_USE, dateService.iso8601DateParse("2008-05-07T11:51:50.000Z"), (Iterable)Sets.newHashSet((Object[])new Attachment[]{new Attachment(this.defaultRegion, "vol-4282672b", "i-6058a509", "/dev/sdh", Attachment.Status.ATTACHED, dateService.iso8601DateParse("2008-05-07T12:51:50.000Z"))})));
        DescribeVolumesResponseHandler handler = (DescribeVolumesResponseHandler)this.injector.getInstance(DescribeVolumesResponseHandler.class);
        this.addDefaultRegionToHandler((ParseSax.HandlerWithResult<?>)handler);
        Set result = (Set)this.factory.create((ParseSax.HandlerWithResult)handler).parse(is);
        Assert.assertEquals((Set)result, (Set)expected);
    }

    private void addDefaultRegionToHandler(ParseSax.HandlerWithResult<?> handler) {
        handler.setContext((HttpRequest)this.request);
    }
}

