/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.xml;

import java.io.IOException;
import java.io.InputStream;
import org.jclouds.ec2.domain.KeyPair;
import org.jclouds.ec2.xml.BaseEC2HandlerTest;
import org.jclouds.ec2.xml.KeyPairResponseHandler;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.ssh.SshKeys;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="KeyPairResponseHandlerTest")
public class KeyPairResponseHandlerTest
extends BaseEC2HandlerTest {
    public void testApplyInputStream() throws IOException {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/create_keypair.xml");
        KeyPair expected = KeyPair.builder().region(this.defaultRegion).keyName("jclouds#test#0").sha1OfPrivateKey("13:36:74:b9:56:bb:07:96:c0:19:ab:00:7f:9f:06:d2:16:a0:45:32").keyMaterial("-----BEGIN RSA PRIVATE KEY-----\nMIIEowIBAAKCAQEA0CbFlhSdbMdad2ux2BVqk6Ut5fLKb0CdbqubGcEBfwsSz9Rp4Ile76P90MpV\nW1BGKL5V4MO+flG6dZnRWPVmgrNVyDTmEsALiMGjfEwbACEZ1A8C6mPa36wWO7MlxuyMjg8OczTB\nEXnHNDpxE5a6KowJtzFlmgjHk2Y+Q42UIqPx47lQUv5bdMDCnfNNomSzTVRjOZLUkDja+ybCKdux\ngqTsuInhuBRMx+wxff8Z43ECdJV6UPoXK3der1dlZunxGCFkCeYq0kCX7FZ7PV35X744jqhD8P+7\ny5prO4W+M3DWgChUx0OlbDbSHtDVlcfdbj/+4AKYKU6rQOqh+4DPDQIDAQABAoIBAHjQuEiXKJSV\n1U2RZcVtENInws9AL/2I/Jfa5Qh6vTqXG9EjklywfzkK72x7tDVvD3ngmAoAs5WwLFDL+fXvYhOk\nsbql8ZCahVdYRWME7XsSu2IZYHDZipXe1XzLS7b9X8uos5Ns4E8bZuNKtI1RJDdD1vPMqRNR2z0T\n0Dn3eC7t+t+t7PWaK5AXu2ot7DoOeG1QhqJbwd5pMkIn2ydBILytgmDk/2P3EtJGePIJIeQBicmw\nZ0KrJFa/K2cC8AtmMJUoZMo+mh1yemDbDLCZW30PjFHbZtcszS2cydAgq/HDFkZynvZG0zhbx/To\njzcNza1AyypYwOwb2/9/ulXZp0UCgYEA+QFgWDfYLH2zwjU5b6e0UbIyd/X/yRZ+L8lOEBd0Bbu8\nqO3txaDbwi7o2mG7pJENHJ3u62CHjgTGDNW9V9Q8eNoGtj3uHvMvi7FdDEK8B6izdZyR7hmZmQ/5\nMIldelyiGZlz1KBSoy4FsCpA7hV7cI6H6x+Im24NxG90/wd/EgMCgYEA1f+cUyUisIO3yKOCf0hQ\naL289q2//F2cbvBxtki6I8JzTg1H3oTO2WVrXQeCA3a/yiuRUatgGH4mxrpCF6byVJyqrEWAj4kU\nuTbhMgIYhLGoaF1e+vMirCRXUXox0i5X976ASzHn64V9JSd1B+UbKfpcFTYYnChmrRDzmhKN1a8C\ngYBTvIHAyO7ab18/BRUOllAOVSWhr8lXv0eqHEEzKh/rOaoFCRY3qpOcZpgJsGogumK1Z+sLnoeX\nW8WaVVp6KbY4UeGF8aedItyvVnLbB6ohzTqkZ4Wvk05S6cs75kXYO0SL5U3NiCiiFXz2NA9nwTOk\ns1nD2PPgiQ76Kx0mEkhKLwKBgFhHEJqv+AZu37Kx2NRe5WS/2KK9/DPD/hM5tv7mM3sq7Nvm2J3v\nlVDS6J5AyZ5aLzXcER9qncKcz6wtC7SsFs1Wr4VPSoBroRPikrVJbgnXK8yZr+O/xq7Scv7WdJTq\nrzkw6cWbObvLnltkUn/GQBVqBPBvF2nbtLdyBbuqKb5bAoGBAI1+aoJnvXEXxT4UHrMkQcY0eXRz\n3UdbzJmtjMW9CR6l9s11mV6PcZP4qnODp3nd6a+lPeL3wVYQ47DsTJ/Bx5dI17zA5mU57n6mV0a3\nDbSoPKSdaKTQdo2THnVE9P9sPKZWueAcsE4Yw/qcTjoxrtUnAH/AXN250v0tkKIOvMhu\n-----END RSA PRIVATE KEY-----").build();
        KeyPairResponseHandler handler = (KeyPairResponseHandler)this.injector.getInstance(KeyPairResponseHandler.class);
        this.addDefaultRegionToHandler((ParseSax.HandlerWithResult<?>)handler);
        KeyPair result = (KeyPair)this.factory.create((ParseSax.HandlerWithResult)handler).parse(is);
        Assert.assertEquals((Object)result, (Object)expected);
        assert (SshKeys.privateKeyHasSha1((String)result.getKeyMaterial(), (String)result.getSha1OfPrivateKey()));
        assert (SshKeys.privateKeyHasFingerprint((String)result.getKeyMaterial(), (String)result.getFingerprint()));
    }

    private void addDefaultRegionToHandler(ParseSax.HandlerWithResult<?> handler) {
        handler.setContext((HttpRequest)this.request);
    }
}

