/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.xml;

import java.io.InputStream;
import org.jclouds.date.DateService;
import org.jclouds.ec2.domain.Snapshot;
import org.jclouds.ec2.xml.BaseEC2HandlerTest;
import org.jclouds.ec2.xml.SnapshotHandler;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.functions.ParseSax;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="SnapshotHandlerTest")
public class SnapshotHandlerTest
extends BaseEC2HandlerTest {
    public void testApplyInputStream() {
        DateService dateService = (DateService)this.injector.getInstance(DateService.class);
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/created_snapshot.xml");
        Snapshot expected = new Snapshot(this.defaultRegion, "snap-78a54011", "vol-4d826724", 10, Snapshot.Status.PENDING, dateService.iso8601DateParse("2008-05-07T12:51:50.000Z"), 60, "213457642086", "Daily Backup", null);
        SnapshotHandler handler = (SnapshotHandler)this.injector.getInstance(SnapshotHandler.class);
        this.addDefaultRegionToHandler((ParseSax.HandlerWithResult<?>)handler);
        Snapshot result = (Snapshot)this.factory.create((ParseSax.HandlerWithResult)handler).parse(is);
        Assert.assertEquals((Object)result, (Object)expected);
    }

    private void addDefaultRegionToHandler(ParseSax.HandlerWithResult<?> handler) {
        handler.setContext((HttpRequest)this.request);
    }
}

