/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.predicates;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import javax.annotation.Resource;
import javax.inject.Singleton;
import org.jclouds.aws.AWSResponseException;
import org.jclouds.ec2.EC2Client;
import org.jclouds.ec2.domain.RunningInstance;
import org.jclouds.logging.Logger;

@Singleton
public class InstanceHasIpAddress
implements Predicate<RunningInstance> {
    private final EC2Client client;
    @Resource
    protected Logger logger = Logger.NULL;

    @Inject
    public InstanceHasIpAddress(EC2Client client) {
        this.client = client;
    }

    public boolean apply(RunningInstance instance) {
        this.logger.trace("looking for ipAddress on instance %s", new Object[]{instance});
        try {
            instance = this.refresh(instance);
            return instance.getIpAddress() != null;
        }
        catch (AWSResponseException e) {
            if (e.getError().getCode().equals("InvalidInstanceID.NotFound")) {
                return false;
            }
            throw e;
        }
    }

    private RunningInstance refresh(RunningInstance instance) {
        return (RunningInstance)Iterables.getOnlyElement((Iterable)((Iterable)Iterables.getOnlyElement(this.client.getInstanceServices().describeInstancesInRegion(instance.getRegion(), instance.getId()))));
    }
}

