/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.elasticstack;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.reflect.Invokable;
import java.io.IOException;
import java.util.List;
import org.jclouds.Fallbacks;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.elasticstack.ElasticStackApiMetadata;
import org.jclouds.elasticstack.ElasticStackAsyncClient;
import org.jclouds.elasticstack.binders.BindServerToPlainTextStringTest;
import org.jclouds.elasticstack.domain.CreateDriveRequest;
import org.jclouds.elasticstack.domain.Drive;
import org.jclouds.elasticstack.domain.DriveData;
import org.jclouds.elasticstack.domain.ImageConversionType;
import org.jclouds.elasticstack.domain.Server;
import org.jclouds.elasticstack.functions.KeyValuesDelimitedByBlankLinesToDriveInfo;
import org.jclouds.elasticstack.functions.KeyValuesDelimitedByBlankLinesToServerInfo;
import org.jclouds.elasticstack.functions.ListOfKeyValuesDelimitedByBlankLinesToDriveInfoSet;
import org.jclouds.elasticstack.functions.ListOfKeyValuesDelimitedByBlankLinesToServerInfoSet;
import org.jclouds.elasticstack.functions.ReturnPayload;
import org.jclouds.elasticstack.functions.SplitNewlines;
import org.jclouds.fallbacks.MapHttp4xxCodesToExceptions;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpRequestFilter;
import org.jclouds.http.filters.BasicAuthentication;
import org.jclouds.http.functions.ReleasePayloadAndReturn;
import org.jclouds.io.Payload;
import org.jclouds.io.Payloads;
import org.jclouds.reflect.Reflection2;
import org.jclouds.rest.internal.BaseAsyncClientTest;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="ElasticStackAsyncClientTest")
public class ElasticStackAsyncClientTest
extends BaseAsyncClientTest<ElasticStackAsyncClient> {
    public void testListServers() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(ElasticStackAsyncClient.class, (String)"listServers", (Class[])new Class[0]);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of());
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET https://api-lon-p.elastichosts.com/servers/list HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: text/plain\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        httpRequest = (GeneratedHttpRequest)((HttpRequestFilter)Iterables.getOnlyElement((Iterable)httpRequest.getFilters())).filter((HttpRequest)httpRequest);
        httpRequest = (GeneratedHttpRequest)((HttpRequestFilter)Iterables.getOnlyElement((Iterable)httpRequest.getFilters())).filter((HttpRequest)httpRequest);
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET https://api-lon-p.elastichosts.com/servers/list HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: text/plain\nAuthorization: Basic aWRlbnRpdHk6Y3JlZGVudGlhbA==\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, httpRequest, SplitNewlines.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testListServerInfo() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(ElasticStackAsyncClient.class, (String)"listServerInfo", (Class[])new Class[0]);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of());
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET https://api-lon-p.elastichosts.com/servers/info HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: text/plain\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, httpRequest, ListOfKeyValuesDelimitedByBlankLinesToServerInfoSet.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testGetServerInfo() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(ElasticStackAsyncClient.class, (String)"getServerInfo", (Class[])new Class[]{String.class});
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of((Object)"uuid"));
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET https://api-lon-p.elastichosts.com/servers/uuid/info HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: text/plain\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, httpRequest, KeyValuesDelimitedByBlankLinesToServerInfo.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, Fallbacks.NullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testCreateAndStartServer() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(ElasticStackAsyncClient.class, (String)"createAndStartServer", (Class[])new Class[]{Server.class});
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of((Object)BindServerToPlainTextStringTest.SERVER));
        this.assertRequestLineEquals((HttpRequest)httpRequest, "POST https://api-lon-p.elastichosts.com/servers/create HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: text/plain\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, BindServerToPlainTextStringTest.CREATED_SERVER, "text/plain", false);
        this.assertResponseParserClassEquals(method, httpRequest, KeyValuesDelimitedByBlankLinesToServerInfo.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, Fallbacks.NullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testCreateServer() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(ElasticStackAsyncClient.class, (String)"createServer", (Class[])new Class[]{Server.class});
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of((Object)BindServerToPlainTextStringTest.SERVER));
        this.assertRequestLineEquals((HttpRequest)httpRequest, "POST https://api-lon-p.elastichosts.com/servers/create/stopped HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: text/plain\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, BindServerToPlainTextStringTest.CREATED_SERVER, "text/plain", false);
        this.assertResponseParserClassEquals(method, httpRequest, KeyValuesDelimitedByBlankLinesToServerInfo.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, Fallbacks.NullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testSetServerConfiguration() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(ElasticStackAsyncClient.class, (String)"setServerConfiguration", (Class[])new Class[]{String.class, Server.class});
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of((Object)"100", (Object)BindServerToPlainTextStringTest.SERVER));
        this.assertRequestLineEquals((HttpRequest)httpRequest, "POST https://api-lon-p.elastichosts.com/servers/100/set HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: text/plain\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, BindServerToPlainTextStringTest.CREATED_SERVER, "text/plain", false);
        this.assertResponseParserClassEquals(method, httpRequest, KeyValuesDelimitedByBlankLinesToServerInfo.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, Fallbacks.NullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testDestroyServer() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(ElasticStackAsyncClient.class, (String)"destroyServer", (Class[])new Class[]{String.class});
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of((Object)"uuid"));
        this.assertRequestLineEquals((HttpRequest)httpRequest, "POST https://api-lon-p.elastichosts.com/servers/uuid/destroy HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: text/plain\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, httpRequest, ReleasePayloadAndReturn.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, Fallbacks.VoidOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testStartServer() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(ElasticStackAsyncClient.class, (String)"startServer", (Class[])new Class[]{String.class});
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of((Object)"uuid"));
        this.assertRequestLineEquals((HttpRequest)httpRequest, "POST https://api-lon-p.elastichosts.com/servers/uuid/start HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: text/plain\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, httpRequest, ReleasePayloadAndReturn.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, MapHttp4xxCodesToExceptions.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testStopServer() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(ElasticStackAsyncClient.class, (String)"stopServer", (Class[])new Class[]{String.class});
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of((Object)"uuid"));
        this.assertRequestLineEquals((HttpRequest)httpRequest, "POST https://api-lon-p.elastichosts.com/servers/uuid/stop HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: text/plain\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, httpRequest, ReleasePayloadAndReturn.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, MapHttp4xxCodesToExceptions.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testShutdownServer() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(ElasticStackAsyncClient.class, (String)"shutdownServer", (Class[])new Class[]{String.class});
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of((Object)"uuid"));
        this.assertRequestLineEquals((HttpRequest)httpRequest, "POST https://api-lon-p.elastichosts.com/servers/uuid/shutdown HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: text/plain\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, httpRequest, ReleasePayloadAndReturn.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, MapHttp4xxCodesToExceptions.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testResetServer() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(ElasticStackAsyncClient.class, (String)"resetServer", (Class[])new Class[]{String.class});
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of((Object)"uuid"));
        this.assertRequestLineEquals((HttpRequest)httpRequest, "POST https://api-lon-p.elastichosts.com/servers/uuid/reset HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: text/plain\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, httpRequest, ReleasePayloadAndReturn.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, MapHttp4xxCodesToExceptions.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testListDrives() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(ElasticStackAsyncClient.class, (String)"listDrives", (Class[])new Class[0]);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of());
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET https://api-lon-p.elastichosts.com/drives/list HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: text/plain\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        httpRequest = (GeneratedHttpRequest)((HttpRequestFilter)Iterables.getOnlyElement((Iterable)httpRequest.getFilters())).filter((HttpRequest)httpRequest);
        httpRequest = (GeneratedHttpRequest)((HttpRequestFilter)Iterables.getOnlyElement((Iterable)httpRequest.getFilters())).filter((HttpRequest)httpRequest);
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET https://api-lon-p.elastichosts.com/drives/list HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: text/plain\nAuthorization: Basic aWRlbnRpdHk6Y3JlZGVudGlhbA==\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, httpRequest, SplitNewlines.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testListDriveInfo() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(ElasticStackAsyncClient.class, (String)"listDriveInfo", (Class[])new Class[0]);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of());
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET https://api-lon-p.elastichosts.com/drives/info HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: text/plain\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, httpRequest, ListOfKeyValuesDelimitedByBlankLinesToDriveInfoSet.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testGetDriveInfo() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(ElasticStackAsyncClient.class, (String)"getDriveInfo", (Class[])new Class[]{String.class});
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of((Object)"uuid"));
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET https://api-lon-p.elastichosts.com/drives/uuid/info HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: text/plain\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, httpRequest, KeyValuesDelimitedByBlankLinesToDriveInfo.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, Fallbacks.NullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testCreateDrive() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(ElasticStackAsyncClient.class, (String)"createDrive", (Class[])new Class[]{Drive.class});
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of((Object)new CreateDriveRequest.Builder().name("foo").size(10000L).build()));
        this.assertRequestLineEquals((HttpRequest)httpRequest, "POST https://api-lon-p.elastichosts.com/drives/create HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: text/plain\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, "name foo\nsize 10000", "text/plain", false);
        this.assertResponseParserClassEquals(method, httpRequest, KeyValuesDelimitedByBlankLinesToDriveInfo.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, Fallbacks.NullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testSetDriveData() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(ElasticStackAsyncClient.class, (String)"setDriveData", (Class[])new Class[]{String.class, DriveData.class});
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of((Object)"100", (Object)new DriveData.Builder().name("foo").size(10000L).tags((Iterable)ImmutableList.of((Object)"production", (Object)"candy")).build()));
        this.assertRequestLineEquals((HttpRequest)httpRequest, "POST https://api-lon-p.elastichosts.com/drives/100/set HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: text/plain\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, "name foo\nsize 10000\ntags production candy", "text/plain", false);
        this.assertResponseParserClassEquals(method, httpRequest, KeyValuesDelimitedByBlankLinesToDriveInfo.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, Fallbacks.NullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testDestroyDrive() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(ElasticStackAsyncClient.class, (String)"destroyDrive", (Class[])new Class[]{String.class});
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of((Object)"uuid"));
        this.assertRequestLineEquals((HttpRequest)httpRequest, "POST https://api-lon-p.elastichosts.com/drives/uuid/destroy HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: text/plain\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, httpRequest, ReleasePayloadAndReturn.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, Fallbacks.VoidOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testImageDrive() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(ElasticStackAsyncClient.class, (String)"imageDrive", (Class[])new Class[]{String.class, String.class});
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of((Object)"100", (Object)"200"));
        this.assertRequestLineEquals((HttpRequest)httpRequest, "POST https://api-lon-p.elastichosts.com/drives/200/image/100 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: text/plain\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, httpRequest, ReleasePayloadAndReturn.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, Fallbacks.VoidOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testImageDriveWithConversion() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(ElasticStackAsyncClient.class, (String)"imageDrive", (Class[])new Class[]{String.class, String.class, ImageConversionType.class});
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of((Object)"100", (Object)"200", (Object)ImageConversionType.GUNZIP));
        this.assertRequestLineEquals((HttpRequest)httpRequest, "POST https://api-lon-p.elastichosts.com/drives/200/image/100/gunzip HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: text/plain\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, httpRequest, ReleasePayloadAndReturn.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, Fallbacks.VoidOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testReadDrive() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(ElasticStackAsyncClient.class, (String)"readDrive", (Class[])new Class[]{String.class, Long.TYPE, Long.TYPE});
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of((Object)"100", (Object)1024, (Object)2048));
        this.assertRequestLineEquals((HttpRequest)httpRequest, "POST https://api-lon-p.elastichosts.com/drives/100/read/1024/2048 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: application/octet-stream\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, httpRequest, ReturnPayload.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, Fallbacks.NullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testWriteDrive() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(ElasticStackAsyncClient.class, (String)"writeDrive", (Class[])new Class[]{String.class, Payload.class});
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of((Object)"100", (Object)Payloads.newStringPayload((String)"foo")));
        this.assertRequestLineEquals((HttpRequest)httpRequest, "POST https://api-lon-p.elastichosts.com/drives/100/write HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: text/plain\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, "foo", "application/octet-stream", false);
        this.assertResponseParserClassEquals(method, httpRequest, ReleasePayloadAndReturn.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, Fallbacks.VoidOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testWriteDriveOffset() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(ElasticStackAsyncClient.class, (String)"writeDrive", (Class[])new Class[]{String.class, Payload.class, Long.TYPE});
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of((Object)"100", (Object)Payloads.newStringPayload((String)"foo"), (Object)2048));
        this.assertRequestLineEquals((HttpRequest)httpRequest, "POST https://api-lon-p.elastichosts.com/drives/100/write/2048 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: text/plain\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, "foo", "application/octet-stream", false);
        this.assertResponseParserClassEquals(method, httpRequest, ReleasePayloadAndReturn.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, Fallbacks.VoidOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    protected void checkFilters(HttpRequest request) {
        Assert.assertEquals((int)request.getFilters().size(), (int)1);
        Assert.assertEquals(((HttpRequestFilter)request.getFilters().get(0)).getClass(), BasicAuthentication.class);
    }

    protected ApiMetadata createApiMetadata() {
        return new ElasticStackApiMetadata();
    }
}

