/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.elasticstack;

import com.google.common.util.concurrent.ListenableFuture;
import java.io.Closeable;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.jclouds.Fallbacks;
import org.jclouds.elasticstack.binders.BindDriveDataToPlainTextString;
import org.jclouds.elasticstack.binders.BindDriveToPlainTextString;
import org.jclouds.elasticstack.binders.BindServerToPlainTextString;
import org.jclouds.elasticstack.domain.Drive;
import org.jclouds.elasticstack.domain.DriveData;
import org.jclouds.elasticstack.domain.DriveInfo;
import org.jclouds.elasticstack.domain.ImageConversionType;
import org.jclouds.elasticstack.domain.Server;
import org.jclouds.elasticstack.domain.ServerInfo;
import org.jclouds.elasticstack.functions.KeyValuesDelimitedByBlankLinesToDriveInfo;
import org.jclouds.elasticstack.functions.KeyValuesDelimitedByBlankLinesToServerInfo;
import org.jclouds.elasticstack.functions.ListOfKeyValuesDelimitedByBlankLinesToDriveInfoSet;
import org.jclouds.elasticstack.functions.ListOfKeyValuesDelimitedByBlankLinesToServerInfoSet;
import org.jclouds.elasticstack.functions.ReturnPayload;
import org.jclouds.elasticstack.functions.SplitNewlines;
import org.jclouds.http.filters.BasicAuthentication;
import org.jclouds.io.Payload;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;

@Deprecated
@RequestFilters(value={BasicAuthentication.class})
@Consumes(value={"text/plain"})
public interface ElasticStackAsyncClient
extends Closeable {
    @GET
    @Path(value="/servers/list")
    @ResponseParser(value=SplitNewlines.class)
    public ListenableFuture<Set<String>> listServers();

    @GET
    @Path(value="/servers/info")
    @ResponseParser(value=ListOfKeyValuesDelimitedByBlankLinesToServerInfoSet.class)
    public ListenableFuture<Set<ServerInfo>> listServerInfo();

    @GET
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @ResponseParser(value=KeyValuesDelimitedByBlankLinesToServerInfo.class)
    @Path(value="/servers/{uuid}/info")
    public ListenableFuture<ServerInfo> getServerInfo(@PathParam(value="uuid") String var1);

    @POST
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @ResponseParser(value=KeyValuesDelimitedByBlankLinesToServerInfo.class)
    @Path(value="/servers/create/stopped")
    public ListenableFuture<ServerInfo> createServer(@BinderParam(value=BindServerToPlainTextString.class) Server var1);

    @POST
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @ResponseParser(value=KeyValuesDelimitedByBlankLinesToServerInfo.class)
    @Path(value="/servers/{uuid}/set")
    public ListenableFuture<ServerInfo> setServerConfiguration(@PathParam(value="uuid") String var1, @BinderParam(value=BindServerToPlainTextString.class) Server var2);

    @POST
    @Path(value="/servers/{uuid}/destroy")
    @Fallback(value=Fallbacks.VoidOnNotFoundOr404.class)
    public ListenableFuture<Void> destroyServer(@PathParam(value="uuid") String var1);

    @POST
    @Path(value="/servers/{uuid}/start")
    public ListenableFuture<Void> startServer(@PathParam(value="uuid") String var1);

    @POST
    @Path(value="/servers/{uuid}/stop")
    public ListenableFuture<Void> stopServer(@PathParam(value="uuid") String var1);

    @POST
    @Path(value="/servers/{uuid}/shutdown")
    public ListenableFuture<Void> shutdownServer(@PathParam(value="uuid") String var1);

    @POST
    @Path(value="/servers/{uuid}/reset")
    public ListenableFuture<Void> resetServer(@PathParam(value="uuid") String var1);

    @GET
    @Path(value="/drives/list")
    @ResponseParser(value=SplitNewlines.class)
    public ListenableFuture<Set<String>> listDrives();

    @GET
    @Path(value="/drives/info")
    @ResponseParser(value=ListOfKeyValuesDelimitedByBlankLinesToDriveInfoSet.class)
    public ListenableFuture<Set<DriveInfo>> listDriveInfo();

    @GET
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @ResponseParser(value=KeyValuesDelimitedByBlankLinesToDriveInfo.class)
    @Path(value="/drives/{uuid}/info")
    public ListenableFuture<DriveInfo> getDriveInfo(@PathParam(value="uuid") String var1);

    @POST
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @ResponseParser(value=KeyValuesDelimitedByBlankLinesToDriveInfo.class)
    @Path(value="/drives/create")
    public ListenableFuture<DriveInfo> createDrive(@BinderParam(value=BindDriveToPlainTextString.class) Drive var1);

    @POST
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @ResponseParser(value=KeyValuesDelimitedByBlankLinesToDriveInfo.class)
    @Path(value="/drives/{uuid}/set")
    public ListenableFuture<DriveInfo> setDriveData(@PathParam(value="uuid") String var1, @BinderParam(value=BindDriveDataToPlainTextString.class) DriveData var2);

    @POST
    @Path(value="/drives/{uuid}/destroy")
    @Fallback(value=Fallbacks.VoidOnNotFoundOr404.class)
    public ListenableFuture<Void> destroyDrive(@PathParam(value="uuid") String var1);

    @POST
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @ResponseParser(value=KeyValuesDelimitedByBlankLinesToServerInfo.class)
    @Path(value="/servers/create")
    public ListenableFuture<ServerInfo> createAndStartServer(@BinderParam(value=BindServerToPlainTextString.class) Server var1);

    @POST
    @Path(value="/drives/{destination}/image/{source}")
    @Fallback(value=Fallbacks.VoidOnNotFoundOr404.class)
    public ListenableFuture<Void> imageDrive(@PathParam(value="source") String var1, @PathParam(value="destination") String var2);

    @POST
    @Path(value="/drives/{destination}/image/{source}/{conversion}")
    @Fallback(value=Fallbacks.VoidOnNotFoundOr404.class)
    public ListenableFuture<Void> imageDrive(@PathParam(value="source") String var1, @PathParam(value="destination") String var2, @PathParam(value="conversion") ImageConversionType var3);

    @POST
    @Consumes(value={"application/octet-stream"})
    @Path(value="/drives/{uuid}/read/{offset}/{size}")
    @ResponseParser(value=ReturnPayload.class)
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public ListenableFuture<Payload> readDrive(@PathParam(value="uuid") String var1, @PathParam(value="offset") long var2, @PathParam(value="size") long var4);

    @POST
    @Produces(value={"application/octet-stream"})
    @Path(value="/drives/{uuid}/write")
    @Fallback(value=Fallbacks.VoidOnNotFoundOr404.class)
    public ListenableFuture<Void> writeDrive(@PathParam(value="uuid") String var1, Payload var2);

    @POST
    @Produces(value={"application/octet-stream"})
    @Path(value="/drives/{uuid}/write/{offset}")
    @Fallback(value=Fallbacks.VoidOnNotFoundOr404.class)
    public ListenableFuture<Void> writeDrive(@PathParam(value="uuid") String var1, Payload var2, @PathParam(value="offset") long var3);
}

