/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.filesystem.integration;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.domain.BlobMetadata;
import org.jclouds.blobstore.domain.PageSet;
import org.jclouds.blobstore.integration.internal.BaseBlobStoreIntegrationTest;
import org.jclouds.blobstore.integration.internal.BaseContainerIntegrationTest;
import org.jclouds.blobstore.options.ListContainerOptions;
import org.jclouds.filesystem.utils.TestUtils;
import org.testng.Assert;
import org.testng.SkipException;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(groups={"integration", "live"}, testName="blobstore.FilesystemContainerIntegrationTest")
public class FilesystemContainerIntegrationTest
extends BaseContainerIntegrationTest {
    public FilesystemContainerIntegrationTest() {
        this.provider = "filesystem";
        BaseBlobStoreIntegrationTest.SANITY_CHECK_RETURNED_BUCKET_NAME = true;
    }

    protected Properties setupProperties() {
        Properties props = super.setupProperties();
        props.setProperty("jclouds.filesystem.basedir", TestUtils.TARGET_BASE_DIR);
        return props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="ignoreOnWindows", groups={"integration", "live"})
    public void testNotWithDetails() throws InterruptedException {
        String key = "hello";
        Blob object = ((BlobStoreContext)this.view).getBlobStore().blobBuilder(key).userMetadata((Map)ImmutableMap.of((Object)"Adrian", (Object)"powderpuff")).payload(TEST_STRING).contentType("text/plain").build();
        String containerName = this.getContainerName();
        try {
            this.addBlobToContainer(containerName, object);
            this.validateContent(containerName, key);
            PageSet container = ((BlobStoreContext)this.view).getBlobStore().list(containerName, ListContainerOptions.Builder.maxResults((int)1));
            BlobMetadata metadata = (BlobMetadata)Iterables.getOnlyElement((Iterable)container);
            Assert.assertEquals((int)metadata.getUserMetadata().size(), (int)0);
        }
        finally {
            this.returnContainer(containerName);
        }
    }

    public void testClearWhenContentsUnderPath() throws InterruptedException {
        throw new SkipException("not yet implemented");
    }

    public void testDirectory() throws InterruptedException {
        throw new SkipException("not yet implemented");
    }

    public void testWithDetails() throws InterruptedException, IOException {
        throw new SkipException("not yet implemented");
    }

    @Test(dataProvider="ignoreOnWindows")
    public void containerExists() throws InterruptedException {
        super.containerExists();
    }

    @Test(dataProvider="ignoreOnWindows")
    public void deleteContainerWithContents() throws InterruptedException {
        super.deleteContainerWithContents();
    }

    @Test(dataProvider="ignoreOnWindows")
    public void testListContainer() throws InterruptedException, ExecutionException, TimeoutException {
        super.testListContainer();
    }

    @Test(dataProvider="ignoreOnWindows")
    public void testListContainerMarker() throws InterruptedException {
        super.testListContainerMarker();
    }

    @Test(dataProvider="ignoreOnWindows")
    public void testListContainerPrefix() throws InterruptedException {
        super.testListContainerPrefix();
    }

    @Test(dataProvider="ignoreOnWindows")
    public void testListRootUsesDelimiter() throws InterruptedException {
        super.testListRootUsesDelimiter();
    }

    @Test(dataProvider="ignoreOnWindows")
    public void testPutTwiceIsOkAndDoesntOverwrite() throws InterruptedException {
        super.testPutTwiceIsOkAndDoesntOverwrite();
    }

    @Test(dataProvider="ignoreOnWindows")
    public void deleteContainerIfEmpty() throws InterruptedException {
        super.deleteContainerIfEmpty();
    }

    @Test(dataProvider="ignoreOnWindows")
    public void testListContainerMaxResults() throws InterruptedException {
        super.testListContainerMaxResults();
    }

    @DataProvider
    public Object[][] ignoreOnWindows() {
        return TestUtils.isWindowsOs() ? TestUtils.NO_INVOCATIONS : TestUtils.SINGLE_NO_ARG_INVOCATION;
    }
}

