/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.cinder.v1.features;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import org.jclouds.openstack.cinder.v1.CinderApi;
import org.jclouds.openstack.cinder.v1.domain.Snapshot;
import org.jclouds.openstack.cinder.v1.domain.Volume;
import org.jclouds.openstack.cinder.v1.features.SnapshotApi;
import org.jclouds.openstack.cinder.v1.features.VolumeApi;
import org.jclouds.openstack.cinder.v1.internal.BaseCinderApiLiveTest;
import org.jclouds.openstack.cinder.v1.options.CreateSnapshotOptions;
import org.jclouds.openstack.cinder.v1.options.CreateVolumeOptions;
import org.jclouds.openstack.cinder.v1.predicates.SnapshotPredicates;
import org.jclouds.openstack.cinder.v1.predicates.VolumePredicates;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"live"}, testName="VolumeApiLiveTest", singleThreaded=true)
public class VolumeAndSnapshotApiLiveTest
extends BaseCinderApiLiveTest {
    private static final String name = System.getProperty("user.name").replace('.', '-').toLowerCase();
    private String zone;
    private VolumeApi volumeApi;
    private SnapshotApi snapshotApi;
    private Volume testVolume;
    private Snapshot testSnapshot;

    @BeforeClass(groups={"integration", "live"})
    public void setup() {
        super.setup();
        this.zone = (String)Iterables.getLast((Iterable)((CinderApi)this.api).getConfiguredZones(), (Object)"nova");
        this.volumeApi = ((CinderApi)this.api).getVolumeApiForZone(this.zone);
        this.snapshotApi = ((CinderApi)this.api).getSnapshotApiForZone(this.zone);
    }

    @AfterClass(groups={"integration", "live"})
    protected void tearDown() {
        if (this.testSnapshot != null) {
            Assert.assertTrue((boolean)this.snapshotApi.delete(this.testSnapshot.getId()));
            Assert.assertTrue((boolean)SnapshotPredicates.awaitDeleted((SnapshotApi)this.snapshotApi).apply((Object)this.testSnapshot));
        }
        if (this.testVolume != null) {
            Assert.assertTrue((boolean)this.volumeApi.delete(this.testVolume.getId()));
            Assert.assertTrue((boolean)VolumePredicates.awaitDeleted((VolumeApi)this.volumeApi).apply((Object)this.testVolume));
        }
        super.tearDown();
    }

    public void testCreateVolume() {
        CreateVolumeOptions options = CreateVolumeOptions.Builder.name((String)name).description("description of test volume").availabilityZone(this.zone);
        this.testVolume = this.volumeApi.create(100, new CreateVolumeOptions[]{options});
        Assert.assertTrue((boolean)VolumePredicates.awaitAvailable((VolumeApi)this.volumeApi).apply((Object)this.testVolume));
    }

    @Test(dependsOnMethods={"testCreateVolume"})
    public void testListVolumes() {
        ImmutableSet volumes = this.volumeApi.list().toSet();
        Assert.assertNotNull((Object)volumes);
        boolean foundIt = false;
        for (Volume vol : volumes) {
            Volume details = this.volumeApi.get(vol.getId());
            Assert.assertNotNull((Object)details);
            if (!Objects.equal((Object)details.getId(), (Object)this.testVolume.getId())) continue;
            foundIt = true;
        }
        Assert.assertTrue((boolean)foundIt, (String)"Failed to find the volume we created in list() response");
    }

    @Test(dependsOnMethods={"testCreateVolume"})
    public void testListVolumesInDetail() {
        ImmutableSet volumes = this.volumeApi.listInDetail().toSet();
        Assert.assertNotNull((Object)volumes);
        boolean foundIt = false;
        for (Volume vol : volumes) {
            Volume details = this.volumeApi.get(vol.getId());
            Assert.assertNotNull((Object)details);
            Assert.assertNotNull((Object)details.getId());
            Assert.assertNotNull((Object)details.getCreated());
            Assert.assertTrue((details.getSize() > -1 ? 1 : 0) != 0);
            Assert.assertEquals((String)details.getId(), (String)vol.getId());
            Assert.assertEquals((int)details.getSize(), (int)vol.getSize());
            Assert.assertEquals((String)details.getName(), (String)vol.getName());
            Assert.assertEquals((String)details.getDescription(), (String)vol.getDescription());
            Assert.assertEquals((Object)details.getCreated(), (Object)vol.getCreated());
            if (!Objects.equal((Object)details.getId(), (Object)this.testVolume.getId())) continue;
            foundIt = true;
        }
        Assert.assertTrue((boolean)foundIt, (String)"Failed to find the volume we previously created in listInDetail() response");
    }

    @Test(dependsOnMethods={"testCreateVolume"})
    public void testCreateSnapshot() {
        this.testSnapshot = this.snapshotApi.create(this.testVolume.getId(), new CreateSnapshotOptions[]{CreateSnapshotOptions.Builder.name((String)"jclouds-live-test").description("jclouds live test snapshot").force()});
        Assert.assertNotNull((Object)this.testSnapshot);
        Assert.assertNotNull((Object)this.testSnapshot.getId());
        Assert.assertNotNull((Object)this.testSnapshot.getStatus());
        Assert.assertTrue((this.testSnapshot.getSize() > -1 ? 1 : 0) != 0);
        Assert.assertNotNull((Object)this.testSnapshot.getCreated());
        Assert.assertTrue((boolean)SnapshotPredicates.awaitAvailable((SnapshotApi)this.snapshotApi).apply((Object)this.testSnapshot));
    }

    @Test(dependsOnMethods={"testCreateSnapshot"})
    public void testListSnapshots() {
        ImmutableSet snapshots = this.snapshotApi.list().toSet();
        Assert.assertNotNull((Object)snapshots);
        boolean foundIt = false;
        for (Snapshot snap : snapshots) {
            Snapshot details = this.snapshotApi.get(snap.getId());
            if (Objects.equal((Object)snap.getVolumeId(), (Object)this.testVolume.getId())) {
                foundIt = true;
            }
            Assert.assertNotNull((Object)details);
            Assert.assertEquals((String)details.getId(), (String)snap.getId());
            Assert.assertEquals((String)details.getVolumeId(), (String)snap.getVolumeId());
        }
        Assert.assertTrue((boolean)foundIt, (String)"Failed to find the snapshot we previously created in listSnapshots() response");
    }

    @Test(dependsOnMethods={"testCreateSnapshot"})
    public void testListSnapshotsInDetail() {
        ImmutableSet snapshots = this.snapshotApi.listInDetail().toSet();
        Assert.assertNotNull((Object)snapshots);
        boolean foundIt = false;
        for (Snapshot snap : snapshots) {
            Snapshot details = this.snapshotApi.get(snap.getId());
            if (Objects.equal((Object)snap.getVolumeId(), (Object)this.testVolume.getId())) {
                foundIt = true;
                this.assertSame(details, this.testSnapshot);
            }
            this.assertSame(details, snap);
        }
        Assert.assertTrue((boolean)foundIt, (String)"Failed to find the snapshot we created in listSnapshotsInDetail() response");
    }

    private void assertSame(Snapshot a, Snapshot b) {
        Assert.assertNotNull((Object)a);
        Assert.assertNotNull((Object)b);
        Assert.assertEquals((String)a.getId(), (String)b.getId());
        Assert.assertEquals((String)a.getDescription(), (String)b.getDescription());
        Assert.assertEquals((String)a.getName(), (String)b.getName());
        Assert.assertEquals((String)a.getVolumeId(), (String)b.getVolumeId());
    }
}

