/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.cinder.v1.features;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import org.jclouds.openstack.cinder.v1.CinderApi;
import org.jclouds.openstack.cinder.v1.domain.VolumeType;
import org.jclouds.openstack.cinder.v1.features.VolumeTypeApi;
import org.jclouds.openstack.cinder.v1.internal.BaseCinderApiLiveTest;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeGroups;
import org.testng.annotations.Test;

@Test(groups={"live"}, testName="VolumeTypeApiLiveTest", singleThreaded=true)
public class VolumeTypeApiLiveTest
extends BaseCinderApiLiveTest {
    private VolumeTypeApi volumeTypeApi;
    private String zone;

    @BeforeGroups(groups={"integration", "live"})
    public void setup() {
        super.setup();
        this.zone = (String)Iterables.getLast((Iterable)((CinderApi)this.api).getConfiguredZones(), (Object)"nova");
        this.volumeTypeApi = ((CinderApi)this.api).getVolumeTypeApiForZone(this.zone);
    }

    @AfterClass(groups={"integration", "live"})
    protected void tearDown() {
        super.tearDown();
    }

    public void testListAndGetVolumeTypes() {
        ImmutableSet volumeTypes = this.volumeTypeApi.list().toSet();
        Assert.assertNotNull((Object)volumeTypes);
        for (VolumeType vt : volumeTypes) {
            VolumeType details = this.volumeTypeApi.get(vt.getId());
            Assert.assertNotNull((Object)details);
        }
    }
}

