/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.cinder.v1.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import java.util.Date;
import javax.inject.Named;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.openstack.cinder.v1.domain.Volume;

public class Snapshot {
    private final String id;
    @Named(value="volume_id")
    private final String volumeId;
    private final Volume.Status status;
    private final int size;
    @Named(value="created_at")
    private final Date created;
    @Named(value="display_name")
    private final String name;
    @Named(value="display_description")
    private final String description;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromSnapshot(this);
    }

    @ConstructorProperties(value={"id", "volume_id", "status", "size", "created_at", "display_name", "display_description"})
    protected Snapshot(String id, String volumeId, Volume.Status status, int size, @Nullable Date created, @Nullable String name, @Nullable String description) {
        this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"id");
        this.volumeId = (String)Preconditions.checkNotNull((Object)volumeId, (Object)"volumeId");
        this.status = (Volume.Status)((Object)Preconditions.checkNotNull((Object)((Object)status), (Object)"status"));
        this.size = size;
        this.created = created;
        this.name = name;
        this.description = description;
    }

    public String getId() {
        return this.id;
    }

    public String getVolumeId() {
        return this.volumeId;
    }

    public Volume.Status getStatus() {
        return this.status;
    }

    public int getSize() {
        return this.size;
    }

    @Nullable
    public Date getCreated() {
        return this.created;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.volumeId, this.status, this.size, this.created, this.name, this.description});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Snapshot that = (Snapshot)Snapshot.class.cast(obj);
        return Objects.equal((Object)this.id, (Object)that.id) && Objects.equal((Object)this.volumeId, (Object)that.volumeId) && Objects.equal((Object)((Object)this.status), (Object)((Object)that.status)) && Objects.equal((Object)this.size, (Object)that.size) && Objects.equal((Object)this.created, (Object)that.created) && Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)this.description, (Object)that.description);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((Object)this).add("id", (Object)this.id).add("volumeId", (Object)this.volumeId).add("status", (Object)this.status).add("size", this.size).add("created", (Object)this.created).add("name", (Object)this.name).add("description", (Object)this.description);
    }

    public String toString() {
        return this.string().toString();
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String id;
        protected String volumeId;
        protected Volume.Status status;
        protected int size;
        protected Date created;
        protected String name;
        protected String description;

        protected abstract T self();

        public T id(String id) {
            this.id = id;
            return this.self();
        }

        public T volumeId(String volumeId) {
            this.volumeId = volumeId;
            return this.self();
        }

        public T status(Volume.Status status) {
            this.status = status;
            return this.self();
        }

        public T size(int size) {
            this.size = size;
            return this.self();
        }

        public T created(Date created) {
            this.created = created;
            return this.self();
        }

        public T name(String name) {
            this.name = name;
            return this.self();
        }

        public T description(String description) {
            this.description = description;
            return this.self();
        }

        public Snapshot build() {
            return new Snapshot(this.id, this.volumeId, this.status, this.size, this.created, this.name, this.description);
        }

        public T fromSnapshot(Snapshot in) {
            return ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)this.id(in.getId())).volumeId(in.getVolumeId())).status(in.getStatus())).size(in.getSize())).created(in.getCreated())).name(in.getName())).description(in.getDescription());
        }
    }
}

