/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v2_0.config;

import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Provides;
import java.io.Closeable;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.net.URI;
import java.util.Properties;
import java.util.Set;
import javax.inject.Qualifier;
import javax.inject.Singleton;
import javax.ws.rs.HEAD;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import org.jclouds.Fallbacks;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.json.config.GsonModule;
import org.jclouds.location.suppliers.RegionIdToURISupplier;
import org.jclouds.openstack.keystone.v2_0.KeystoneApi;
import org.jclouds.openstack.keystone.v2_0.config.AuthenticationApiModule;
import org.jclouds.openstack.keystone.v2_0.config.KeystoneAuthenticationModule;
import org.jclouds.openstack.keystone.v2_0.internal.BaseKeystoneRestApiExpectTest;
import org.jclouds.rest.ConfiguresHttpApi;
import org.jclouds.rest.annotations.ApiVersion;
import org.jclouds.rest.annotations.Endpoint;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.config.HttpApiModule;
import org.jclouds.rest.internal.BaseHttpApiMetadata;
import org.jclouds.rest.internal.BaseRestApiExpectTest;
import org.jclouds.util.Suppliers2;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="ProviderModuleExpectTest")
public class ProviderModuleExpectTest
extends BaseRestApiExpectTest<DNSApi> {
    public void testDNSEndpointApplied() {
        KeystoneAuth keystoneAuth = new KeystoneAuth();
        DNSApi api = (DNSApi)this.requestsSendResponses(keystoneAuth.getKeystoneAuthWithUsernameAndPassword(), keystoneAuth.getResponseWithKeystoneAccess(), HttpRequest.builder().method("HEAD").endpoint("http://172.16.0.1:8776/v1/3456/zones/foo.com").build(), HttpResponse.builder().statusCode(200).build());
        Assert.assertTrue((boolean)api.zoneExists("foo.com"));
    }

    public ApiMetadata createApiMetadata() {
        return new DNSApiMetadata();
    }

    public static class KeystoneAuth
    extends BaseKeystoneRestApiExpectTest<KeystoneApi> {
        public HttpRequest getKeystoneAuthWithUsernameAndPassword() {
            return this.keystoneAuthWithUsernameAndPassword;
        }

        public HttpResponse getResponseWithKeystoneAccess() {
            return this.responseWithKeystoneAccess;
        }
    }

    private static class DNSApiMetadata
    extends BaseHttpApiMetadata<DNSApi> {
        public Builder toBuilder() {
            return (Builder)new Builder().fromApiMetadata((ApiMetadata)this);
        }

        public DNSApiMetadata() {
            this(new Builder());
        }

        protected DNSApiMetadata(Builder builder) {
            super((BaseHttpApiMetadata.Builder)builder);
        }

        public static Properties defaultProperties() {
            Properties properties = BaseHttpApiMetadata.defaultProperties();
            properties.setProperty("jclouds.keystone.service-type", "dns");
            properties.setProperty("jclouds.keystone.credential-type", "passwordCredentials");
            return properties;
        }

        public static class Builder
        extends BaseHttpApiMetadata.Builder<DNSApi, Builder> {
            protected Builder() {
                ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)this.id("dns")).name("DNS API")).identityName("${tenantName}:${userName} or ${userName}, if your keystone supports a default tenant")).credentialName("${password}")).endpointName("Keystone base url ending in /v2.0/")).documentation(URI.create("http://dns"))).version("1.0")).defaultEndpoint("http://localhost:5000/v2.0/")).defaultProperties(DNSApiMetadata.defaultProperties())).defaultModules((Set)ImmutableSet.builder().add(AuthenticationApiModule.class).add(KeystoneAuthenticationModule.class).add(KeystoneAuthenticationModule.RegionModule.class).add(DNSHttpApiModule.class).build());
            }

            public DNSApiMetadata build() {
                return new DNSApiMetadata(this);
            }

            protected Builder self() {
                return this;
            }
        }
    }

    @Endpoint(value=DNS.class)
    static interface DNSApi
    extends Closeable {
        @HEAD
        @Path(value="/zones/{zoneName}")
        @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
        public boolean zoneExists(@PathParam(value="zoneName") String var1);
    }

    @ConfiguresHttpApi
    public static class DNSHttpApiModule
    extends HttpApiModule<DNSApi> {
        public void configure() {
            this.bind(GsonModule.DateAdapter.class).to(GsonModule.Iso8601DateAdapter.class);
            super.configure();
        }

        @Provides
        @Singleton
        @DNS
        protected Supplier<URI> provideCDNUrl(RegionIdToURISupplier.Factory factory, @ApiVersion String apiVersion) {
            return Suppliers2.getLastValueInMap((Supplier)factory.createForApiTypeAndVersion("dns", apiVersion));
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    @Qualifier
    static @interface DNS {
    }
}

