/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v2_0.features;

import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.util.Set;
import org.jclouds.date.DateService;
import org.jclouds.date.internal.SimpleDateFormatDateService;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpResponseException;
import org.jclouds.openstack.keystone.v2_0.KeystoneApi;
import org.jclouds.openstack.keystone.v2_0.domain.Endpoint;
import org.jclouds.openstack.keystone.v2_0.domain.Role;
import org.jclouds.openstack.keystone.v2_0.domain.Tenant;
import org.jclouds.openstack.keystone.v2_0.domain.Token;
import org.jclouds.openstack.keystone.v2_0.domain.User;
import org.jclouds.openstack.keystone.v2_0.features.TokenApi;
import org.jclouds.openstack.keystone.v2_0.internal.BaseKeystoneRestApiExpectTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(testName="TokenApiExpectTest")
public class TokenApiExpectTest
extends BaseKeystoneRestApiExpectTest<KeystoneApi> {
    private DateService dateService = new SimpleDateFormatDateService();

    public TokenApiExpectTest() {
        this.endpoint = "https://csnode.jclouds.org:35357";
    }

    public void testGetToken() {
        TokenApi api = (TokenApi)((KeystoneApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.authenticatedGET().endpoint(this.endpoint + "/v2.0/tokens/sometokenorother").build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResourceWithContentType("/token_details.json", "application/json"))).build())).getTokenApi().get();
        Token token = api.get("sometokenorother");
        Assert.assertNotNull((Object)token);
        Assert.assertEquals((Object)token, (Object)Token.builder().id("167eccdc790946969ced473732e8109b").expires(this.dateService.iso8601SecondsDateParse("2012-04-28T12:42:50Z")).tenant(Tenant.builder().id("4cea93f5464b4f1c921fb3e0461d72b5").name("demo").build()).build());
    }

    public void testGetTokenFailNotFound() {
        TokenApi api = (TokenApi)((KeystoneApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.authenticatedGET().endpoint(this.endpoint + "/v2.0/tokens/sometokenorother").build(), HttpResponse.builder().statusCode(404).build())).getTokenApi().get();
        Assert.assertNull((Object)api.get("sometokenorother"));
    }

    @Test(expectedExceptions={HttpResponseException.class})
    public void testGetTokenFail500() {
        TokenApi api = (TokenApi)((KeystoneApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.authenticatedGET().endpoint(this.endpoint + "/v2.0/tokens/sometokenorother").build(), HttpResponse.builder().statusCode(500).build())).getTokenApi().get();
        api.get("sometokenorother");
    }

    public void testGetUserOfToken() {
        TokenApi api = (TokenApi)((KeystoneApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.authenticatedGET().endpoint(this.endpoint + "/v2.0/tokens/sometokenorother").build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResourceWithContentType("/token_details.json", "application/json"))).build())).getTokenApi().get();
        User user = api.getUserOfToken("sometokenorother");
        Assert.assertNotNull((Object)user);
        Assert.assertEquals((Set)user, (Set)User.builder().id("2b9b606181634ae9ac86fd95a8bc2cde").name("admin").roles((Iterable)ImmutableSet.of((Object)Role.builder().id("79cada5c02814b57a52e0eed4dd388cb").name("admin").build())).build());
    }

    public void testGetUserOfTokenFailNotFound() {
        TokenApi api = (TokenApi)((KeystoneApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.authenticatedGET().endpoint(this.endpoint + "/v2.0/tokens/sometokenorother").build(), HttpResponse.builder().statusCode(404).build())).getTokenApi().get();
        Assert.assertNull((Object)api.getUserOfToken("sometokenorother"));
    }

    public void testCheckTokenIsValid() {
        TokenApi api = (TokenApi)((KeystoneApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, ((HttpRequest.Builder)HttpRequest.builder().method("HEAD").endpoint(this.endpoint + "/v2.0/tokens/sometokenorother").addHeader("X-Auth-Token", new String[]{this.authToken})).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResourceWithContentType("/token_details.json", "application/json"))).build())).getTokenApi().get();
        Assert.assertTrue((boolean)api.isValid("sometokenorother"));
    }

    public void testCheckTokenIsValidFailNotValid() {
        TokenApi api = (TokenApi)((KeystoneApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, ((HttpRequest.Builder)HttpRequest.builder().method("HEAD").endpoint(this.endpoint + "/v2.0/tokens/sometokenorother").addHeader("X-Auth-Token", new String[]{this.authToken})).build(), HttpResponse.builder().statusCode(404).build())).getTokenApi().get();
        Assert.assertFalse((boolean)api.isValid("sometokenorother"));
    }

    @Test
    public void testGetEndpointsForToken() {
        TokenApi api = (TokenApi)((KeystoneApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.authenticatedGET().endpoint(this.endpoint + "/v2.0/tokens/XXXXXX/endpoints").build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResourceWithContentType("/user_endpoints.json", "application/json"))).build())).getTokenApi().get();
        Set endpoints = api.listEndpointsForToken("XXXXXX");
        Assert.assertEquals((Set)endpoints, (Set)ImmutableSet.of((Object)Endpoint.builder().publicURL(URI.create("https://csnode.jclouds.org/v2.0/")).adminURL(URI.create("https://csnode.jclouds.org:35357/v2.0/")).region("region-a.geo-1").id("2.0").versionId("2.0").build()));
    }

    @Test
    public void testGetEndpointsForTokenFailNotFound() {
        TokenApi api = (TokenApi)((KeystoneApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.authenticatedGET().endpoint(this.endpoint + "/v2.0/tokens/XXXXXX/endpoints").build(), HttpResponse.builder().statusCode(404).build())).getTokenApi().get();
        Assert.assertTrue((boolean)api.listEndpointsForToken("XXXXXX").isEmpty());
    }
}

