/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v2_0.features;

import com.google.common.collect.Iterables;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.Properties;
import java.util.Set;
import org.jclouds.http.HttpRequest;
import org.jclouds.openstack.keystone.v2_0.KeystoneApi;
import org.jclouds.openstack.keystone.v2_0.domain.Token;
import org.jclouds.openstack.keystone.v2_0.domain.User;
import org.jclouds.openstack.keystone.v2_0.features.TokenApi;
import org.jclouds.openstack.keystone.v2_0.filters.AuthenticateRequest;
import org.jclouds.openstack.keystone.v2_0.internal.BaseKeystoneApiLiveTest;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"live"}, testName="TokenApiLiveTest", singleThreaded=true)
public class TokenApiLiveTest
extends BaseKeystoneApiLiveTest {
    protected String token;

    protected KeystoneApi create(Properties props, Iterable<Module> modules) {
        Injector injector = this.newBuilder().modules(modules).overrides(props).buildInjector();
        this.grabToken((AuthenticateRequest)injector.getInstance(AuthenticateRequest.class));
        return (KeystoneApi)injector.getInstance(KeystoneApi.class);
    }

    private void grabToken(AuthenticateRequest ar) {
        HttpRequest test = ar.filter(HttpRequest.builder().method("GET").endpoint(this.endpoint).build());
        this.token = (String)Iterables.getOnlyElement((Iterable)test.getHeaders().get((Object)"X-Auth-Token"));
    }

    public void testToken() {
        TokenApi tokenApi = (TokenApi)((KeystoneApi)this.api).getTokenApi().get();
        AssertJUnit.assertTrue((boolean)tokenApi.isValid(this.token));
        Token result = tokenApi.get(this.token);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((String)result.getId(), (String)this.token);
        Assert.assertNotNull((Object)result.getTenant());
        User user = tokenApi.getUserOfToken(this.token);
        Assert.assertNotNull((Object)user);
        Assert.assertNotNull((Object)user.getId());
        Assert.assertNotNull((Object)user.getName());
    }

    public void testInvalidToken() {
        TokenApi tokenApi = (TokenApi)((KeystoneApi)this.api).getTokenApi().get();
        Assert.assertFalse((boolean)tokenApi.isValid("thisisnotarealtoken!"));
        Assert.assertNull((Object)tokenApi.get("thisisnotarealtoken!"));
    }

    public void testTokenEndpoints() {
        TokenApi tokenApi = (TokenApi)((KeystoneApi)this.api).getTokenApi().get();
        Set endpoints = tokenApi.listEndpointsForToken(this.token);
        Assert.assertNotNull((Object)endpoints);
        Assert.assertFalse((boolean)endpoints.isEmpty());
    }

    public void testInvalidTokenEndpoints() {
        TokenApi tokenApi = (TokenApi)((KeystoneApi)this.api).getTokenApi().get();
        AssertJUnit.assertTrue((boolean)tokenApi.listEndpointsForToken("thisisnotarealtoken!").isEmpty());
    }
}

