/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.ec2.services;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.compute.ComputeTestUtils;
import org.jclouds.compute.internal.BaseComputeServiceContextLiveTest;
import org.jclouds.ec2.domain.KeyPair;
import org.jclouds.ec2.options.DescribeRegionsOptions;
import org.jclouds.openstack.nova.ec2.NovaEC2ApiMetadata;
import org.jclouds.openstack.nova.ec2.NovaEC2Client;
import org.jclouds.openstack.nova.ec2.services.NovaEC2KeyPairClient;
import org.jclouds.rest.RestContext;
import org.jclouds.ssh.SshKeys;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"live"}, singleThreaded=true)
public class NovaEC2KeyPairClientLiveTest
extends BaseComputeServiceContextLiveTest {
    public static final String PREFIX = System.getProperty("user.name") + "-nova-ec2";
    private NovaEC2KeyPairClient client;
    private Set<String> regions;

    public NovaEC2KeyPairClientLiveTest() {
        this.provider = "openstack-nova-ec2";
    }

    @BeforeClass(groups={"integration", "live"})
    public void setupContext() {
        super.setupContext();
        this.client = ((NovaEC2Client)((RestContext)((ComputeServiceContext)this.view).unwrap(NovaEC2ApiMetadata.CONTEXT_TOKEN)).getApi()).getKeyPairServices();
        this.regions = ((NovaEC2Client)((RestContext)((ComputeServiceContext)this.view).unwrap(NovaEC2ApiMetadata.CONTEXT_TOKEN)).getApi()).getAvailabilityZoneAndRegionServices().describeRegions(new DescribeRegionsOptions[0]).keySet();
    }

    @Test
    void testDescribeKeyPairs() {
        for (String region : this.regions) {
            TreeSet allResults = Sets.newTreeSet((Iterable)this.client.describeKeyPairsInRegion(region, new String[0]));
            Assert.assertNotNull((Object)allResults);
            if (allResults.size() < 1) continue;
            KeyPair pair = (KeyPair)allResults.last();
            TreeSet result = Sets.newTreeSet((Iterable)this.client.describeKeyPairsInRegion(region, new String[]{pair.getKeyName()}));
            Assert.assertNotNull((Object)result);
            KeyPair compare = (KeyPair)result.last();
            Assert.assertEquals((Object)compare, (Object)pair);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testCreateKeyPair() {
        String keyName = PREFIX + "1";
        this.cleanupKeyPair(keyName);
        try {
            KeyPair keyPair = this.client.createKeyPairInRegion(null, keyName);
            this.checkKeyPair(keyName, keyPair);
            Assert.assertNotNull((Object)keyPair.getKeyMaterial());
        }
        finally {
            this.cleanupKeyPair(keyName);
        }
    }

    protected void cleanupKeyPair(String keyName) {
        try {
            this.client.deleteKeyPairInRegion(null, keyName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.client.deleteKeyPairInRegion(null, keyName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testImportKeyPair() throws IOException {
        String keyName = PREFIX + "2";
        this.cleanupKeyPair(keyName);
        Map myKey = ComputeTestUtils.setupKeyPair();
        try {
            KeyPair keyPair = this.client.importKeyPairInRegion(null, keyName, (String)myKey.get("public"));
            this.checkKeyPair(keyName, keyPair);
            Assert.assertEquals((String)keyPair.getSha1OfPrivateKey(), (String)SshKeys.fingerprintPublicKey((String)((String)myKey.get("public"))));
            try {
                this.client.importKeyPairInRegion(null, keyName, (String)myKey.get("public"));
                Assert.fail((String)"Duplicate call importKeyPairInRegion should have failed!");
            }
            catch (IllegalStateException e) {
                // empty catch block
            }
        }
        finally {
            this.cleanupKeyPair(keyName);
        }
    }

    protected void checkKeyPair(String keyName, KeyPair keyPair) {
        Assert.assertNotNull((Object)keyPair);
        Assert.assertNotNull((Object)keyPair.getSha1OfPrivateKey());
        Assert.assertEquals((String)keyPair.getKeyName(), (String)keyName);
        Set twoResults = this.client.describeKeyPairsInRegion(null, new String[]{keyName});
        Assert.assertNotNull((Object)twoResults);
        Assert.assertEquals((int)twoResults.size(), (int)1);
        KeyPair listPair = (KeyPair)twoResults.iterator().next();
        Assert.assertEquals((String)listPair.getKeyName(), (String)keyPair.getKeyName());
        Assert.assertEquals((String)listPair.getSha1OfPrivateKey(), (String)keyPair.getSha1OfPrivateKey());
    }
}

