/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0;

import com.google.common.collect.ImmutableSet;
import java.util.Properties;
import java.util.Set;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.openstack.nova.v2_0.NovaApi;
import org.jclouds.openstack.nova.v2_0.internal.BaseNovaApiExpectTest;
import org.jclouds.openstack.nova.v2_0.parse.ParseServerListTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="AccessKeyAndSecretKeyAuthenticationExpectTest")
public class AccessKeyAndSecretKeyAuthenticationExpectTest
extends BaseNovaApiExpectTest {
    protected Properties setupProperties() {
        Properties contextProperties = super.setupProperties();
        contextProperties.setProperty("jclouds.keystone.credential-type", "apiAccessKeyCredentials");
        return contextProperties;
    }

    public void testListServersWhenResponseIs2xx() throws Exception {
        HttpRequest listServers = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/servers").addHeader("Accept", new String[]{"application/json"})).addHeader("X-Auth-Token", new String[]{this.authToken})).build();
        HttpResponse listServersResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/server_list.json"))).build();
        NovaApi apiWhenServersExist = (NovaApi)this.requestsSendResponses(this.keystoneAuthWithAccessKeyAndSecretKeyAndTenantName, this.responseWithKeystoneAccess, listServers, listServersResponse);
        Assert.assertEquals((Set)apiWhenServersExist.getConfiguredZones(), (Set)ImmutableSet.of((Object)"az-1.region-a.geo-1", (Object)"az-2.region-a.geo-1", (Object)"az-3.region-a.geo-1"));
        Assert.assertEquals((String)apiWhenServersExist.getServerApiForZone("az-1.region-a.geo-1").list().concat().toString(), (String)new ParseServerListTest().expected().toString());
    }
}

