/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.compute.extensions;

import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.Futures;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Future;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.ImageTemplate;
import org.jclouds.compute.extensions.ImageExtension;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.openstack.nova.v2_0.internal.BaseNovaComputeServiceExpectTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="NovaImageExtensionExpectTest")
public class NovaImageExtensionExpectTest
extends BaseNovaComputeServiceExpectTest {
    HttpRequest serverDetail;
    HttpResponse serverDetailResponse;
    HttpRequest createImage;
    HttpResponse createImageResponse;
    HttpRequest getImage;
    HttpResponse getImageResponse;

    public NovaImageExtensionExpectTest() {
        this.serverDetail = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/servers/71752").addHeader("Accept", new String[]{"application/json"})).addHeader("X-Auth-Token", new String[]{this.authToken})).build();
        this.serverDetailResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/server_details.json"))).build();
        this.createImage = ((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/servers/71752/action").addHeader("Accept", new String[]{"application/json"})).addHeader("X-Auth-Token", new String[]{this.authToken})).payload(NovaImageExtensionExpectTest.payloadFromStringWithContentType((String)"{\"createImage\":{\"name\":\"test\", \"metadata\": {}}}", (String)"application/json"))).build();
        this.createImageResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(202).addHeader("Location", new String[]{"https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/images/52415800-8b69-11e0-9b19-734f5736d2a2"})).build();
        this.getImage = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/images/52415800-8b69-11e0-9b19-734f5736d2a2").addHeader("Accept", new String[]{"application/json"})).addHeader("X-Auth-Token", new String[]{this.authToken})).build();
        this.getImageResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/image_active.json"))).build();
    }

    protected Properties setupProperties() {
        Properties overrides = super.setupProperties();
        overrides.setProperty("jclouds.zones", "az-1.region-a.geo-1");
        return overrides;
    }

    public void testCreateImage() {
        ImmutableMap.Builder requestResponseMap = ImmutableMap.builder();
        requestResponseMap.put((Object)this.keystoneAuthWithUsernameAndPasswordAndTenantName, (Object)this.responseWithKeystoneAccess);
        requestResponseMap.put((Object)this.serverDetail, (Object)this.serverDetailResponse).build();
        requestResponseMap.put((Object)this.createImage, (Object)this.createImageResponse).build();
        requestResponseMap.put((Object)this.getImage, (Object)this.getImageResponse).build();
        ImageExtension apiThatCreatesImage = (ImageExtension)((ComputeService)this.requestsSendResponses((Map)requestResponseMap.build())).getImageExtension().get();
        ImageTemplate newImageTemplate = apiThatCreatesImage.buildImageTemplateFromNode("test", "az-1.region-a.geo-1/71752");
        Image image = (Image)Futures.getUnchecked((Future)apiThatCreatesImage.createImage(newImageTemplate));
        Assert.assertEquals((String)image.getId(), (String)"az-1.region-a.geo-1/52415800-8b69-11e0-9b19-734f5736d2a2");
    }
}

