/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.compute.functions;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.Atomics;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.NodeMetadataBuilder;
import org.jclouds.domain.Location;
import org.jclouds.domain.LocationBuilder;
import org.jclouds.domain.LocationScope;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.openstack.nova.v2_0.compute.functions.AllocateAndAddFloatingIpToNode;
import org.jclouds.openstack.nova.v2_0.internal.BaseNovaComputeServiceExpectTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="AllocateAndAddFloatingIpToNodeTest")
public class AllocateAndAddFloatingIpToNodeExpectTest
extends BaseNovaComputeServiceExpectTest {
    final Location provider = new LocationBuilder().scope(LocationScope.PROVIDER).id("openstack-nova").description("openstack-nova").build();
    final Location zone = new LocationBuilder().id("az-1.region-a.geo-1").description("az-1.region-a.geo-1").scope(LocationScope.ZONE).parent(this.provider).build();
    final Location host = new LocationBuilder().scope(LocationScope.HOST).id("hostId").description("hostId").parent(this.zone).build();
    final NodeMetadata node = new NodeMetadataBuilder().id("az-1.region-a.geo-1/71592").providerId("71592").location(this.host).name("Server 71592").status(NodeMetadata.Status.RUNNING).privateAddresses((Iterable)ImmutableSet.of((Object)"10.4.27.237")).credentials(LoginCredentials.builder().password("foo").build()).build();
    HttpRequest createFloatingIP = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint(URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/os-floating-ips")).headers((Multimap)ImmutableMultimap.builder().put((Object)"Accept", (Object)"application/json").put((Object)"X-Auth-Token", (Object)this.authToken).build())).payload(AllocateAndAddFloatingIpToNodeExpectTest.payloadFromStringWithContentType((String)"{}", (String)"application/json"))).build();
    HttpResponse addFloatingIPResponse = HttpResponse.builder().statusCode(200).build();

    public void testAllocateWhenAllocationReturnsIpIsAddedToServerAndUpdatesNodeMetadataButSavesCredentials() throws Exception {
        HttpResponse createFloatingIPResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/floatingip_details.json"))).build();
        HttpRequest addFloatingIPRequest = this.addFloatingIPForAddress("10.0.0.3");
        AllocateAndAddFloatingIpToNode fn = (AllocateAndAddFloatingIpToNode)((ComputeService)this.requestsSendResponses((Map)ImmutableMap.builder().put((Object)this.keystoneAuthWithUsernameAndPasswordAndTenantName, (Object)this.responseWithKeystoneAccess).put((Object)this.extensionsOfNovaRequest, (Object)this.extensionsOfNovaResponse).put((Object)this.createFloatingIP, (Object)createFloatingIPResponse).put((Object)addFloatingIPRequest, (Object)this.addFloatingIPResponse).build())).getContext().utils().injector().getInstance(AllocateAndAddFloatingIpToNode.class);
        AtomicReference nodeRef = Atomics.newReference((Object)this.node);
        fn.apply(nodeRef);
        NodeMetadata node1 = (NodeMetadata)nodeRef.get();
        Assert.assertNotNull((Object)node1);
        Assert.assertEquals((Set)node1.getPublicAddresses(), (Set)ImmutableSet.of((Object)"10.0.0.3"));
        Assert.assertEquals((Object)node1.getCredentials(), (Object)this.node.getCredentials());
    }

    private HttpRequest addFloatingIPForAddress(String address) {
        HttpRequest addFloatingIPRequest = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint(URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/servers/71592/action")).headers((Multimap)ImmutableMultimap.builder().put((Object)"Accept", (Object)"*/*").put((Object)"X-Auth-Token", (Object)this.authToken).build())).payload(AllocateAndAddFloatingIpToNodeExpectTest.payloadFromStringWithContentType((String)("{\"addFloatingIp\":{\"address\":\"" + address + "\"}}"), (String)"application/json"))).build();
        return addFloatingIPRequest;
    }

    public void testAllocateWhenAllocationFailsLookupUnusedIpAddToServerAndUpdatesNodeMetadata() throws Exception {
        HttpResponse createFloatingIPResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(400).payload(AllocateAndAddFloatingIpToNodeExpectTest.payloadFromStringWithContentType((String)"{\"badRequest\": {\"message\": \"AddressLimitExceeded: Address quota exceeded. You cannot create any more addresses\", \"code\": 400}}", (String)"application/json"))).build();
        HttpRequest list = ((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint(URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/os-floating-ips")).headers((Multimap)ImmutableMultimap.builder().put((Object)"Accept", (Object)"application/json").put((Object)"X-Auth-Token", (Object)this.authToken).build())).build();
        HttpResponse listResponseForUnassigned = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/floatingip_list.json"))).build();
        HttpRequest addFloatingIPRequest = this.addFloatingIPForAddress("10.0.0.5");
        AllocateAndAddFloatingIpToNode fn = (AllocateAndAddFloatingIpToNode)((ComputeService)this.requestsSendResponses((Map)ImmutableMap.builder().put((Object)this.keystoneAuthWithUsernameAndPasswordAndTenantName, (Object)this.responseWithKeystoneAccess).put((Object)this.extensionsOfNovaRequest, (Object)this.extensionsOfNovaResponse).put((Object)this.createFloatingIP, (Object)createFloatingIPResponse).put((Object)addFloatingIPRequest, (Object)this.addFloatingIPResponse).put((Object)list, (Object)listResponseForUnassigned).build())).getContext().utils().injector().getInstance(AllocateAndAddFloatingIpToNode.class);
        AtomicReference nodeRef = Atomics.newReference((Object)this.node);
        fn.apply(nodeRef);
        NodeMetadata node1 = (NodeMetadata)nodeRef.get();
        Assert.assertNotNull((Object)node1);
        Assert.assertEquals((Set)node1.getPublicAddresses(), (Set)ImmutableSet.of((Object)"10.0.0.5"));
    }
}

