/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.UUID;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.domain.Location;
import org.jclouds.domain.LocationBuilder;
import org.jclouds.domain.LocationScope;
import org.jclouds.openstack.nova.v2_0.compute.config.NovaComputeServiceContextModule;
import org.jclouds.openstack.nova.v2_0.compute.functions.ImageInZoneToImage;
import org.jclouds.openstack.nova.v2_0.domain.Image;
import org.jclouds.openstack.nova.v2_0.domain.zonescoped.ImageInZone;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(testName="ImageInZoneToHardwareTest")
public class ImageInZoneToImageTest {
    Location provider = new LocationBuilder().scope(LocationScope.PROVIDER).id("openstack-nova").description("openstack-nova").build();
    Location zone = new LocationBuilder().id("az-1.region-a.geo-1").description("az-1.region-a.geo-1").scope(LocationScope.ZONE).parent(this.provider).build();
    Supplier<Map<String, Location>> locationIndex = Suppliers.ofInstance((Object)ImmutableMap.of((Object)"az-1.region-a.geo-1", (Object)this.zone));

    @Test
    public void testConversionWhereLocationFound() {
        UUID id = UUID.randomUUID();
        org.jclouds.openstack.nova.v2_0.domain.Image novaImageToConvert = ((Image.Builder)((Image.Builder)org.jclouds.openstack.nova.v2_0.domain.Image.builder().id(id.toString())).name("Test Image " + id)).status(Image.Status.DELETED).build();
        OperatingSystem operatingSystem = new OperatingSystem(OsFamily.UBUNTU, "My Test OS", "My Test Version", "x86", "My Test OS", true);
        ImageInZoneToImage converter = new ImageInZoneToImage(NovaComputeServiceContextModule.toPortableImageStatus, ImageInZoneToImageTest.constant(operatingSystem), this.locationIndex);
        ImageInZone novaImageInZoneToConvert = new ImageInZone(novaImageToConvert, "az-1.region-a.geo-1");
        Image convertedImage = converter.apply(novaImageInZoneToConvert);
        Assert.assertEquals((String)convertedImage.getId(), (String)novaImageInZoneToConvert.slashEncode());
        Assert.assertEquals((String)convertedImage.getProviderId(), (String)novaImageToConvert.getId());
        Assert.assertEquals((Object)convertedImage.getLocation(), ((Map)this.locationIndex.get()).get("az-1.region-a.geo-1"));
        Assert.assertEquals((String)convertedImage.getName(), (String)novaImageToConvert.getName());
        Assert.assertEquals((Object)convertedImage.getStatus(), (Object)Image.Status.DELETED);
        Assert.assertEquals((Object)convertedImage.getOperatingSystem(), (Object)operatingSystem);
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void testConversionWhereLocationNotFound() {
        UUID id = UUID.randomUUID();
        org.jclouds.openstack.nova.v2_0.domain.Image novaImageToConvert = ((Image.Builder)((Image.Builder)org.jclouds.openstack.nova.v2_0.domain.Image.builder().id(id.toString())).name("Test Image " + id)).build();
        OperatingSystem operatingSystem = new OperatingSystem(OsFamily.UBUNTU, "My Test OS", "My Test Version", "x86", "My Test OS", true);
        ImageInZoneToImage converter = new ImageInZoneToImage(NovaComputeServiceContextModule.toPortableImageStatus, ImageInZoneToImageTest.constant(operatingSystem), this.locationIndex);
        ImageInZone novaImageInZoneToConvert = new ImageInZone(novaImageToConvert, "South");
        converter.apply(novaImageInZoneToConvert);
    }

    private static Function<org.jclouds.openstack.nova.v2_0.domain.Image, OperatingSystem> constant(OperatingSystem operatingSystem) {
        return (Function)Function.class.cast(Functions.constant((Object)operatingSystem));
    }
}

