/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.compute.loaders;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.easymock.EasyMock;
import org.jclouds.openstack.nova.v2_0.compute.loaders.FindSecurityGroupOrCreate;
import org.jclouds.openstack.nova.v2_0.domain.zonescoped.SecurityGroupInZone;
import org.jclouds.openstack.nova.v2_0.domain.zonescoped.ZoneAndName;
import org.jclouds.openstack.nova.v2_0.domain.zonescoped.ZoneSecurityGroupNameAndPorts;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, singleThreaded=true, testName="FindSecurityGroupOrCreateTest")
public class FindSecurityGroupOrCreateTest {
    @Test
    public void testWhenNotFoundCreatesANewSecurityGroup() throws Exception {
        Predicate returnSecurityGroupExistsInZone = Predicates.alwaysFalse();
        SecurityGroupInZone securityGroupInZone = (SecurityGroupInZone)EasyMock.createMock(SecurityGroupInZone.class);
        ZoneSecurityGroupNameAndPorts input = new ZoneSecurityGroupNameAndPorts("zone", "groupName", (Iterable)ImmutableSet.of((Object)22, (Object)8080));
        Function groupCreator = Functions.forMap((Map)ImmutableMap.of((Object)input, (Object)securityGroupInZone));
        FindSecurityGroupOrCreate parser = new FindSecurityGroupOrCreate(returnSecurityGroupExistsInZone, groupCreator);
        Assert.assertEquals((Object)parser.load((ZoneAndName)input), (Object)securityGroupInZone);
    }

    @Test
    public void testWhenFoundReturnsSecurityGroupFromAtomicReferenceValueUpdatedDuringPredicateCheck() throws Exception {
        final SecurityGroupInZone securityGroupInZone = (SecurityGroupInZone)EasyMock.createMock(SecurityGroupInZone.class);
        Predicate<AtomicReference<ZoneAndName>> returnSecurityGroupExistsInZone = new Predicate<AtomicReference<ZoneAndName>>(){

            public boolean apply(AtomicReference<ZoneAndName> input) {
                input.set((ZoneAndName)securityGroupInZone);
                return true;
            }
        };
        ZoneAndName input = ZoneAndName.fromZoneAndName((String)"zone", (String)"groupName");
        Function<ZoneSecurityGroupNameAndPorts, SecurityGroupInZone> groupCreator = new Function<ZoneSecurityGroupNameAndPorts, SecurityGroupInZone>(){

            public SecurityGroupInZone apply(ZoneSecurityGroupNameAndPorts input) {
                Assert.fail();
                return null;
            }
        };
        FindSecurityGroupOrCreate parser = new FindSecurityGroupOrCreate((Predicate)returnSecurityGroupExistsInZone, (Function)groupCreator);
        Assert.assertEquals((Object)parser.load(input), (Object)securityGroupInZone);
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void testWhenFoundPredicateMustUpdateAtomicReference() throws Exception {
        Predicate returnSecurityGroupExistsInZone = Predicates.alwaysTrue();
        ZoneAndName input = ZoneAndName.fromZoneAndName((String)"zone", (String)"groupName");
        Function<ZoneSecurityGroupNameAndPorts, SecurityGroupInZone> groupCreator = new Function<ZoneSecurityGroupNameAndPorts, SecurityGroupInZone>(){

            public SecurityGroupInZone apply(ZoneSecurityGroupNameAndPorts input) {
                Assert.fail();
                return null;
            }
        };
        FindSecurityGroupOrCreate parser = new FindSecurityGroupOrCreate(returnSecurityGroupExistsInZone, (Function)groupCreator);
        parser.load(input);
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void testWhenNotFoundInputMustBeZoneSecurityGroupNameAndPorts() throws Exception {
        Predicate returnSecurityGroupExistsInZone = Predicates.alwaysFalse();
        ZoneAndName input = ZoneAndName.fromZoneAndName((String)"zone", (String)"groupName");
        Function<ZoneSecurityGroupNameAndPorts, SecurityGroupInZone> groupCreator = new Function<ZoneSecurityGroupNameAndPorts, SecurityGroupInZone>(){

            public SecurityGroupInZone apply(ZoneSecurityGroupNameAndPorts input) {
                Assert.fail();
                return null;
            }
        };
        FindSecurityGroupOrCreate parser = new FindSecurityGroupOrCreate(returnSecurityGroupExistsInZone, (Function)groupCreator);
        parser.load(input);
    }
}

