/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.compute.loaders;

import com.google.common.base.Optional;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.easymock.EasyMock;
import org.jclouds.openstack.nova.v2_0.NovaApi;
import org.jclouds.openstack.nova.v2_0.compute.loaders.LoadFloatingIpsForInstance;
import org.jclouds.openstack.nova.v2_0.domain.FloatingIP;
import org.jclouds.openstack.nova.v2_0.domain.zonescoped.ZoneAndId;
import org.jclouds.openstack.nova.v2_0.extensions.FloatingIPApi;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"unit"}, singleThreaded=true, testName="LoadFloatingIpsForInstanceTest")
public class LoadFloatingIpsForInstanceTest {
    @Test
    public void testReturnsPublicIpOnMatch() throws Exception {
        NovaApi api = (NovaApi)EasyMock.createMock(NovaApi.class);
        FloatingIPApi ipApi = (FloatingIPApi)EasyMock.createMock(FloatingIPApi.class);
        FloatingIP testIp = FloatingIP.builder().id("1").ip("1.1.1.1").fixedIp("10.1.1.1").instanceId("i-blah").build();
        EasyMock.expect((Object)api.getFloatingIPExtensionForZone("Zone")).andReturn((Object)Optional.of((Object)ipApi)).atLeastOnce();
        EasyMock.expect((Object)ipApi.list()).andReturn((Object)FluentIterable.from((Iterable)ImmutableSet.of((Object)testIp))).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{api});
        EasyMock.replay((Object[])new Object[]{ipApi});
        LoadFloatingIpsForInstance parser = new LoadFloatingIpsForInstance(api);
        Assert.assertEquals((Set)ImmutableSet.copyOf((Iterable)parser.load(ZoneAndId.fromZoneAndId((String)"Zone", (String)"i-blah"))), (Set)ImmutableSet.of((Object)testIp));
        EasyMock.verify((Object[])new Object[]{api});
        EasyMock.verify((Object[])new Object[]{ipApi});
    }

    @Test
    public void testReturnsNullWhenNotFound() throws Exception {
        NovaApi api = (NovaApi)EasyMock.createMock(NovaApi.class);
        FloatingIPApi ipApi = (FloatingIPApi)EasyMock.createMock(FloatingIPApi.class);
        EasyMock.expect((Object)api.getFloatingIPExtensionForZone("Zone")).andReturn((Object)Optional.of((Object)ipApi)).atLeastOnce();
        EasyMock.expect((Object)ipApi.list()).andReturn((Object)FluentIterable.from((Iterable)ImmutableSet.of())).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{api});
        EasyMock.replay((Object[])new Object[]{ipApi});
        LoadFloatingIpsForInstance parser = new LoadFloatingIpsForInstance(api);
        AssertJUnit.assertFalse((boolean)parser.load(ZoneAndId.fromZoneAndId((String)"Zone", (String)"i-blah")).iterator().hasNext());
        EasyMock.verify((Object[])new Object[]{api});
        EasyMock.verify((Object[])new Object[]{ipApi});
    }

    @Test
    public void testReturnsNullWhenNotAssigned() throws Exception {
        NovaApi api = (NovaApi)EasyMock.createMock(NovaApi.class);
        FloatingIPApi ipApi = (FloatingIPApi)EasyMock.createMock(FloatingIPApi.class);
        EasyMock.expect((Object)api.getFloatingIPExtensionForZone("Zone")).andReturn((Object)Optional.of((Object)ipApi)).atLeastOnce();
        EasyMock.expect((Object)ipApi.list()).andReturn((Object)FluentIterable.from((Iterable)ImmutableSet.of((Object)FloatingIP.builder().id("1").ip("1.1.1.1").build()))).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{api});
        EasyMock.replay((Object[])new Object[]{ipApi});
        LoadFloatingIpsForInstance parser = new LoadFloatingIpsForInstance(api);
        AssertJUnit.assertFalse((boolean)parser.load(ZoneAndId.fromZoneAndId((String)"Zone", (String)"i-blah")).iterator().hasNext());
        EasyMock.verify((Object[])new Object[]{api});
        EasyMock.verify((Object[])new Object[]{ipApi});
    }
}

