/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.extensions;

import com.google.common.collect.ImmutableMap;
import java.net.URI;
import java.util.Map;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.openstack.nova.v2_0.NovaApi;
import org.jclouds.openstack.nova.v2_0.domain.BackupType;
import org.jclouds.openstack.nova.v2_0.extensions.ServerAdminApi;
import org.jclouds.openstack.nova.v2_0.internal.BaseNovaApiExpectTest;
import org.jclouds.openstack.nova.v2_0.options.CreateBackupOfServerOptions;
import org.jclouds.rest.AuthorizationException;
import org.jclouds.rest.ResourceNotFoundException;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="AdminActionsApiExpectTest")
public class AdminActionsApiExpectTest
extends BaseNovaApiExpectTest {
    public void testSuspend() {
        URI endpoint = URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/servers/1/action");
        ServerAdminApi api = (ServerAdminApi)((NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, this.standardActionRequestBuilderVoidResponse(endpoint, "suspend").build(), HttpResponse.builder().statusCode(202).build())).getServerAdminExtensionForZone("az-1.region-a.geo-1").get();
        Assert.assertTrue((boolean)api.suspend("1"));
    }

    public void testSuspendFailsNotFound() {
        URI endpoint = URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/servers/1/action");
        ServerAdminApi api = (ServerAdminApi)((NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, this.standardActionRequestBuilderVoidResponse(endpoint, "suspend").build(), HttpResponse.builder().statusCode(404).build())).getServerAdminExtensionForZone("az-1.region-a.geo-1").get();
        Assert.assertFalse((boolean)api.suspend("1"));
    }

    @Test(expectedExceptions={AuthorizationException.class})
    public void testSuspendFailsNotAuthorized() {
        URI endpoint = URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/servers/1/action");
        ServerAdminApi api = (ServerAdminApi)((NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, this.standardActionRequestBuilderVoidResponse(endpoint, "suspend").build(), HttpResponse.builder().statusCode(403).build())).getServerAdminExtensionForZone("az-1.region-a.geo-1").get();
        api.suspend("1");
    }

    public void testResume() {
        URI endpoint = URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/servers/1/action");
        ServerAdminApi api = (ServerAdminApi)((NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, this.standardActionRequestBuilderVoidResponse(endpoint, "resume").build(), HttpResponse.builder().statusCode(202).build())).getServerAdminExtensionForZone("az-1.region-a.geo-1").get();
        Assert.assertTrue((boolean)api.resume("1"));
    }

    public void testResumeFailsNotFound() {
        URI endpoint = URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/servers/1/action");
        ServerAdminApi api = (ServerAdminApi)((NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, this.standardActionRequestBuilderVoidResponse(endpoint, "resume").build(), HttpResponse.builder().statusCode(404).build())).getServerAdminExtensionForZone("az-1.region-a.geo-1").get();
        Assert.assertFalse((boolean)api.resume("1"));
    }

    @Test(expectedExceptions={AuthorizationException.class})
    public void testResumeFailsNotAuthorized() {
        URI endpoint = URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/servers/1/action");
        ServerAdminApi api = (ServerAdminApi)((NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, this.standardActionRequestBuilderVoidResponse(endpoint, "resume").build(), HttpResponse.builder().statusCode(403).build())).getServerAdminExtensionForZone("az-1.region-a.geo-1").get();
        api.resume("1");
    }

    public void testLock() {
        URI endpoint = URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/servers/1/action");
        ServerAdminApi api = (ServerAdminApi)((NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, this.standardActionRequestBuilderVoidResponse(endpoint, "lock").build(), HttpResponse.builder().statusCode(202).build())).getServerAdminExtensionForZone("az-1.region-a.geo-1").get();
        Assert.assertTrue((boolean)api.lock("1"));
    }

    public void testLockFailsNotFound() {
        URI endpoint = URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/servers/1/action");
        ServerAdminApi api = (ServerAdminApi)((NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, this.standardActionRequestBuilderVoidResponse(endpoint, "lock").build(), HttpResponse.builder().statusCode(404).build())).getServerAdminExtensionForZone("az-1.region-a.geo-1").get();
        Assert.assertFalse((boolean)api.lock("1"));
    }

    public void testUnlock() {
        URI endpoint = URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/servers/1/action");
        ServerAdminApi api = (ServerAdminApi)((NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, this.standardActionRequestBuilderVoidResponse(endpoint, "unlock").build(), HttpResponse.builder().statusCode(202).build())).getServerAdminExtensionForZone("az-1.region-a.geo-1").get();
        Assert.assertTrue((boolean)api.unlock("1"));
    }

    public void testUnlockFailsNotFound() {
        URI endpoint = URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/servers/1/action");
        ServerAdminApi api = (ServerAdminApi)((NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, this.standardActionRequestBuilderVoidResponse(endpoint, "unlock").build(), HttpResponse.builder().statusCode(404).build())).getServerAdminExtensionForZone("az-1.region-a.geo-1").get();
        Assert.assertFalse((boolean)api.unlock("1"));
    }

    public void testPause() {
        URI endpoint = URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/servers/1/action");
        ServerAdminApi api = (ServerAdminApi)((NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, this.standardActionRequestBuilderVoidResponse(endpoint, "pause").build(), HttpResponse.builder().statusCode(202).build())).getServerAdminExtensionForZone("az-1.region-a.geo-1").get();
        Assert.assertTrue((boolean)api.pause("1"));
    }

    public void testPauseFailsNotFound() {
        URI endpoint = URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/servers/1/action");
        ServerAdminApi api = (ServerAdminApi)((NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, this.standardActionRequestBuilderVoidResponse(endpoint, "pause").build(), HttpResponse.builder().statusCode(404).build())).getServerAdminExtensionForZone("az-1.region-a.geo-1").get();
        Assert.assertFalse((boolean)api.pause("1"));
    }

    public void testUnpause() {
        URI endpoint = URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/servers/1/action");
        ServerAdminApi api = (ServerAdminApi)((NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, this.standardActionRequestBuilderVoidResponse(endpoint, "unpause").build(), HttpResponse.builder().statusCode(202).build())).getServerAdminExtensionForZone("az-1.region-a.geo-1").get();
        Assert.assertTrue((boolean)api.unpause("1"));
    }

    public void testUnpauseFailsNotFound() {
        URI endpoint = URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/servers/1/action");
        ServerAdminApi api = (ServerAdminApi)((NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, this.standardActionRequestBuilderVoidResponse(endpoint, "unpause").build(), HttpResponse.builder().statusCode(404).build())).getServerAdminExtensionForZone("az-1.region-a.geo-1").get();
        Assert.assertFalse((boolean)api.unpause("1"));
    }

    public void testMigrateServer() {
        URI endpoint = URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/servers/1/action");
        ServerAdminApi api = (ServerAdminApi)((NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, this.standardActionRequestBuilderVoidResponse(endpoint, "migrate").build(), HttpResponse.builder().statusCode(202).build())).getServerAdminExtensionForZone("az-1.region-a.geo-1").get();
        Assert.assertTrue((boolean)api.migrate("1"));
    }

    public void testMigrateServerFailsNotFound() {
        URI endpoint = URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/servers/1/action");
        ServerAdminApi api = (ServerAdminApi)((NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, this.standardActionRequestBuilderVoidResponse(endpoint, "migrate").build(), HttpResponse.builder().statusCode(404).build())).getServerAdminExtensionForZone("az-1.region-a.geo-1").get();
        Assert.assertFalse((boolean)api.migrate("1"));
    }

    public void testResetNetworkOfServer() {
        URI endpoint = URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/servers/1/action");
        ServerAdminApi api = (ServerAdminApi)((NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, this.standardActionRequestBuilderVoidResponse(endpoint, "resetNetwork").build(), HttpResponse.builder().statusCode(202).build())).getServerAdminExtensionForZone("az-1.region-a.geo-1").get();
        Assert.assertTrue((boolean)api.resetNetwork("1"));
    }

    public void testResetNetworkOfServerFailsNotFound() {
        URI endpoint = URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/servers/1/action");
        ServerAdminApi api = (ServerAdminApi)((NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, this.standardActionRequestBuilderVoidResponse(endpoint, "resetNetwork").build(), HttpResponse.builder().statusCode(404).build())).getServerAdminExtensionForZone("az-1.region-a.geo-1").get();
        Assert.assertFalse((boolean)api.resetNetwork("1"));
    }

    public void testInjectNetworkInfoIntoServer() {
        URI endpoint = URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/servers/1/action");
        ServerAdminApi api = (ServerAdminApi)((NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, this.standardActionRequestBuilderVoidResponse(endpoint, "injectNetworkInfo").build(), HttpResponse.builder().statusCode(202).build())).getServerAdminExtensionForZone("az-1.region-a.geo-1").get();
        Assert.assertTrue((boolean)api.injectNetworkInfo("1"));
    }

    public void testInjectNetworkInfoIntoServerFailsNotFound() {
        URI endpoint = URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/servers/1/action");
        ServerAdminApi api = (ServerAdminApi)((NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, this.standardActionRequestBuilderVoidResponse(endpoint, "injectNetworkInfo").build(), HttpResponse.builder().statusCode(404).build())).getServerAdminExtensionForZone("az-1.region-a.geo-1").get();
        Assert.assertFalse((boolean)api.injectNetworkInfo("1"));
    }

    public void testBackupServer() {
        ServerAdminApi api = (ServerAdminApi)((NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, ((HttpRequest.Builder)this.authenticatedGET().endpoint("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/servers/1/action").method("POST").payload(AdminActionsApiExpectTest.payloadFromStringWithContentType((String)"{\"createBackup\":{\"backup_type\":\"weekly\",\"rotation\":3,\"name\":\"mybackup\",\"metadata\":{\"some\":\"data or other\"}}}", (String)"application/json"))).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(202).addHeader("Location", new String[]{"http://172.16.89.149:8774/v2/images/1976b3b3-409a-468d-b16c-a9172c341b46"})).build())).getServerAdminExtensionForZone("az-1.region-a.geo-1").get();
        String imageId = api.createBackup("1", "mybackup", BackupType.WEEKLY, 3, new CreateBackupOfServerOptions[]{CreateBackupOfServerOptions.Builder.metadata((Map)ImmutableMap.of((Object)"some", (Object)"data or other"))});
        Assert.assertEquals((String)imageId, (String)"1976b3b3-409a-468d-b16c-a9172c341b46");
    }

    @Test(expectedExceptions={ResourceNotFoundException.class})
    public void testBackupServerFailNotFound() {
        URI endpoint = URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/servers/1/action");
        ServerAdminApi api = (ServerAdminApi)((NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, ((HttpRequest.Builder)this.authenticatedGET().endpoint(endpoint).method("POST").payload(AdminActionsApiExpectTest.payloadFromStringWithContentType((String)"{\"createBackup\":{\"backup_type\":\"weekly\",\"rotation\":3,\"name\":\"mybackup\",\"metadata\":{\"some\":\"data or other\"}}}", (String)"application/json"))).build(), HttpResponse.builder().statusCode(404).build())).getServerAdminExtensionForZone("az-1.region-a.geo-1").get();
        api.createBackup("1", "mybackup", BackupType.WEEKLY, 3, new CreateBackupOfServerOptions[]{CreateBackupOfServerOptions.Builder.metadata((Map)ImmutableMap.of((Object)"some", (Object)"data or other"))});
    }

    public void testLiveMigrateServer() {
        URI endpoint = URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/servers/1/action");
        ServerAdminApi api = (ServerAdminApi)((NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, ((HttpRequest.Builder)this.standardActionRequestBuilderVoidResponse(endpoint, "GONNAOVERWRITE").payload(AdminActionsApiExpectTest.payloadFromStringWithContentType((String)"{\"os-migrateLive\":{\"host\":\"bighost\",\"block_migration\":true,\"disk_over_commit\":false}}", (String)"application/json"))).build(), HttpResponse.builder().statusCode(202).build())).getServerAdminExtensionForZone("az-1.region-a.geo-1").get();
        Assert.assertTrue((boolean)api.liveMigrate("1", "bighost", true, false));
    }

    public void testLiveMigrateServerFailsNotFound() {
        URI endpoint = URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/servers/1/action");
        ServerAdminApi api = (ServerAdminApi)((NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, ((HttpRequest.Builder)this.standardActionRequestBuilderVoidResponse(endpoint, "GONNAOVERWRITE").payload(AdminActionsApiExpectTest.payloadFromStringWithContentType((String)"{\"os-migrateLive\":{\"host\":\"bighost\",\"block_migration\":true,\"disk_over_commit\":false}}", (String)"application/json"))).build(), HttpResponse.builder().statusCode(404).build())).getServerAdminExtensionForZone("az-1.region-a.geo-1").get();
        Assert.assertFalse((boolean)api.liveMigrate("1", "bighost", true, false));
    }

    protected HttpRequest.Builder<?> standardActionRequestBuilderVoidResponse(URI endpoint, String actionName) {
        return ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").addHeader("X-Auth-Token", new String[]{this.authToken})).payload(AdminActionsApiExpectTest.payloadFromStringWithContentType((String)("{\"" + actionName + "\":null}"), (String)"application/json"))).endpoint(endpoint);
    }
}

