/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.extensions;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Map;
import java.util.Set;
import org.jclouds.openstack.nova.v2_0.NovaApi;
import org.jclouds.openstack.nova.v2_0.domain.Host;
import org.jclouds.openstack.nova.v2_0.domain.HostAggregate;
import org.jclouds.openstack.nova.v2_0.extensions.HostAdministrationApi;
import org.jclouds.openstack.nova.v2_0.extensions.HostAggregateApi;
import org.jclouds.openstack.nova.v2_0.internal.BaseNovaApiLiveTest;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"live"}, testName="AggregateApiLiveTest", singleThreaded=true)
public class HostAggregateApiLiveTest
extends BaseNovaApiLiveTest {
    private Optional<? extends HostAggregateApi> apiOption;
    private Optional<? extends HostAdministrationApi> hostAdminOption;
    private HostAggregate testAggregate;

    @Override
    @BeforeClass(groups={"integration", "live"})
    public void setup() {
        super.setup();
        String zone = (String)Iterables.getLast((Iterable)((NovaApi)this.api).getConfiguredZones(), (Object)"nova");
        this.apiOption = ((NovaApi)this.api).getHostAggregateExtensionForZone(zone);
        this.hostAdminOption = ((NovaApi)this.api).getHostAdministrationExtensionForZone(zone);
    }

    @AfterClass(groups={"integration", "live"})
    protected void tearDown() {
        if (this.testAggregate != null) {
            Assert.assertTrue((boolean)((HostAggregateApi)this.apiOption.get()).delete(this.testAggregate.getId()));
        }
        super.tearDown();
    }

    public void testCreateAggregate() {
        if (this.apiOption.isPresent()) {
            this.testAggregate = ((HostAggregateApi)this.apiOption.get()).createInAvailabilityZone("jclouds-test-a", "nova");
        }
    }

    @Test(dependsOnMethods={"testCreateAggregate"})
    public void testListAndGetAggregate() {
        if (this.apiOption.isPresent()) {
            HostAggregateApi api = (HostAggregateApi)this.apiOption.get();
            ImmutableSet aggregates = api.list().toSet();
            for (HostAggregate aggregate : aggregates) {
                Assert.assertNotNull((Object)aggregate.getId());
                Assert.assertNotNull((Object)aggregate.getName());
                Assert.assertNotNull((Object)aggregate.getAvailabilityZone());
                HostAggregate details = api.get(aggregate.getId());
                Assert.assertEquals((String)details.getId(), (String)aggregate.getId());
                Assert.assertEquals((String)details.getName(), (String)aggregate.getName());
                Assert.assertEquals((String)details.getAvailabilityZone(), (String)aggregate.getAvailabilityZone());
                Assert.assertEquals((Set)details.getHosts(), (Set)aggregate.getHosts());
            }
        }
    }

    @Test(dependsOnMethods={"testCreateAggregate"})
    public void testModifyMetadata() {
        if (this.apiOption.isPresent()) {
            HostAggregateApi api = (HostAggregateApi)this.apiOption.get();
            for (Map theMetaData : ImmutableSet.of((Object)ImmutableMap.of((Object)"somekey", (Object)"somevalue"), (Object)ImmutableMap.of((Object)"somekey", (Object)"some other value", (Object)"anotherkey", (Object)"another val"))) {
                HostAggregate details = api.setMetadata(this.testAggregate.getId(), theMetaData);
                for (Map.Entry entry : theMetaData.entrySet()) {
                    Assert.assertEquals((String)((String)details.getMetadata().get(entry.getKey())), (String)((String)entry.getValue()));
                }
                details = api.get(this.testAggregate.getId());
                for (Map.Entry entry : theMetaData.entrySet()) {
                    Assert.assertEquals((String)((String)details.getMetadata().get(entry.getKey())), (String)((String)entry.getValue()));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(enabled=false, dependsOnMethods={"testCreateAggregate"})
    public void testModifyHosts() {
        if (this.apiOption.isPresent() && this.hostAdminOption.isPresent()) {
            HostAggregate details;
            HostAggregateApi api = (HostAggregateApi)this.apiOption.get();
            Host host = (Host)Iterables.getFirst((Iterable)((HostAdministrationApi)this.hostAdminOption.get()).list(), null);
            Assert.assertNotNull((Object)host);
            String host_id = host.getName();
            Assert.assertNotNull((Object)host_id);
            try {
                details = api.addHost(this.testAggregate.getId(), host_id);
                Assert.assertEquals((Set)details.getHosts(), (Set)ImmutableSet.of((Object)host_id));
                details = api.get(this.testAggregate.getId());
                Assert.assertEquals((Set)details.getHosts(), (Set)ImmutableSet.of((Object)host_id));
            }
            finally {
                details = api.removeHost(this.testAggregate.getId(), host_id);
            }
            Assert.assertEquals((Set)details.getHosts(), (Set)ImmutableSet.of());
        }
    }
}

