/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.extensions;

import com.google.common.base.Optional;
import com.google.common.collect.Iterables;
import org.jclouds.openstack.nova.v2_0.NovaApi;
import org.jclouds.openstack.nova.v2_0.domain.Quota;
import org.jclouds.openstack.nova.v2_0.extensions.QuotaApi;
import org.jclouds.openstack.nova.v2_0.internal.BaseNovaApiLiveTest;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"live"}, testName="QuotaApiLiveTest", singleThreaded=true)
public class QuotaApiLiveTest
extends BaseNovaApiLiveTest {
    private Optional<? extends QuotaApi> apiOption;
    private String tenant;

    @Override
    @BeforeClass(groups={"integration", "live"})
    public void setup() {
        super.setup();
        this.tenant = this.identity.split(":")[0];
        String zone = (String)Iterables.getLast((Iterable)((NovaApi)this.api).getConfiguredZones(), (Object)"nova");
        this.apiOption = ((NovaApi)this.api).getQuotaExtensionForZone(zone);
    }

    public void testGetQuotasForCurrentTenant() {
        if (this.apiOption.isPresent()) {
            Quota quota = ((QuotaApi)this.apiOption.get()).getByTenant(this.tenant);
            this.assertQuotasIsValid(quota);
        }
    }

    public void testGetDefaultQuotasForCurrentTenant() {
        if (this.apiOption.isPresent()) {
            Quota quota = ((QuotaApi)this.apiOption.get()).getDefaultsForTenant(this.tenant);
            this.assertQuotasIsValid(quota);
        }
    }

    public void testUpdateQuotasOfCurrentTenantThenReset() {
        if (this.apiOption.isPresent()) {
            QuotaApi api = (QuotaApi)this.apiOption.get();
            Quota before = api.getByTenant(this.tenant);
            this.assertQuotasIsValid(before);
            Quota modified = before.toBuilder().cores(before.getCores() - 1).instances(before.getInstances() - 1).metadataItems(before.getMetadatas() - 1).ram(before.getRam() - 1).volumes(before.getVolumes() - 1).build();
            Assert.assertTrue((boolean)api.updateQuotaOfTenant(modified, this.tenant));
            Assert.assertEquals((Object)api.getByTenant(this.tenant), (Object)modified);
            Assert.assertTrue((boolean)api.updateQuotaOfTenant(before, this.tenant));
            Assert.assertEquals((Object)api.getByTenant(this.tenant), (Object)before);
        }
    }

    protected void assertQuotasIsValid(Quota quota) {
        Assert.assertTrue((quota.getCores() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((quota.getFloatingIps() >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((quota.getGigabytes() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((quota.getInjectedFileContentBytes() >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((quota.getInjectedFiles() >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((quota.getInstances() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((quota.getKeyPairs() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((quota.getRam() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((quota.getSecurityGroups() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((quota.getSecurityGroupRules() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((quota.getVolumes() > 0 ? 1 : 0) != 0);
    }
}

