/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.extensions;

import java.net.URI;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.openstack.nova.v2_0.NovaApi;
import org.jclouds.openstack.nova.v2_0.domain.QuotaClass;
import org.jclouds.openstack.nova.v2_0.extensions.QuotaClassApi;
import org.jclouds.openstack.nova.v2_0.internal.BaseNovaApiExpectTest;
import org.jclouds.rest.ResourceNotFoundException;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="QuotaClassApiExpectTest")
public class QuotaClassApiExpectTest
extends BaseNovaApiExpectTest {
    public void testGetQuotas() throws Exception {
        URI endpoint = URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/os-quota-class-sets/jcloudstestquotas");
        QuotaClassApi api = (QuotaClassApi)((NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, this.authenticatedGET().endpoint(endpoint).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/quota_class.json"))).build())).getQuotaClassExtensionForZone("az-1.region-a.geo-1").get();
        Assert.assertEquals((Object)api.get("jcloudstestquotas"), (Object)QuotaClassApiExpectTest.getTestQuotas());
    }

    public void testGetQuotasFailsTenantNotFound() throws Exception {
        URI endpoint = URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/os-quota-class-sets/jcloudstestquotas");
        QuotaClassApi api = (QuotaClassApi)((NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, this.authenticatedGET().endpoint(endpoint).build(), HttpResponse.builder().statusCode(404).build())).getQuotaClassExtensionForZone("az-1.region-a.geo-1").get();
        Assert.assertNull((Object)api.get("jcloudstestquotas"));
    }

    public void testUpdateQuotas() throws Exception {
        URI endpoint = URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/os-quota-class-sets/myclass");
        QuotaClassApi api = (QuotaClassApi)((NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().endpoint(endpoint).method("PUT").addHeader("X-Auth-Token", new String[]{this.authToken})).payload(this.payloadFromResourceWithContentType("/quota_class.json", "application/json"))).build(), HttpResponse.builder().statusCode(200).build())).getQuotaClassExtensionForZone("az-1.region-a.geo-1").get();
        Assert.assertTrue((boolean)api.update("myclass", QuotaClassApiExpectTest.getTestQuotas()));
    }

    @Test(expectedExceptions={ResourceNotFoundException.class})
    public void testUpdateQuotasFailsNotFound() throws Exception {
        URI endpoint = URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/os-quota-class-sets/jcloudstestquotas");
        QuotaClassApi api = (QuotaClassApi)((NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().endpoint(endpoint).method("PUT").addHeader("X-Auth-Token", new String[]{this.authToken})).payload(this.payloadFromResourceWithContentType("/quota_class.json", "application/json"))).build(), HttpResponse.builder().statusCode(404).build())).getQuotaClassExtensionForZone("az-1.region-a.geo-1").get();
        api.update("jcloudstestquotas", QuotaClassApiExpectTest.getTestQuotas());
    }

    public static QuotaClass getTestQuotas() {
        return ((QuotaClass.Builder)((QuotaClass.Builder)((QuotaClass.Builder)((QuotaClass.Builder)((QuotaClass.Builder)((QuotaClass.Builder)((QuotaClass.Builder)((QuotaClass.Builder)((QuotaClass.Builder)((QuotaClass.Builder)((QuotaClass.Builder)((QuotaClass.Builder)((QuotaClass.Builder)QuotaClass.builder().metadataItems(128)).injectedFileContentBytes(10240)).injectedFiles(5)).gigabytes(1000)).ram(4096)).floatingIps(10)).securityGroups(10)).securityGroupRules(20)).instances(5)).keyPairs(100)).volumes(5)).cores(10)).id("jcloudstestquotas")).build();
    }
}

