/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.extensions;

import com.google.common.collect.Iterables;
import java.net.URI;
import org.jclouds.http.HttpResponse;
import org.jclouds.openstack.nova.v2_0.NovaApi;
import org.jclouds.openstack.nova.v2_0.domain.VirtualInterface;
import org.jclouds.openstack.nova.v2_0.extensions.VirtualInterfaceApi;
import org.jclouds.openstack.nova.v2_0.internal.BaseNovaApiExpectTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"live"}, testName="VirtualInterfaceApiLiveTest")
public class VirtualInterfaceApiExpectTest
extends BaseNovaApiExpectTest {
    public void testListVirtualInterfaces() {
        URI endpoint = URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/servers/1/os-virtual-interfaces");
        VirtualInterfaceApi api = (VirtualInterfaceApi)((NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, this.authenticatedGET().endpoint(endpoint).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/virtual_interfaces_list.json"))).build())).getVirtualInterfaceExtensionForZone("az-1.region-a.geo-1").get();
        VirtualInterface vif = (VirtualInterface)Iterables.getOnlyElement((Iterable)api.listOnServer("1"));
        Assert.assertEquals((String)vif.getId(), (String)"02315827-b05c-4668-9c05-75c68838074a");
        Assert.assertEquals((String)vif.getMacAddress(), (String)"fa:16:3e:09:71:34");
    }

    public void testListVirtualInterfacesFailNotFound() {
        URI endpoint = URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/servers/1/os-virtual-interfaces");
        VirtualInterfaceApi api = (VirtualInterfaceApi)((NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, this.authenticatedGET().endpoint(endpoint).build(), HttpResponse.builder().statusCode(404).build())).getVirtualInterfaceExtensionForZone("az-1.region-a.geo-1").get();
        Assert.assertTrue((boolean)api.listOnServer("1").isEmpty());
    }
}

