/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.extensions;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import org.jclouds.openstack.nova.v2_0.NovaApi;
import org.jclouds.openstack.nova.v2_0.domain.Volume;
import org.jclouds.openstack.nova.v2_0.domain.VolumeAttachment;
import org.jclouds.openstack.nova.v2_0.domain.VolumeSnapshot;
import org.jclouds.openstack.nova.v2_0.extensions.VolumeApi;
import org.jclouds.openstack.nova.v2_0.internal.BaseNovaApiLiveTest;
import org.jclouds.openstack.nova.v2_0.options.CreateVolumeOptions;
import org.jclouds.openstack.nova.v2_0.options.CreateVolumeSnapshotOptions;
import org.jclouds.util.Predicates2;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"live"}, testName="VolumeApiLiveTest", singleThreaded=true)
public class VolumeApiLiveTest
extends BaseNovaApiLiveTest {
    private Optional<? extends VolumeApi> volumeOption;
    private String zone;
    private Volume testVolume;
    private VolumeSnapshot testSnapshot;

    @Override
    @BeforeClass(groups={"integration", "live"})
    public void setup() {
        super.setup();
        this.zone = (String)Iterables.getLast((Iterable)((NovaApi)this.api).getConfiguredZones(), (Object)"nova");
        this.volumeOption = ((NovaApi)this.api).getVolumeExtensionForZone(this.zone);
    }

    @AfterClass(groups={"integration", "live"})
    protected void tearDown() {
        if (this.volumeOption.isPresent()) {
            if (this.testSnapshot != null) {
                final String snapshotId = this.testSnapshot.getId();
                Assert.assertTrue((boolean)((VolumeApi)this.volumeOption.get()).deleteSnapshot(snapshotId));
                Assert.assertTrue((boolean)Predicates2.retry((Predicate)new Predicate<VolumeApi>(){

                    public boolean apply(VolumeApi volumeApi) {
                        return ((VolumeApi)VolumeApiLiveTest.this.volumeOption.get()).getSnapshot(snapshotId) == null;
                    }
                }, (long)30000L).apply(this.volumeOption.get()));
            }
            if (this.testVolume != null) {
                final String volumeId = this.testVolume.getId();
                Assert.assertTrue((boolean)((VolumeApi)this.volumeOption.get()).delete(volumeId));
                Assert.assertTrue((boolean)Predicates2.retry((Predicate)new Predicate<VolumeApi>(){

                    public boolean apply(VolumeApi volumeApi) {
                        return ((VolumeApi)VolumeApiLiveTest.this.volumeOption.get()).get(volumeId) == null;
                    }
                }, (long)180000L).apply(this.volumeOption.get()));
            }
        }
        super.tearDown();
    }

    public void testCreateVolume() {
        if (this.volumeOption.isPresent()) {
            this.testVolume = ((VolumeApi)this.volumeOption.get()).create(1, new CreateVolumeOptions[]{CreateVolumeOptions.Builder.name((String)"jclouds-test-volume").description("description of test volume").availabilityZone(this.zone)});
            Assert.assertTrue((boolean)Predicates2.retry((Predicate)new Predicate<VolumeApi>(){

                public boolean apply(VolumeApi volumeApi) {
                    return ((VolumeApi)VolumeApiLiveTest.this.volumeOption.get()).get(VolumeApiLiveTest.this.testVolume.getId()).getStatus() == Volume.Status.AVAILABLE;
                }
            }, (long)180000L).apply(this.volumeOption.get()));
        }
    }

    @Test(dependsOnMethods={"testCreateVolume"})
    public void testListVolumes() {
        if (this.volumeOption.isPresent()) {
            ImmutableSet volumes = ((VolumeApi)this.volumeOption.get()).list().toSet();
            Assert.assertNotNull((Object)volumes);
            boolean foundIt = false;
            for (Volume vol : volumes) {
                Volume details = ((VolumeApi)this.volumeOption.get()).get(vol.getId());
                Assert.assertNotNull((Object)details);
                if (!Objects.equal((Object)details.getId(), (Object)this.testVolume.getId())) continue;
                foundIt = true;
            }
            Assert.assertTrue((boolean)foundIt, (String)"Failed to find the volume we created in list() response");
        }
    }

    @Test(dependsOnMethods={"testCreateVolume"})
    public void testListVolumesInDetail() {
        if (this.volumeOption.isPresent()) {
            ImmutableSet volumes = ((VolumeApi)this.volumeOption.get()).listInDetail().toSet();
            Assert.assertNotNull((Object)volumes);
            boolean foundIt = false;
            for (Volume vol : volumes) {
                Volume details = ((VolumeApi)this.volumeOption.get()).get(vol.getId());
                Assert.assertNotNull((Object)details);
                Assert.assertNotNull((Object)details.getId());
                Assert.assertNotNull((Object)details.getCreated());
                Assert.assertTrue((details.getSize() > -1 ? 1 : 0) != 0);
                Assert.assertEquals((String)details.getId(), (String)vol.getId());
                Assert.assertEquals((int)details.getSize(), (int)vol.getSize());
                Assert.assertEquals((String)details.getName(), (String)vol.getName());
                Assert.assertEquals((String)details.getDescription(), (String)vol.getDescription());
                Assert.assertEquals((Object)details.getCreated(), (Object)vol.getCreated());
                if (!Objects.equal((Object)details.getId(), (Object)this.testVolume.getId())) continue;
                foundIt = true;
            }
            Assert.assertTrue((boolean)foundIt, (String)"Failed to find the volume we previously created in listInDetail() response");
        }
    }

    @Test(dependsOnMethods={"testCreateVolume"})
    public void testCreateSnapshot() {
        if (this.volumeOption.isPresent()) {
            this.testSnapshot = ((VolumeApi)this.volumeOption.get()).createSnapshot(this.testVolume.getId(), new CreateVolumeSnapshotOptions[]{CreateVolumeSnapshotOptions.Builder.name((String)"jclouds-live-test").description("jclouds live test snapshot").force()});
            Assert.assertNotNull((Object)this.testSnapshot);
            Assert.assertNotNull((Object)this.testSnapshot.getId());
            final String snapshotId = this.testSnapshot.getId();
            Assert.assertNotNull((Object)this.testSnapshot.getStatus());
            Assert.assertTrue((this.testSnapshot.getSize() > -1 ? 1 : 0) != 0);
            Assert.assertNotNull((Object)this.testSnapshot.getCreated());
            Assert.assertTrue((boolean)Predicates2.retry((Predicate)new Predicate<VolumeApi>(){

                public boolean apply(VolumeApi volumeApi) {
                    return ((VolumeApi)VolumeApiLiveTest.this.volumeOption.get()).getSnapshot(snapshotId).getStatus() == Volume.Status.AVAILABLE;
                }
            }, (long)30000L).apply(this.volumeOption.get()));
        }
    }

    @Test(dependsOnMethods={"testCreateSnapshot"})
    public void testListSnapshots() {
        if (this.volumeOption.isPresent()) {
            ImmutableSet snapshots = ((VolumeApi)this.volumeOption.get()).listSnapshots().toSet();
            Assert.assertNotNull((Object)snapshots);
            boolean foundIt = false;
            for (VolumeSnapshot snap : snapshots) {
                VolumeSnapshot details = ((VolumeApi)this.volumeOption.get()).getSnapshot(snap.getId());
                if (Objects.equal((Object)snap.getVolumeId(), (Object)this.testVolume.getId())) {
                    foundIt = true;
                }
                Assert.assertNotNull((Object)details);
                Assert.assertEquals((String)details.getId(), (String)snap.getId());
                Assert.assertEquals((String)details.getVolumeId(), (String)snap.getVolumeId());
            }
            Assert.assertTrue((boolean)foundIt, (String)"Failed to find the snapshot we previously created in listSnapshots() response");
        }
    }

    @Test(dependsOnMethods={"testCreateSnapshot"})
    public void testListSnapshotsInDetail() {
        if (this.volumeOption.isPresent()) {
            ImmutableSet snapshots = ((VolumeApi)this.volumeOption.get()).listSnapshotsInDetail().toSet();
            Assert.assertNotNull((Object)snapshots);
            boolean foundIt = false;
            for (VolumeSnapshot snap : snapshots) {
                VolumeSnapshot details = ((VolumeApi)this.volumeOption.get()).getSnapshot(snap.getId());
                if (Objects.equal((Object)snap.getVolumeId(), (Object)this.testVolume.getId())) {
                    foundIt = true;
                    this.assertSame(details, this.testSnapshot);
                }
                this.assertSame(details, snap);
            }
            Assert.assertTrue((boolean)foundIt, (String)"Failed to find the snapshot we created in listSnapshotsInDetail() response");
        }
    }

    private void assertSame(VolumeSnapshot a, VolumeSnapshot b) {
        Assert.assertNotNull((Object)a);
        Assert.assertNotNull((Object)b);
        Assert.assertEquals((String)a.getId(), (String)b.getId());
        Assert.assertEquals((String)a.getDescription(), (String)b.getDescription());
        Assert.assertEquals((String)a.getName(), (String)b.getName());
        Assert.assertEquals((String)a.getVolumeId(), (String)b.getVolumeId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dependsOnMethods={"testCreateVolume"})
    public void testAttachments() {
        if (this.volumeOption.isPresent()) {
            String server_id = null;
            try {
                final String serverId = server_id = this.createServerInZone(this.zone).getId();
                ImmutableSet attachments = ((VolumeApi)this.volumeOption.get()).listAttachmentsOnServer(serverId).toSet();
                Assert.assertNotNull((Object)attachments);
                final int before = attachments.size();
                VolumeAttachment testAttachment = ((VolumeApi)this.volumeOption.get()).attachVolumeToServerAsDevice(this.testVolume.getId(), serverId, "/dev/vdf");
                Assert.assertNotNull((Object)testAttachment.getId());
                Assert.assertEquals((String)testAttachment.getVolumeId(), (String)this.testVolume.getId());
                Assert.assertTrue((boolean)Predicates2.retry((Predicate)new Predicate<VolumeApi>(){

                    public boolean apply(VolumeApi volumeApi) {
                        return ((VolumeApi)VolumeApiLiveTest.this.volumeOption.get()).listAttachmentsOnServer(serverId).size() > before;
                    }
                }, (long)60000L).apply(this.volumeOption.get()));
                attachments = ((VolumeApi)this.volumeOption.get()).listAttachmentsOnServer(serverId).toSet();
                Assert.assertNotNull((Object)attachments);
                Assert.assertEquals((int)attachments.size(), (int)(before + 1));
                Assert.assertEquals((Object)((VolumeApi)this.volumeOption.get()).get(this.testVolume.getId()).getStatus(), (Object)Volume.Status.IN_USE);
                boolean foundIt = false;
                for (VolumeAttachment att : attachments) {
                    VolumeAttachment details = ((VolumeApi)this.volumeOption.get()).getAttachmentForVolumeOnServer(att.getVolumeId(), serverId);
                    Assert.assertNotNull((Object)details);
                    Assert.assertNotNull((Object)details.getId());
                    Assert.assertNotNull((Object)details.getServerId());
                    Assert.assertNotNull((Object)details.getVolumeId());
                    if (!Objects.equal((Object)details.getVolumeId(), (Object)this.testVolume.getId())) continue;
                    foundIt = true;
                    Assert.assertEquals((String)details.getDevice(), (String)"/dev/vdf");
                    Assert.assertEquals((String)details.getServerId(), (String)serverId);
                }
                Assert.assertTrue((boolean)foundIt, (String)"Failed to find the attachment we created in listAttachments() response");
                ((VolumeApi)this.volumeOption.get()).detachVolumeFromServer(this.testVolume.getId(), serverId);
                Assert.assertTrue((boolean)Predicates2.retry((Predicate)new Predicate<VolumeApi>(){

                    public boolean apply(VolumeApi volumeApi) {
                        return ((VolumeApi)VolumeApiLiveTest.this.volumeOption.get()).listAttachmentsOnServer(serverId).size() == before;
                    }
                }, (long)60000L).apply(this.volumeOption.get()));
            }
            finally {
                if (server_id != null) {
                    ((NovaApi)this.api).getServerApiForZone(this.zone).delete(server_id);
                }
            }
        }
    }
}

