/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.extensions;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Map;
import org.jclouds.openstack.nova.v2_0.NovaApi;
import org.jclouds.openstack.nova.v2_0.domain.VolumeType;
import org.jclouds.openstack.nova.v2_0.extensions.VolumeTypeApi;
import org.jclouds.openstack.nova.v2_0.internal.BaseNovaApiLiveTest;
import org.jclouds.openstack.nova.v2_0.options.CreateVolumeTypeOptions;
import org.jclouds.util.Predicates2;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeGroups;
import org.testng.annotations.Test;

@Test(groups={"live"}, testName="VolumeTypeApiLiveTest", singleThreaded=true)
public class VolumeTypeApiLiveTest
extends BaseNovaApiLiveTest {
    private Optional<? extends VolumeTypeApi> volumeTypeOption;
    private String zone;
    private VolumeType testVolumeType;

    @Override
    @BeforeGroups(groups={"integration", "live"})
    public void setup() {
        super.setup();
        this.zone = (String)Iterables.getLast((Iterable)((NovaApi)this.api).getConfiguredZones(), (Object)"nova");
        this.volumeTypeOption = ((NovaApi)this.api).getVolumeTypeExtensionForZone(this.zone);
    }

    @AfterClass(groups={"integration", "live"})
    protected void tearDown() {
        if (this.volumeTypeOption.isPresent() && this.testVolumeType != null) {
            final String id = this.testVolumeType.getId();
            Assert.assertTrue((boolean)((VolumeTypeApi)this.volumeTypeOption.get()).delete(id));
            Assert.assertTrue((boolean)Predicates2.retry((Predicate)new Predicate<VolumeTypeApi>(){

                public boolean apply(VolumeTypeApi volumeApi) {
                    return volumeApi.get(id) == null;
                }
            }, (long)5000L).apply(this.volumeTypeOption.get()));
        }
        super.tearDown();
    }

    public void testCreateVolumeType() {
        if (this.volumeTypeOption.isPresent()) {
            this.testVolumeType = ((VolumeTypeApi)this.volumeTypeOption.get()).create("jclouds-test-1", new CreateVolumeTypeOptions[]{CreateVolumeTypeOptions.Builder.specs((Map)ImmutableMap.of((Object)"test", (Object)"value1"))});
            Assert.assertTrue((boolean)Predicates2.retry((Predicate)new Predicate<VolumeTypeApi>(){

                public boolean apply(VolumeTypeApi volumeTypeApi) {
                    return volumeTypeApi.get(VolumeTypeApiLiveTest.this.testVolumeType.getId()) != null;
                }
            }, (long)180000L).apply(this.volumeTypeOption.get()));
            Assert.assertEquals((String)((VolumeTypeApi)this.volumeTypeOption.get()).get(this.testVolumeType.getId()).getName(), (String)"jclouds-test-1");
            Assert.assertEquals((Map)((VolumeTypeApi)this.volumeTypeOption.get()).get(this.testVolumeType.getId()).getExtraSpecs(), (Map)ImmutableMap.of((Object)"test", (Object)"value1"));
        }
    }

    @Test(dependsOnMethods={"testCreateVolumeType"})
    public void testListVolumeTypes() {
        if (this.volumeTypeOption.isPresent()) {
            ImmutableSet volumeTypes = ((VolumeTypeApi)this.volumeTypeOption.get()).list().toSet();
            Assert.assertNotNull((Object)volumeTypes);
            boolean foundIt = false;
            for (VolumeType vt : volumeTypes) {
                VolumeType details = ((VolumeTypeApi)this.volumeTypeOption.get()).get(vt.getId());
                Assert.assertNotNull((Object)details);
                if (!Objects.equal((Object)details.getId(), (Object)this.testVolumeType.getId())) continue;
                foundIt = true;
            }
            Assert.assertTrue((boolean)foundIt, (String)"Failed to find the volume type we created in list() response");
        }
    }

    @Test(dependsOnMethods={"testCreateVolumeType"})
    public void testExtraSpecs() {
        if (this.volumeTypeOption.isPresent()) {
            Assert.assertEquals((Map)((VolumeTypeApi)this.volumeTypeOption.get()).getExtraSpecs(this.testVolumeType.getId()), (Map)ImmutableMap.of((Object)"test", (Object)"value1"));
            Assert.assertEquals((String)((VolumeTypeApi)this.volumeTypeOption.get()).getExtraSpec(this.testVolumeType.getId(), "test"), (String)"value1");
            Assert.assertTrue((boolean)((VolumeTypeApi)this.volumeTypeOption.get()).updateExtraSpecs(this.testVolumeType.getId(), (Map)ImmutableMap.of((Object)"test1", (Object)"wibble")));
        }
    }

    @Test(dependsOnMethods={"testCreateVolumeType"})
    public void testUpdateIndividualSpec() {
        if (this.volumeTypeOption.isPresent()) {
            Assert.assertTrue((boolean)((VolumeTypeApi)this.volumeTypeOption.get()).updateExtraSpec(this.testVolumeType.getId(), "test1", "freddy"));
            Assert.assertEquals((String)((VolumeTypeApi)this.volumeTypeOption.get()).getExtraSpec(this.testVolumeType.getId(), "test1"), (String)"freddy");
        }
    }
}

