/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.features;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.jclouds.openstack.nova.v2_0.NovaApi;
import org.jclouds.openstack.nova.v2_0.domain.Image;
import org.jclouds.openstack.nova.v2_0.features.ImageApi;
import org.jclouds.openstack.nova.v2_0.internal.BaseNovaApiLiveTest;
import org.jclouds.openstack.v2_0.domain.Resource;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"live"}, testName="ImageApiLiveTest")
public class ImageApiLiveTest
extends BaseNovaApiLiveTest {
    @Test(description="GET /v${apiVersion}/{tenantId}/images")
    public void testListImages() throws Exception {
        for (String zoneId : this.zones) {
            ImageApi imageApi = ((NovaApi)this.api).getImageApiForZone(zoneId);
            ImmutableSet response = imageApi.list().concat().toSet();
            Assert.assertNotNull((Object)response);
            Assert.assertFalse((boolean)response.isEmpty());
            for (Resource image : response) {
                Assert.assertNotNull((Object)image.getId());
                Assert.assertNotNull((Object)image.getName());
                Assert.assertNotNull((Object)image.getLinks());
            }
        }
    }

    @Test(description="GET /v${apiVersion}/{tenantId}/images/detail")
    public void testListImagesInDetail() throws Exception {
        for (String zoneId : ((NovaApi)this.api).getConfiguredZones()) {
            ImageApi imageApi = ((NovaApi)this.api).getImageApiForZone(zoneId);
            ImmutableSet response = imageApi.listInDetail().concat().toSet();
            Assert.assertNotNull((Object)response);
            Assert.assertFalse((boolean)response.isEmpty());
            for (Image image : response) {
                Assert.assertNotNull((Object)image.getId());
                Assert.assertNotNull((Object)image.getName());
                Assert.assertNotNull((Object)image.getLinks());
                Assert.assertNotNull((Object)image.getCreated());
                Assert.assertTrue((image.getProgress() >= 0 && image.getProgress() <= 100 ? 1 : 0) != 0);
                Assert.assertNotNull((Object)image.getStatus());
            }
        }
    }

    @Test(description="GET /v${apiVersion}/{tenantId}/images/{id}", dependsOnMethods={"testListImagesInDetail"})
    public void testGetImageById() throws Exception {
        for (String zoneId : ((NovaApi)this.api).getConfiguredZones()) {
            ImageApi imageApi = ((NovaApi)this.api).getImageApiForZone(zoneId);
            ImmutableSet response = imageApi.listInDetail().concat().toSet();
            for (Image image : response) {
                Image details = imageApi.get(image.getId());
                Assert.assertNotNull((Object)details);
                Assert.assertEquals((String)details.getId(), (String)image.getId());
                Assert.assertEquals((String)details.getName(), (String)image.getName());
                Assert.assertEquals((Set)details.getLinks(), (Set)image.getLinks());
                Assert.assertEquals((Object)details.getCreated(), (Object)image.getCreated());
                Assert.assertEquals((int)details.getMinDisk(), (int)image.getMinDisk());
                Assert.assertEquals((int)details.getMinRam(), (int)image.getMinRam());
                Assert.assertEquals((int)details.getProgress(), (int)image.getProgress());
                Assert.assertEquals((Object)details.getStatus(), (Object)image.getStatus());
                Assert.assertEquals((Object)details.getServer(), (Object)image.getServer());
                Assert.assertEquals((String)details.getTenantId(), (String)image.getTenantId());
                Assert.assertEquals((Object)details.getUpdated(), (Object)image.getUpdated());
                Assert.assertEquals((String)details.getUserId(), (String)image.getUserId());
            }
        }
    }
}

