/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.features;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.openstack.nova.v2_0.NovaApi;
import org.jclouds.openstack.nova.v2_0.internal.BaseNovaApiExpectTest;
import org.jclouds.openstack.nova.v2_0.options.CreateServerOptions;
import org.jclouds.openstack.nova.v2_0.parse.ParseCreatedServerTest;
import org.jclouds.openstack.nova.v2_0.parse.ParseMetadataListTest;
import org.jclouds.openstack.nova.v2_0.parse.ParseMetadataUpdateTest;
import org.jclouds.openstack.nova.v2_0.parse.ParseServerDiagnostics;
import org.jclouds.openstack.nova.v2_0.parse.ParseServerListTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="ServerAsyncApiTest")
public class ServerApiExpectTest
extends BaseNovaApiExpectTest {
    public void testListServersWhenResponseIs2xx() throws Exception {
        HttpRequest listServers = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/servers").addHeader("Accept", new String[]{"application/json"})).addHeader("X-Auth-Token", new String[]{this.authToken})).build();
        HttpResponse listServersResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/server_list.json"))).build();
        NovaApi apiWhenServersExist = (NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, listServers, listServersResponse);
        Assert.assertEquals((Set)apiWhenServersExist.getConfiguredZones(), (Set)ImmutableSet.of((Object)"az-1.region-a.geo-1", (Object)"az-2.region-a.geo-1", (Object)"az-3.region-a.geo-1"));
        Assert.assertEquals((String)apiWhenServersExist.getServerApiForZone("az-1.region-a.geo-1").list().concat().toString(), (String)new ParseServerListTest().expected().toString());
    }

    public void testListServersWhenReponseIs404IsEmpty() throws Exception {
        HttpRequest listServers = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/servers").addHeader("Accept", new String[]{"application/json"})).addHeader("X-Auth-Token", new String[]{this.authToken})).build();
        HttpResponse listServersResponse = HttpResponse.builder().statusCode(404).build();
        NovaApi apiWhenNoServersExist = (NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, listServers, listServersResponse);
        Assert.assertTrue((boolean)apiWhenNoServersExist.getServerApiForZone("az-1.region-a.geo-1").list().concat().isEmpty());
    }

    public void testCreateServerWhenResponseIs202() throws Exception {
        HttpRequest createServer = ((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/servers").addHeader("Accept", new String[]{"application/json"})).addHeader("X-Auth-Token", new String[]{this.authToken})).payload(ServerApiExpectTest.payloadFromStringWithContentType((String)"{\"server\":{\"name\":\"test-e92\",\"imageRef\":\"1241\",\"flavorRef\":\"100\"}}", (String)"application/json"))).build();
        HttpResponse createServerResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(202).message("HTTP/1.1 202 Accepted").payload(this.payloadFromResourceWithContentType("/new_server.json", "application/json; charset=UTF-8"))).build();
        NovaApi apiWithNewServer = (NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, createServer, createServerResponse);
        Assert.assertEquals((String)apiWithNewServer.getServerApiForZone("az-1.region-a.geo-1").create("test-e92", "1241", "100", new CreateServerOptions[0]).toString(), (String)new ParseCreatedServerTest().expected().toString());
    }

    public void testCreateServerWithSecurityGroupsWhenResponseIs202() throws Exception {
        HttpRequest createServer = ((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/servers").addHeader("Accept", new String[]{"application/json"})).addHeader("X-Auth-Token", new String[]{this.authToken})).payload(ServerApiExpectTest.payloadFromStringWithContentType((String)"{\"server\":{\"name\":\"test-e92\",\"imageRef\":\"1241\",\"flavorRef\":\"100\",\"security_groups\":[{\"name\":\"group1\"},{\"name\":\"group2\"}]}}", (String)"application/json"))).build();
        HttpResponse createServerResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(202).message("HTTP/1.1 202 Accepted").payload(this.payloadFromResourceWithContentType("/new_server.json", "application/json; charset=UTF-8"))).build();
        NovaApi apiWithNewServer = (NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, createServer, createServerResponse);
        Assert.assertEquals((String)apiWithNewServer.getServerApiForZone("az-1.region-a.geo-1").create("test-e92", "1241", "100", new CreateServerOptions[]{new CreateServerOptions().securityGroupNames(new String[]{"group1", "group2"})}).toString(), (String)new ParseCreatedServerTest().expected().toString());
    }

    public void testCreateServerWithNetworksWhenResponseIs202() throws Exception {
        HttpRequest createServer = ((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/servers").addHeader("Accept", new String[]{"application/json"})).addHeader("X-Auth-Token", new String[]{this.authToken})).payload(ServerApiExpectTest.payloadFromStringWithContentType((String)"{\"server\":{\"name\":\"test-e92\",\"imageRef\":\"1241\",\"flavorRef\":\"100\",\"networks\":[{\"uuid\":\"b3856ac0-f481-11e2-b778-0800200c9a66\"},{\"uuid\":\"bf0f0f90-f481-11e2-b778-0800200c9a66\"}]}}", (String)"application/json"))).build();
        HttpResponse createServerResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(202).message("HTTP/1.1 202 Accepted").payload(this.payloadFromResourceWithContentType("/new_server.json", "application/json; charset=UTF-8"))).build();
        NovaApi apiWithNewServer = (NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, createServer, createServerResponse);
        Assert.assertEquals((String)apiWithNewServer.getServerApiForZone("az-1.region-a.geo-1").create("test-e92", "1241", "100", new CreateServerOptions[]{new CreateServerOptions().networks(new String[]{"b3856ac0-f481-11e2-b778-0800200c9a66", "bf0f0f90-f481-11e2-b778-0800200c9a66"})}).toString(), (String)new ParseCreatedServerTest().expected().toString());
    }

    public void testCreateServerWithDiskConfigAuto() throws Exception {
        HttpRequest createServer = ((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/servers").addHeader("Accept", new String[]{"application/json"})).addHeader("X-Auth-Token", new String[]{this.authToken})).payload(ServerApiExpectTest.payloadFromStringWithContentType((String)"{\"server\":{\"name\":\"test-e92\",\"imageRef\":\"1241\",\"flavorRef\":\"100\",\"OS-DCF:diskConfig\":\"AUTO\"}}", (String)"application/json"))).build();
        HttpResponse createServerResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(202).message("HTTP/1.1 202 Accepted").payload(this.payloadFromResourceWithContentType("/new_server_disk_config_auto.json", "application/json; charset=UTF-8"))).build();
        NovaApi apiWithNewServer = (NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, createServer, createServerResponse);
        Assert.assertEquals((String)apiWithNewServer.getServerApiForZone("az-1.region-a.geo-1").create("test-e92", "1241", "100", new CreateServerOptions[]{new CreateServerOptions().diskConfig("AUTO")}).toString(), (String)new ParseCreatedServerTest().expectedWithDiskConfig("AUTO").toString());
    }

    public void testCreateServerWithDiskConfigManual() throws Exception {
        HttpRequest createServer = ((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/servers").addHeader("Accept", new String[]{"application/json"})).addHeader("X-Auth-Token", new String[]{this.authToken})).payload(ServerApiExpectTest.payloadFromStringWithContentType((String)"{\"server\":{\"name\":\"test-e92\",\"imageRef\":\"1241\",\"flavorRef\":\"100\",\"OS-DCF:diskConfig\":\"MANUAL\"}}", (String)"application/json"))).build();
        HttpResponse createServerResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(202).message("HTTP/1.1 202 Accepted").payload(this.payloadFromResourceWithContentType("/new_server_disk_config_manual.json", "application/json; charset=UTF-8"))).build();
        NovaApi apiWithNewServer = (NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, createServer, createServerResponse);
        Assert.assertEquals((String)apiWithNewServer.getServerApiForZone("az-1.region-a.geo-1").create("test-e92", "1241", "100", new CreateServerOptions[]{new CreateServerOptions().diskConfig("MANUAL")}).toString(), (String)new ParseCreatedServerTest().expectedWithDiskConfig("MANUAL").toString());
    }

    public void testCreateImageWhenResponseIs2xx() throws Exception {
        String serverId = "123";
        String imageId = "456";
        String imageName = "foo";
        HttpRequest createImage = ((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/servers/" + serverId + "/action").addHeader("Accept", new String[]{"application/json"})).addHeader("X-Auth-Token", new String[]{this.authToken})).payload(ServerApiExpectTest.payloadFromStringWithContentType((String)("{\"createImage\":{\"name\":\"" + imageName + "\", \"metadata\": {}}}"), (String)"application/json"))).build();
        HttpResponse createImageResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).headers((Multimap)ImmutableMultimap.builder().put((Object)"Location", (Object)("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/images/" + imageId)).build())).build();
        NovaApi apiWhenServerExists = (NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, createImage, createImageResponse);
        Assert.assertEquals((String)apiWhenServerExists.getServerApiForZone("az-1.region-a.geo-1").createImageFromServer(imageName, serverId), (String)imageId);
    }

    public void testCreateImageWhenResponseIs404IsEmpty() throws Exception {
        String serverId = "123";
        String imageName = "foo";
        HttpRequest createImage = ((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/servers/" + serverId + "/action").addHeader("Accept", new String[]{"application/json"})).addHeader("X-Auth-Token", new String[]{this.authToken})).payload(ServerApiExpectTest.payloadFromStringWithContentType((String)("{\"createImage\":{\"name\":\"" + imageName + "\", \"metadata\": {}}}"), (String)"application/json"))).build();
        HttpResponse createImageResponse = HttpResponse.builder().statusCode(404).build();
        NovaApi apiWhenServerDoesNotExist = (NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, createImage, createImageResponse);
        try {
            apiWhenServerDoesNotExist.getServerApiForZone("az-1.region-a.geo-1").createImageFromServer(imageName, serverId);
            Assert.fail((String)"Expected an exception.");
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void testStopServerWhenResponseIs2xx() throws Exception {
        String serverId = "123";
        HttpRequest stopServer = ((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/servers/" + serverId + "/action").addHeader("Accept", new String[]{"*/*"})).addHeader("X-Auth-Token", new String[]{this.authToken})).payload(ServerApiExpectTest.payloadFromStringWithContentType((String)"{\"os-stop\":null}", (String)"application/json"))).build();
        HttpResponse stopServerResponse = HttpResponse.builder().statusCode(202).build();
        NovaApi apiWhenServerExists = (NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, stopServer, stopServerResponse);
        apiWhenServerExists.getServerApiForZone("az-1.region-a.geo-1").stop(serverId);
    }

    public void testStopServerWhenResponseIs404() throws Exception {
        String serverId = "123";
        HttpRequest stopServer = ((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/servers/" + serverId + "/action").addHeader("Accept", new String[]{"*/*"})).addHeader("X-Auth-Token", new String[]{this.authToken})).payload(ServerApiExpectTest.payloadFromStringWithContentType((String)"{\"os-stop\":null}", (String)"application/json"))).build();
        HttpResponse stopServerResponse = HttpResponse.builder().statusCode(404).build();
        NovaApi apiWhenServerExists = (NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, stopServer, stopServerResponse);
        try {
            apiWhenServerExists.getServerApiForZone("az-1.region-a.geo-1").stop(serverId);
            Assert.fail((String)"Expected an exception.");
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void testStartServerWhenResponseIs2xx() throws Exception {
        String serverId = "123";
        HttpRequest startServer = ((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/servers/" + serverId + "/action").addHeader("Accept", new String[]{"*/*"})).addHeader("X-Auth-Token", new String[]{this.authToken})).payload(ServerApiExpectTest.payloadFromStringWithContentType((String)"{\"os-start\":null}", (String)"application/json"))).build();
        HttpResponse startServerResponse = HttpResponse.builder().statusCode(202).build();
        NovaApi apiWhenServerExists = (NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, startServer, startServerResponse);
        apiWhenServerExists.getServerApiForZone("az-1.region-a.geo-1").start(serverId);
    }

    public void testStartServerWhenResponseIs404() throws Exception {
        String serverId = "123";
        HttpRequest startServer = ((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/servers/" + serverId + "/action").addHeader("Accept", new String[]{"*/*"})).addHeader("X-Auth-Token", new String[]{this.authToken})).payload(ServerApiExpectTest.payloadFromStringWithContentType((String)"{\"os-startp\":null}", (String)"application/json"))).build();
        HttpResponse startServerResponse = HttpResponse.builder().statusCode(404).build();
        NovaApi apiWhenServerExists = (NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, startServer, startServerResponse);
        try {
            apiWhenServerExists.getServerApiForZone("az-1.region-a.geo-1").start(serverId);
            Assert.fail((String)"Expected an exception.");
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void testListMetadataWhenResponseIs2xx() throws Exception {
        String serverId = "123";
        HttpRequest getMetadata = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/servers/" + serverId + "/metadata").addHeader("Accept", new String[]{"application/json"})).addHeader("X-Auth-Token", new String[]{this.authToken})).build();
        HttpResponse getMetadataResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/metadata_list.json"))).build();
        NovaApi apiWhenServerExists = (NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, getMetadata, getMetadataResponse);
        Assert.assertEquals((String)apiWhenServerExists.getServerApiForZone("az-1.region-a.geo-1").getMetadata(serverId).toString(), (String)new ParseMetadataListTest().expected().toString());
    }

    public void testListMetadataWhenResponseIs404() throws Exception {
        String serverId = "123";
        HttpRequest getMetadata = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/servers/" + serverId + "/metadata").addHeader("Accept", new String[]{"*/*"})).addHeader("X-Auth-Token", new String[]{this.authToken})).build();
        HttpResponse getMetadataResponse = HttpResponse.builder().statusCode(404).build();
        NovaApi apiWhenServerExists = (NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, getMetadata, getMetadataResponse);
        try {
            apiWhenServerExists.getServerApiForZone("az-1.region-a.geo-1").getMetadata(serverId);
            Assert.fail((String)"Expected an exception.");
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void testSetMetadataWhenResponseIs2xx() throws Exception {
        String serverId = "123";
        ImmutableMap metadata = new ImmutableMap.Builder().put((Object)"Server Label", (Object)"Web Head 1").put((Object)"Image Version", (Object)"2.1").build();
        HttpRequest setMetadata = ((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("PUT").endpoint("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/servers/" + serverId + "/metadata").addHeader("Accept", new String[]{"application/json"})).addHeader("X-Auth-Token", new String[]{this.authToken})).payload(ServerApiExpectTest.payloadFromStringWithContentType((String)"{\"metadata\":{\"Server Label\":\"Web Head 1\",\"Image Version\":\"2.1\"}}", (String)"application/json"))).build();
        HttpResponse setMetadataResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/metadata_list.json"))).build();
        NovaApi apiWhenServerExists = (NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, setMetadata, setMetadataResponse);
        Assert.assertEquals((String)apiWhenServerExists.getServerApiForZone("az-1.region-a.geo-1").setMetadata(serverId, (Map)metadata).toString(), (String)new ParseMetadataListTest().expected().toString());
    }

    public void testSetMetadataWhenResponseIs404() throws Exception {
        String serverId = "123";
        ImmutableMap metadata = new ImmutableMap.Builder().put((Object)"Server Label", (Object)"Web Head 1").put((Object)"Image Version", (Object)"2.1").build();
        HttpRequest setMetadata = ((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("PUT").endpoint("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/servers/" + serverId + "/metadata").addHeader("Accept", new String[]{"*/*"})).addHeader("X-Auth-Token", new String[]{this.authToken})).payload(ServerApiExpectTest.payloadFromStringWithContentType((String)"{\"metadata\":{\"Server Label\":\"Web Head 1\",\"Image Version\":\"2.1\"}}", (String)"application/json"))).build();
        HttpResponse setMetadataResponse = HttpResponse.builder().statusCode(404).build();
        NovaApi apiWhenServerExists = (NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, setMetadata, setMetadataResponse);
        try {
            apiWhenServerExists.getServerApiForZone("az-1.region-a.geo-1").setMetadata(serverId, (Map)metadata);
            Assert.fail((String)"Expected an exception.");
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void testUpdateMetadataWhenResponseIs2xx() throws Exception {
        String serverId = "123";
        ImmutableMap metadata = new ImmutableMap.Builder().put((Object)"Server Label", (Object)"Web Head 2").put((Object)"Server Description", (Object)"Simple Server").build();
        HttpRequest setMetadata = ((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/servers/" + serverId + "/metadata").addHeader("Accept", new String[]{"application/json"})).addHeader("X-Auth-Token", new String[]{this.authToken})).payload(ServerApiExpectTest.payloadFromStringWithContentType((String)"{\"metadata\":{\"Server Label\":\"Web Head 2\",\"Server Description\":\"Simple Server\"}}", (String)"application/json"))).build();
        HttpResponse setMetadataResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/metadata_updated.json"))).build();
        NovaApi apiWhenServerExists = (NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, setMetadata, setMetadataResponse);
        Assert.assertEquals((String)apiWhenServerExists.getServerApiForZone("az-1.region-a.geo-1").updateMetadata(serverId, (Map)metadata).toString(), (String)new ParseMetadataUpdateTest().expected().toString());
    }

    public void testUpdateMetadataWhenResponseIs404() throws Exception {
        String serverId = "123";
        ImmutableMap metadata = new ImmutableMap.Builder().put((Object)"Server Label", (Object)"Web Head 2").put((Object)"Server Description", (Object)"Simple Server").build();
        HttpRequest setMetadata = ((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/servers/" + serverId + "/metadata").addHeader("Accept", new String[]{"application/json"})).addHeader("X-Auth-Token", new String[]{this.authToken})).payload(ServerApiExpectTest.payloadFromStringWithContentType((String)"{\"metadata\":{\"Server Label\":\"Web Head 2\",\"Server Description\":\"Simple Server\"}}", (String)"application/json"))).build();
        HttpResponse setMetadataResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(404).payload(this.payloadFromResource("/metadata_updated.json"))).build();
        NovaApi apiWhenServerExists = (NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, setMetadata, setMetadataResponse);
        try {
            apiWhenServerExists.getServerApiForZone("az-1.region-a.geo-1").setMetadata(serverId, (Map)metadata);
            Assert.fail((String)"Expected an exception.");
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void testGetMetadataItemWhenResponseIs2xx() throws Exception {
        String serverId = "123";
        String key = "Server Label";
        HttpRequest getMetadata = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/servers/" + serverId + "/metadata/" + "Server%20Label").addHeader("Accept", new String[]{"application/json"})).addHeader("X-Auth-Token", new String[]{this.authToken})).build();
        HttpResponse getMetadataResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/metadata_item.json"))).build();
        NovaApi apiWhenServerExists = (NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, getMetadata, getMetadataResponse);
        Assert.assertEquals((String)apiWhenServerExists.getServerApiForZone("az-1.region-a.geo-1").getMetadata(serverId, key).toString(), (String)"Web Head 1");
    }

    public void testGetMetadataItemWhenResponseIs404() throws Exception {
        String serverId = "123";
        ImmutableMap metadata = new ImmutableMap.Builder().put((Object)"Server Label", (Object)"Web Head 1").build();
        HttpRequest setMetadata = ((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/servers/" + serverId + "/metadata").addHeader("Accept", new String[]{"application/json"})).addHeader("X-Auth-Token", new String[]{this.authToken})).payload(ServerApiExpectTest.payloadFromStringWithContentType((String)"{\"metadata\":{\"Server Label\":\"Web Head 2\",\"Server Description\":\"Simple Server\"}}", (String)"application/json"))).build();
        HttpResponse setMetadataResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(404).payload(this.payloadFromResource("/metadata_updated.json"))).build();
        NovaApi apiWhenServerExists = (NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, setMetadata, setMetadataResponse);
        try {
            apiWhenServerExists.getServerApiForZone("az-1.region-a.geo-1").setMetadata(serverId, (Map)metadata);
            Assert.fail((String)"Expected an exception.");
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void testSetMetadataItemWhenResponseIs2xx() throws Exception {
        String serverId = "123";
        ImmutableMap metadata = new ImmutableMap.Builder().put((Object)"Server Label", (Object)"Web Head 2").put((Object)"Server Description", (Object)"Simple Server").build();
        HttpRequest setMetadata = ((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/servers/" + serverId + "/metadata").addHeader("Accept", new String[]{"application/json"})).addHeader("X-Auth-Token", new String[]{this.authToken})).payload(ServerApiExpectTest.payloadFromStringWithContentType((String)"{\"metadata\":{\"Server Label\":\"Web Head 2\",\"Server Description\":\"Simple Server\"}}", (String)"application/json"))).build();
        HttpResponse setMetadataResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/metadata_updated.json"))).build();
        NovaApi apiWhenServerExists = (NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, setMetadata, setMetadataResponse);
        Assert.assertEquals((String)apiWhenServerExists.getServerApiForZone("az-1.region-a.geo-1").updateMetadata(serverId, (Map)metadata).toString(), (String)new ParseMetadataUpdateTest().expected().toString());
    }

    public void testSetMetadataItemWhenResponseIs404() throws Exception {
        String serverId = "123";
        ImmutableMap metadata = new ImmutableMap.Builder().put((Object)"Server Label", (Object)"Web Head 2").put((Object)"Server Description", (Object)"Simple Server").build();
        HttpRequest setMetadata = ((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/servers/" + serverId + "/metadata").addHeader("Accept", new String[]{"application/json"})).addHeader("X-Auth-Token", new String[]{this.authToken})).payload(ServerApiExpectTest.payloadFromStringWithContentType((String)"{\"metadata\":{\"Server Label\":\"Web Head 2\",\"Server Description\":\"Simple Server\"}}", (String)"application/json"))).build();
        HttpResponse setMetadataResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(404).payload(this.payloadFromResource("/metadata_updated.json"))).build();
        NovaApi apiWhenServerExists = (NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, setMetadata, setMetadataResponse);
        try {
            apiWhenServerExists.getServerApiForZone("az-1.region-a.geo-1").setMetadata(serverId, (Map)metadata);
            Assert.fail((String)"Expected an exception.");
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void testDeleteMetadataItemWhenResponseIs2xx() throws Exception {
        String serverId = "123";
        String key = "Server%20Label";
        HttpRequest updateMetadata = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("DELETE").endpoint("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/servers/" + serverId + "/metadata/" + key).addHeader("Accept", new String[]{"*/*"})).addHeader("X-Auth-Token", new String[]{this.authToken})).build();
        HttpResponse updateMetadataResponse = HttpResponse.builder().statusCode(204).build();
        NovaApi apiWhenServerExists = (NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, updateMetadata, updateMetadataResponse);
        apiWhenServerExists.getServerApiForZone("az-1.region-a.geo-1").deleteMetadata(serverId, key);
    }

    public void testDeleteMetadataItemWhenResponseIs404() throws Exception {
        String serverId = "123";
        String key = "Server%20Label";
        HttpRequest deleteMetadata = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("DELETE").endpoint("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/servers/" + serverId + "/metadata/" + key).addHeader("Accept", new String[]{"*/*"})).addHeader("X-Auth-Token", new String[]{this.authToken})).build();
        HttpResponse deleteMetadataResponse = HttpResponse.builder().statusCode(404).build();
        NovaApi apiWhenServerExists = (NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, deleteMetadata, deleteMetadataResponse);
        apiWhenServerExists.getServerApiForZone("az-1.region-a.geo-1").deleteMetadata(serverId, key);
    }

    public void testGetDiagnosticsWhenResponseIs200() throws Exception {
        String serverId = "123";
        HttpRequest getDiagnostics = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("GET").addHeader("Accept", new String[]{"application/json"})).endpoint("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/servers/" + serverId + "/diagnostics").addHeader("X-Auth-Token", new String[]{this.authToken})).build();
        HttpResponse serverDiagnosticsResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(202).message("HTTP/1.1 202 Accepted").payload(this.payloadFromResourceWithContentType("/server_diagnostics.json", "application/json; charset=UTF-8"))).build();
        NovaApi apiWithNewServer = (NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, getDiagnostics, serverDiagnosticsResponse);
        Assert.assertEquals((Object)apiWithNewServer.getServerApiForZone("az-1.region-a.geo-1").getDiagnostics(serverId), new ParseServerDiagnostics().expected());
    }

    public void testGetDiagnosticsWhenResponseIs403Or404Or500() throws Exception {
        String serverId = "123";
        HttpRequest getDiagnostics = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("GET").addHeader("Accept", new String[]{"application/json"})).endpoint("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/servers/" + serverId + "/diagnostics").addHeader("X-Auth-Token", new String[]{this.authToken})).build();
        Iterator i$ = ImmutableSet.of((Object)403, (Object)404, (Object)500).iterator();
        while (i$.hasNext()) {
            int statusCode = (Integer)i$.next();
            Assert.assertTrue((!((NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, getDiagnostics, HttpResponse.builder().statusCode(statusCode).build())).getServerApiForZone("az-1.region-a.geo-1").getDiagnostics(serverId).isPresent() ? 1 : 0) != 0);
        }
    }
}

