/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.domain.zonescoped;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;

public class ZoneAndId {
    protected final String zoneId;
    protected final String id;

    public static ZoneAndId fromSlashEncoded(String id) {
        Iterable parts = Splitter.on((char)'/').split((CharSequence)Preconditions.checkNotNull((Object)id, (Object)"id"));
        Preconditions.checkArgument((Iterables.size((Iterable)parts) == 2 ? 1 : 0) != 0, (Object)"id must be in format zoneId/id");
        return new ZoneAndId((String)Iterables.get((Iterable)parts, (int)0), (String)Iterables.get((Iterable)parts, (int)1));
    }

    public static ZoneAndId fromZoneAndId(String zoneId, String id) {
        return new ZoneAndId(zoneId, id);
    }

    private static String slashEncodeZoneAndId(String zoneId, String id) {
        return (String)Preconditions.checkNotNull((Object)zoneId, (Object)"zoneId") + "/" + (String)Preconditions.checkNotNull((Object)id, (Object)"id");
    }

    public String slashEncode() {
        return ZoneAndId.slashEncodeZoneAndId(this.zoneId, this.id);
    }

    protected ZoneAndId(String zoneId, String id) {
        this.zoneId = (String)Preconditions.checkNotNull((Object)zoneId, (Object)"zoneId");
        this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"id");
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.zoneId, this.id});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ZoneAndId other = (ZoneAndId)obj;
        return Objects.equal((Object)this.zoneId, (Object)other.zoneId) && Objects.equal((Object)this.id, (Object)other.id);
    }

    public String getZone() {
        return this.zoneId;
    }

    public String getId() {
        return this.id;
    }

    public String toString() {
        return "[zoneId=" + this.zoneId + ", id=" + this.id + "]";
    }
}

