/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.extensions;

import com.google.common.annotations.Beta;
import com.google.common.collect.FluentIterable;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Map;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.jclouds.Fallbacks;
import org.jclouds.openstack.keystone.v2_0.filters.AuthenticateRequest;
import org.jclouds.openstack.nova.v2_0.domain.HostAggregate;
import org.jclouds.openstack.v2_0.services.Extension;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.SelectJson;
import org.jclouds.rest.annotations.WrapWith;

@Extension(of="compute", namespace="http://docs.openstack.org/ext/aggregates/api/v1.1")
@RequestFilters(value={AuthenticateRequest.class})
@Path(value="/os-aggregates")
@Beta
public interface HostAggregateAsyncApi {
    @Named(value="hostaggregate:list")
    @GET
    @SelectJson(value={"aggregates"})
    @Consumes(value={"application/json"})
    @Fallback(value=Fallbacks.EmptyFluentIterableOnNotFoundOr404.class)
    public ListenableFuture<? extends FluentIterable<? extends HostAggregate>> list();

    @Named(value="hostaggregate:get")
    @GET
    @Path(value="/{id}")
    @SelectJson(value={"aggregate"})
    @Consumes(value={"application/json"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public ListenableFuture<? extends HostAggregate> get(@PathParam(value="id") String var1);

    @Named(value="hostaggregate:create")
    @POST
    @SelectJson(value={"aggregate"})
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @WrapWith(value="aggregate")
    public ListenableFuture<? extends HostAggregate> createInAvailabilityZone(@PayloadParam(value="name") String var1, @PayloadParam(value="availability_zone") String var2);

    @Named(value="hostaggregate:update")
    @POST
    @Path(value="/{id}")
    @SelectJson(value={"aggregate"})
    @Consumes(value={"application/json"})
    @WrapWith(value="aggregate")
    public ListenableFuture<? extends HostAggregate> updateName(@PathParam(value="id") String var1, @PayloadParam(value="name") String var2);

    @Named(value="hostaggregate:update")
    @POST
    @Path(value="/{id}")
    @SelectJson(value={"aggregate"})
    @Consumes(value={"application/json"})
    @WrapWith(value="aggregate")
    public ListenableFuture<? extends HostAggregate> updateAvailabilityZone(@PathParam(value="id") String var1, @PayloadParam(value="availability_zone") String var2);

    @Named(value="hostaggregate:delete")
    @DELETE
    @Path(value="/{id}")
    @Consumes(value={"application/json"})
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    public ListenableFuture<Boolean> delete(@PathParam(value="id") String var1);

    @Named(value="hostaggregate:addhost")
    @POST
    @Path(value="/{id}/action")
    @SelectJson(value={"aggregate"})
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @WrapWith(value="add_host")
    public ListenableFuture<? extends HostAggregate> addHost(@PathParam(value="id") String var1, @PayloadParam(value="host") String var2);

    @Named(value="hostaggregate:removehost")
    @POST
    @Path(value="/{id}/action")
    @SelectJson(value={"aggregate"})
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @WrapWith(value="remove_host")
    public ListenableFuture<? extends HostAggregate> removeHost(@PathParam(value="id") String var1, @PayloadParam(value="host") String var2);

    @Named(value="hostaggregate:setmetadata")
    @POST
    @Path(value="/{id}/action")
    @SelectJson(value={"aggregate"})
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @WrapWith(value="set_metadata")
    public ListenableFuture<? extends HostAggregate> setMetadata(@PathParam(value="id") String var1, @PayloadParam(value="metadata") Map<String, String> var2);
}

