/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.extensions;

import com.google.common.annotations.Beta;
import com.google.common.util.concurrent.ListenableFuture;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.jclouds.Fallbacks;
import org.jclouds.openstack.keystone.v2_0.filters.AuthenticateRequest;
import org.jclouds.openstack.nova.v2_0.domain.QuotaClass;
import org.jclouds.openstack.v2_0.services.Extension;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.MapBinder;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.SelectJson;
import org.jclouds.rest.binders.BindToJsonPayload;

@Extension(of="compute", namespace="http://docs.openstack.org/ext/quota-classes-sets/api/v1.1")
@RequestFilters(value={AuthenticateRequest.class})
@Path(value="/os-quota-class-sets")
@Beta
public interface QuotaClassAsyncApi {
    @Named(value="quotaclass:get")
    @GET
    @SelectJson(value={"quota_class_set"})
    @Consumes(value={"application/json"})
    @Path(value="/{id}")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public ListenableFuture<? extends QuotaClass> get(@PathParam(value="id") String var1);

    @Named(value="quotaclass:update")
    @PUT
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    @MapBinder(value=BindToJsonPayload.class)
    public ListenableFuture<Boolean> update(@PathParam(value="id") String var1, @PayloadParam(value="quota_class_set") QuotaClass var2);
}

