/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.extensions;

import com.google.common.annotations.Beta;
import com.google.common.collect.FluentIterable;
import com.google.common.util.concurrent.ListenableFuture;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.jclouds.Fallbacks;
import org.jclouds.openstack.keystone.v2_0.filters.AuthenticateRequest;
import org.jclouds.openstack.nova.v2_0.domain.Volume;
import org.jclouds.openstack.nova.v2_0.domain.VolumeAttachment;
import org.jclouds.openstack.nova.v2_0.domain.VolumeSnapshot;
import org.jclouds.openstack.nova.v2_0.options.CreateVolumeOptions;
import org.jclouds.openstack.nova.v2_0.options.CreateVolumeSnapshotOptions;
import org.jclouds.openstack.v2_0.services.Extension;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.MapBinder;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.SelectJson;
import org.jclouds.rest.annotations.WrapWith;

@Extension(of="compute", namespace="http://docs.openstack.org/ext/volumes/api/v1.1")
@RequestFilters(value={AuthenticateRequest.class})
@Beta
public interface VolumeAsyncApi {
    @Named(value="volume:list")
    @GET
    @Path(value="/os-volumes")
    @SelectJson(value={"volumes"})
    @Consumes(value={"application/json"})
    @Fallback(value=Fallbacks.EmptyFluentIterableOnNotFoundOr404.class)
    public ListenableFuture<? extends FluentIterable<? extends Volume>> list();

    @Named(value="volume:list")
    @GET
    @Path(value="/os-volumes/detail")
    @SelectJson(value={"volumes"})
    @Consumes(value={"application/json"})
    @Fallback(value=Fallbacks.EmptyFluentIterableOnNotFoundOr404.class)
    public ListenableFuture<? extends FluentIterable<? extends Volume>> listInDetail();

    @Named(value="volume:get")
    @GET
    @Path(value="/os-volumes/{id}")
    @SelectJson(value={"volume"})
    @Consumes(value={"application/json"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public ListenableFuture<? extends Volume> get(@PathParam(value="id") String var1);

    @Named(value="volume:create")
    @POST
    @Path(value="/os-volumes")
    @SelectJson(value={"volume"})
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @MapBinder(value=CreateVolumeOptions.class)
    public ListenableFuture<? extends Volume> create(@PayloadParam(value="size") int var1, CreateVolumeOptions ... var2);

    @Named(value="volume:delete")
    @DELETE
    @Path(value="/os-volumes/{id}")
    @Consumes(value={"application/json"})
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    public ListenableFuture<Boolean> delete(@PathParam(value="id") String var1);

    @Named(value="volume:listattachments")
    @GET
    @Path(value="/servers/{server_id}/os-volume_attachments")
    @SelectJson(value={"volumeAttachments"})
    @Consumes(value={"application/json"})
    @Fallback(value=Fallbacks.EmptyFluentIterableOnNotFoundOr404.class)
    @Deprecated
    public ListenableFuture<? extends FluentIterable<? extends VolumeAttachment>> listAttachmentsOnServer(@PathParam(value="server_id") String var1);

    @Named(value="volume:getattachments")
    @GET
    @Path(value="/servers/{server_id}/os-volume_attachments/{id}")
    @SelectJson(value={"volumeAttachment"})
    @Consumes(value={"application/json"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Deprecated
    public ListenableFuture<? extends VolumeAttachment> getAttachmentForVolumeOnServer(@PathParam(value="id") String var1, @PathParam(value="server_id") String var2);

    @Named(value="volume:attach")
    @POST
    @Path(value="/servers/{server_id}/os-volume_attachments")
    @SelectJson(value={"volumeAttachment"})
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @WrapWith(value="volumeAttachment")
    @Deprecated
    public ListenableFuture<? extends VolumeAttachment> attachVolumeToServerAsDevice(@PayloadParam(value="volumeId") String var1, @PathParam(value="server_id") String var2, @PayloadParam(value="device") String var3);

    @Named(value="volume:detach")
    @DELETE
    @Path(value="/servers/{server_id}/os-volume_attachments/{id}")
    @Consumes(value={"application/json"})
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    @Deprecated
    public ListenableFuture<Boolean> detachVolumeFromServer(@PathParam(value="id") String var1, @PathParam(value="server_id") String var2);

    @Named(value="volume:listsnapshots")
    @GET
    @Path(value="/os-snapshots")
    @SelectJson(value={"snapshots"})
    @Consumes(value={"application/json"})
    @Fallback(value=Fallbacks.EmptyFluentIterableOnNotFoundOr404.class)
    public ListenableFuture<? extends FluentIterable<? extends VolumeSnapshot>> listSnapshots();

    @Named(value="volume:listsnapshot")
    @GET
    @Path(value="/os-snapshots/detail")
    @SelectJson(value={"snapshots"})
    @Consumes(value={"application/json"})
    @Fallback(value=Fallbacks.EmptyFluentIterableOnNotFoundOr404.class)
    public ListenableFuture<? extends FluentIterable<? extends VolumeSnapshot>> listSnapshotsInDetail();

    @Named(value="volume:getsnapshot")
    @GET
    @Path(value="/os-snapshots/{id}")
    @SelectJson(value={"snapshot"})
    @Consumes(value={"application/json"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public ListenableFuture<? extends VolumeSnapshot> getSnapshot(@PathParam(value="id") String var1);

    @Named(value="volume:createsnapshot")
    @POST
    @Path(value="/os-snapshots")
    @SelectJson(value={"snapshot"})
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @MapBinder(value=CreateVolumeSnapshotOptions.class)
    public ListenableFuture<? extends VolumeSnapshot> createSnapshot(@PayloadParam(value="volume_id") String var1, CreateVolumeSnapshotOptions ... var2);

    @Named(value="volume:deletesnapshot")
    @DELETE
    @Path(value="/os-snapshots/{id}")
    @Consumes(value={"application/json"})
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    public ListenableFuture<Boolean> deleteSnapshot(@PathParam(value="id") String var1);
}

