/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.features;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.Map;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.jclouds.Fallbacks;
import org.jclouds.collect.PagedIterable;
import org.jclouds.openstack.keystone.v2_0.KeystoneFallbacks;
import org.jclouds.openstack.keystone.v2_0.domain.PaginatedCollection;
import org.jclouds.openstack.keystone.v2_0.filters.AuthenticateRequest;
import org.jclouds.openstack.nova.v2_0.binders.BindMetadataToJsonPayload;
import org.jclouds.openstack.nova.v2_0.domain.Image;
import org.jclouds.openstack.nova.v2_0.functions.internal.OnlyMetadataValueOrNull;
import org.jclouds.openstack.nova.v2_0.functions.internal.ParseImageDetails;
import org.jclouds.openstack.nova.v2_0.functions.internal.ParseImages;
import org.jclouds.openstack.v2_0.domain.Resource;
import org.jclouds.openstack.v2_0.options.PaginationOptions;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.MapBinder;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.annotations.SelectJson;
import org.jclouds.rest.annotations.Transform;
import org.jclouds.rest.binders.BindToJsonPayload;

@RequestFilters(value={AuthenticateRequest.class})
public interface ImageAsyncApi {
    @Named(value="image:list")
    @GET
    @Consumes(value={"application/json"})
    @Path(value="/images")
    @RequestFilters(value={AuthenticateRequest.class})
    @ResponseParser(value=ParseImages.class)
    @Transform(value=ParseImages.ToPagedIterable.class)
    @Fallback(value=Fallbacks.EmptyPagedIterableOnNotFoundOr404.class)
    public ListenableFuture<? extends PagedIterable<? extends Resource>> list();

    @Named(value="image:list")
    @GET
    @Consumes(value={"application/json"})
    @Path(value="/images")
    @RequestFilters(value={AuthenticateRequest.class})
    @ResponseParser(value=ParseImages.class)
    @Fallback(value=KeystoneFallbacks.EmptyPaginatedCollectionOnNotFoundOr404.class)
    public ListenableFuture<? extends PaginatedCollection<? extends Resource>> list(PaginationOptions var1);

    @Named(value="image:list")
    @GET
    @Consumes(value={"application/json"})
    @Path(value="/images/detail")
    @RequestFilters(value={AuthenticateRequest.class})
    @ResponseParser(value=ParseImageDetails.class)
    @Transform(value=ParseImageDetails.ToPagedIterable.class)
    @Fallback(value=Fallbacks.EmptyPagedIterableOnNotFoundOr404.class)
    public ListenableFuture<? extends PagedIterable<? extends Image>> listInDetail();

    @Named(value="image:list")
    @GET
    @Consumes(value={"application/json"})
    @Path(value="/images/detail")
    @RequestFilters(value={AuthenticateRequest.class})
    @ResponseParser(value=ParseImageDetails.class)
    @Fallback(value=KeystoneFallbacks.EmptyPaginatedCollectionOnNotFoundOr404.class)
    public ListenableFuture<? extends PaginatedCollection<? extends Image>> listInDetail(PaginationOptions var1);

    @Named(value="image:get")
    @GET
    @SelectJson(value={"image"})
    @Consumes(value={"application/json"})
    @Path(value="/images/{id}")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public ListenableFuture<? extends Image> get(@PathParam(value="id") String var1);

    @Named(value="image:delete")
    @DELETE
    @Consumes(value={"application/json"})
    @Path(value="/images/{id}")
    @Fallback(value=Fallbacks.VoidOnNotFoundOr404.class)
    public ListenableFuture<Void> delete(@PathParam(value="id") String var1);

    @Named(value="image:getmetadata")
    @GET
    @SelectJson(value={"metadata"})
    @Path(value="/images/{id}/metadata")
    @Consumes(value={"application/json"})
    @Fallback(value=Fallbacks.EmptyMapOnNotFoundOr404.class)
    public ListenableFuture<Map<String, String>> getMetadata(@PathParam(value="id") String var1);

    @Named(value="image:setmetadata")
    @PUT
    @SelectJson(value={"metadata"})
    @Path(value="/images/{id}/metadata")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Fallback(value=Fallbacks.EmptyMapOnNotFoundOr404.class)
    @MapBinder(value=BindToJsonPayload.class)
    public ListenableFuture<Map<String, String>> setMetadata(@PathParam(value="id") String var1, @PayloadParam(value="metadata") Map<String, String> var2);

    @Named(value="image:updatemetadata")
    @POST
    @SelectJson(value={"metadata"})
    @Path(value="/images/{id}/metadata")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Fallback(value=Fallbacks.EmptyMapOnNotFoundOr404.class)
    @MapBinder(value=BindToJsonPayload.class)
    public ListenableFuture<? extends Map<String, String>> updateMetadata(@PathParam(value="id") String var1, @PayloadParam(value="metadata") Map<String, String> var2);

    @Named(value="image:getmetadata")
    @GET
    @Path(value="/images/{id}/metadata/{key}")
    @Consumes(value={"application/json"})
    @ResponseParser(value=OnlyMetadataValueOrNull.class)
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public ListenableFuture<String> getMetadata(@PathParam(value="id") String var1, @PathParam(value="key") String var2);

    @Named(value="image:updatemetadata")
    @PUT
    @Path(value="/images/{id}/metadata/{key}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ResponseParser(value=OnlyMetadataValueOrNull.class)
    @MapBinder(value=BindMetadataToJsonPayload.class)
    public ListenableFuture<String> updateMetadata(@PathParam(value="id") String var1, @PathParam(value="key") @PayloadParam(value="key") String var2, @PathParam(value="value") @PayloadParam(value="value") String var3);

    @Named(value="image:deletemetadata")
    @DELETE
    @Consumes
    @Path(value="/images/{id}/metadata/{key}")
    @Fallback(value=Fallbacks.VoidOnNotFoundOr404.class)
    public ListenableFuture<Void> deleteMetadata(@PathParam(value="id") String var1, @PathParam(value="key") String var2);
}

