/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.clouddns.v1.features;

import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SimpleTimeZone;
import javax.ws.rs.core.Response;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.rackspace.clouddns.v1.CloudDNSApi;
import org.jclouds.rackspace.clouddns.v1.domain.CreateDomain;
import org.jclouds.rackspace.clouddns.v1.domain.CreateSubdomain;
import org.jclouds.rackspace.clouddns.v1.domain.Domain;
import org.jclouds.rackspace.clouddns.v1.domain.DomainChange;
import org.jclouds.rackspace.clouddns.v1.domain.Job;
import org.jclouds.rackspace.clouddns.v1.domain.Record;
import org.jclouds.rackspace.clouddns.v1.domain.Subdomain;
import org.jclouds.rackspace.clouddns.v1.domain.UpdateDomain;
import org.jclouds.rackspace.clouddns.v1.features.DomainApi;
import org.jclouds.rackspace.clouddns.v1.functions.DomainFunctions;
import org.jclouds.rackspace.clouddns.v1.internal.BaseCloudDNSApiExpectTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class DomainApiExpectTest
extends BaseCloudDNSApiExpectTest<CloudDNSApi> {
    private static final String JCLOUDS_EXAMPLE = "jclouds-example.com";

    public void testCreateDomain() {
        URI endpoint = URI.create("https://dns.api.rackspacecloud.com/v1.0/123123/domains");
        DomainApi api = ((CloudDNSApi)this.requestsSendResponses(this.rackspaceAuthWithUsernameAndApiKey, this.responseWithAccess, ((HttpRequest.Builder)this.authenticatedGET().method("POST").payload(this.payloadFromResource("/domain-create.json"))).endpoint(endpoint).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).payload(this.payloadFromResource("/domain-create-response.json"))).build())).getDomainApi();
        Record createMXRecord = Record.builder().type("MX").name(JCLOUDS_EXAMPLE).data("mail.jclouds-example.com").priority(Integer.valueOf(11235)).build();
        Record createARecord = Record.builder().type("A").name(JCLOUDS_EXAMPLE).data("10.0.0.1").build();
        ImmutableList createRecords = ImmutableList.of((Object)createMXRecord, (Object)createARecord);
        CreateSubdomain createSubdomain1 = CreateSubdomain.builder().name("dev.jclouds-example.com").email("jclouds@jclouds-example.com").comment("Hello dev subdomain").build();
        CreateSubdomain createSubdomain2 = CreateSubdomain.builder().name("test.jclouds-example.com").email("jclouds@jclouds-example.com").comment("Hello test subdomain").build();
        ImmutableList createSubdomains = ImmutableList.of((Object)createSubdomain1, (Object)createSubdomain2);
        CreateDomain createDomain1 = CreateDomain.builder().name(JCLOUDS_EXAMPLE).email("jclouds@jclouds-example.com").ttl(Integer.valueOf(600000)).comment("Hello Domain").subdomains((Iterable)createSubdomains).records((Iterable)createRecords).build();
        CreateDomain createDomain2 = CreateDomain.builder().name("xjclouds-example.com").email("jclouds@jclouds-example.com").ttl(Integer.valueOf(600000)).comment("Hello Domain").build();
        ImmutableList createDomains = ImmutableList.of((Object)createDomain1, (Object)createDomain2);
        Job job = api.create((Iterable)createDomains);
        Assert.assertEquals((Object)job.getStatus(), (Object)Job.Status.COMPLETED);
        Assert.assertTrue((boolean)job.getResource().isPresent());
        Map domains = DomainFunctions.toDomainMap((Set)((Set)job.getResource().get()));
        Assert.assertEquals((int)((Domain)domains.get(JCLOUDS_EXAMPLE)).getId(), (int)3650906);
        Assert.assertEquals((String)((Domain)domains.get(JCLOUDS_EXAMPLE)).getEmail(), (String)"jclouds@jclouds-example.com");
        Assert.assertEquals((int)((Domain)domains.get(JCLOUDS_EXAMPLE)).getSubdomains().size(), (int)2);
        Assert.assertEquals((int)((Domain)domains.get(JCLOUDS_EXAMPLE)).getRecords().size(), (int)2);
        Assert.assertEquals((int)((Domain)domains.get("xjclouds-example.com")).getId(), (int)3650909);
    }

    public void testListDomains() {
        URI endpoint = URI.create("https://dns.api.rackspacecloud.com/v1.0/123123/domains");
        DomainApi api = ((CloudDNSApi)this.requestsSendResponses(this.rackspaceAuthWithUsernameAndApiKey, this.responseWithAccess, this.authenticatedGET().endpoint(endpoint).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).payload(this.payloadFromResource("/domain-list.json"))).build())).getDomainApi();
        ImmutableList domains = api.list().concat().toList();
        Assert.assertEquals((int)domains.size(), (int)4);
        for (Domain domain : domains) {
            Assert.assertTrue((boolean)domain.getName().contains(JCLOUDS_EXAMPLE));
        }
    }

    public void testListDomainsPaginated() {
        URI endpointPage1 = URI.create("https://dns.api.rackspacecloud.com/v1.0/123123/domains");
        URI endpointPage2 = URI.create("https://dns.api.rackspacecloud.com/v1.0/123123/domains?limit=4&offset=4");
        DomainApi api = ((CloudDNSApi)this.requestsSendResponses(this.rackspaceAuthWithUsernameAndApiKey, this.responseWithAccess, this.authenticatedGET().endpoint(endpointPage1).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).payload(this.payloadFromResource("/domain-list-page1.json"))).build(), this.authenticatedGET().endpoint(endpointPage2).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).payload(this.payloadFromResource("/domain-list-page2.json"))).build())).getDomainApi();
        ImmutableList domains = api.list().concat().toList();
        Assert.assertEquals((int)domains.size(), (int)8);
        for (Domain domain : domains) {
            Assert.assertTrue((boolean)domain.getName().contains(JCLOUDS_EXAMPLE));
        }
    }

    public void testListSubdomains() {
        URI endpoint = URI.create("https://dns.api.rackspacecloud.com/v1.0/123123/domains/3650908/subdomains");
        DomainApi api = ((CloudDNSApi)this.requestsSendResponses(this.rackspaceAuthWithUsernameAndApiKey, this.responseWithAccess, this.authenticatedGET().endpoint(endpoint).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).payload(this.payloadFromResource("/subdomain-list.json"))).build())).getDomainApi();
        ImmutableList subdomains = api.listSubdomains(3650908).concat().toList();
        Assert.assertEquals((int)subdomains.size(), (int)4);
        for (Subdomain subdomain : subdomains) {
            Assert.assertTrue((boolean)subdomain.getName().contains(JCLOUDS_EXAMPLE));
        }
    }

    public void testListSubdomainsPaginated() {
        URI endpointPage1 = URI.create("https://dns.api.rackspacecloud.com/v1.0/123123/domains/3650908/subdomains");
        URI endpointPage2 = URI.create("https://dns.api.rackspacecloud.com/v1.0/123123/domains/3650908/subdomains?limit=4&offset=4");
        DomainApi api = ((CloudDNSApi)this.requestsSendResponses(this.rackspaceAuthWithUsernameAndApiKey, this.responseWithAccess, this.authenticatedGET().endpoint(endpointPage1).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).payload(this.payloadFromResource("/subdomain-list-page1.json"))).build(), this.authenticatedGET().endpoint(endpointPage2).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).payload(this.payloadFromResource("/subdomain-list-page2.json"))).build())).getDomainApi();
        ImmutableList subdomains = api.listSubdomains(3650908).concat().toList();
        Assert.assertEquals((int)subdomains.size(), (int)8);
        for (Subdomain subdomain : subdomains) {
            Assert.assertTrue((boolean)subdomain.getName().contains(JCLOUDS_EXAMPLE));
        }
    }

    public void testListWithFilterByNamesMatching() {
        URI endpoint = URI.create("https://dns.api.rackspacecloud.com/v1.0/123123/domains?name=test.jclouds-example.com");
        DomainApi api = ((CloudDNSApi)this.requestsSendResponses(this.rackspaceAuthWithUsernameAndApiKey, this.responseWithAccess, this.authenticatedGET().endpoint(endpoint).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).payload(this.payloadFromResource("/domain-list-with-filter.json"))).build())).getDomainApi();
        ImmutableList domains = api.listWithFilterByNamesMatching("test.jclouds-example.com").concat().toList();
        Assert.assertEquals((int)domains.size(), (int)1);
        Assert.assertEquals((int)((Domain)domains.get(0)).getId(), (int)3650908);
        Assert.assertEquals((String)((Domain)domains.get(0)).getName(), (String)"test.jclouds-example.com");
    }

    public void testListDomainChanges() {
        URI endpoint = URI.create("https://dns.api.rackspacecloud.com/v1.0/123123/domains/3650908/changes?changes=2013-03-22T03%3A39%3A31Z");
        DomainApi api = ((CloudDNSApi)this.requestsSendResponses(this.rackspaceAuthWithUsernameAndApiKey, this.responseWithAccess, this.authenticatedGET().endpoint(endpoint).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).payload(this.payloadFromResource("/domain-list-changes.json"))).build())).getDomainApi();
        Calendar cal = Calendar.getInstance(new SimpleTimeZone(0, "GMT"));
        cal.set(2013, 2, 22, 3, 39, 31);
        DomainChange domainChange = api.listChanges(3650908, cal.getTime());
        Assert.assertEquals((int)domainChange.getChanges().size(), (int)25);
    }

    public void testGetDomain() {
        URI endpoint = URI.create("https://dns.api.rackspacecloud.com/v1.0/123123/domains/3650908?showRecords=true&showSubdomains=true");
        DomainApi api = ((CloudDNSApi)this.requestsSendResponses(this.rackspaceAuthWithUsernameAndApiKey, this.responseWithAccess, this.authenticatedGET().endpoint(endpoint).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).payload(this.payloadFromResource("/domain-get.json"))).build())).getDomainApi();
        Domain domain = api.get(3650908);
        Assert.assertEquals((String)domain.getName(), (String)"test.jclouds-example.com");
        Assert.assertEquals((int)domain.getRecords().size(), (int)2);
        Assert.assertEquals((String)((String)domain.getComment().get()), (String)"Hello test subdomain");
        Assert.assertEquals((int)domain.getTTL(), (int)3600);
    }

    public void testUpdateDomain() {
        URI endpoint = URI.create("https://dns.api.rackspacecloud.com/v1.0/123123/domains/3650908");
        DomainApi api = ((CloudDNSApi)this.requestsSendResponses(this.rackspaceAuthWithUsernameAndApiKey, this.responseWithAccess, ((HttpRequest.Builder)this.authenticatedGET().method("PUT").payload(this.payloadFromResourceWithContentType("/domain-update.json", "application/json"))).endpoint(endpoint).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).payload(this.payloadFromResource("/domain-update-response.json"))).build())).getDomainApi();
        UpdateDomain updateDomain = UpdateDomain.builder().email("everett@jclouds-example.com").ttl(Integer.valueOf(600001)).comment("Hello Domain Update").build();
        Job job = api.update(3650908, updateDomain);
        Assert.assertEquals((Object)job.getStatus(), (Object)Job.Status.COMPLETED);
    }

    public void testUpdateDomainsTTL() {
        URI endpoint = URI.create("https://dns.api.rackspacecloud.com/v1.0/123123/domains");
        DomainApi api = ((CloudDNSApi)this.requestsSendResponses(this.rackspaceAuthWithUsernameAndApiKey, this.responseWithAccess, ((HttpRequest.Builder)this.authenticatedGET().method("PUT").payload(this.payloadFromResource("/domain-update-ttl.json"))).endpoint(endpoint).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).payload(this.payloadFromResource("/domain-update-response.json"))).build())).getDomainApi();
        ImmutableList ids = ImmutableList.of((Object)3650906, (Object)3650908);
        Job job = api.updateTTL((Iterable)ids, 1234567);
        Assert.assertEquals((Object)job.getStatus(), (Object)Job.Status.COMPLETED);
    }

    public void testUpdateDomainsEmail() {
        URI endpoint = URI.create("https://dns.api.rackspacecloud.com/v1.0/123123/domains");
        DomainApi api = ((CloudDNSApi)this.requestsSendResponses(this.rackspaceAuthWithUsernameAndApiKey, this.responseWithAccess, ((HttpRequest.Builder)this.authenticatedGET().method("PUT").payload(this.payloadFromResource("/domain-update-email.json"))).endpoint(endpoint).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).payload(this.payloadFromResource("/domain-update-response.json"))).build())).getDomainApi();
        ImmutableList ids = ImmutableList.of((Object)3650906, (Object)3650908);
        Job job = api.updateEmail((Iterable)ids, "everett@jclouds-example.com");
        Assert.assertEquals((Object)job.getStatus(), (Object)Job.Status.COMPLETED);
    }

    public void testDeleteDomains() {
        URI endpoint = URI.create("https://dns.api.rackspacecloud.com/v1.0/123123/domains?id=3650907&id=3650906&id=3650908&id=3650909&deleteSubdomains=true");
        DomainApi api = ((CloudDNSApi)this.requestsSendResponses(this.rackspaceAuthWithUsernameAndApiKey, this.responseWithAccess, ((HttpRequest.Builder)this.authenticatedGET().method("DELETE").replaceHeader("Accept", new String[]{"*/*"})).endpoint(endpoint).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).payload(this.payloadFromResource("/domain-delete.json"))).build())).getDomainApi();
        ImmutableList domainIds = ImmutableList.of((Object)3650907, (Object)3650906, (Object)3650908, (Object)3650909);
        Job job = api.delete((Iterable)domainIds, true);
        Assert.assertEquals((Object)job.getStatus(), (Object)Job.Status.COMPLETED);
    }

    public void testExportDomain() {
        URI endpoint = URI.create("https://dns.api.rackspacecloud.com/v1.0/123123/domains/3651323/export");
        DomainApi api = ((CloudDNSApi)this.requestsSendResponses(this.rackspaceAuthWithUsernameAndApiKey, this.responseWithAccess, this.authenticatedGET().endpoint(endpoint).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).payload(this.payloadFromResource("/domain-export.json"))).build())).getDomainApi();
        Job job = api.exportFormat(3651323, Domain.Format.BIND_9);
        Assert.assertEquals((Object)job.getStatus(), (Object)Job.Status.COMPLETED);
        Assert.assertEquals((int)((List)job.getResource().get()).size(), (int)5);
    }

    public void testImportDomain() {
        URI endpoint = URI.create("https://dns.api.rackspacecloud.com/v1.0/123123/domains/import");
        DomainApi api = ((CloudDNSApi)this.requestsSendResponses(this.rackspaceAuthWithUsernameAndApiKey, this.responseWithAccess, ((HttpRequest.Builder)this.authenticatedGET().method("POST").payload(this.payloadFromResource("/domain-import.json"))).endpoint(endpoint).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).payload(this.payloadFromResource("/domain-import-response.json"))).build())).getDomainApi();
        ImmutableList contents = ImmutableList.of((Object)"jclouds-example.com.      3600  IN SOA   ns.rackspace.com. jclouds.jclouds-example.com. 1363882703 3600 3600 3600 3600", (Object)"jclouds-example.com.      600   IN A  50.56.174.152");
        Job job = api.importFormat((List)contents, Domain.Format.BIND_9);
        Assert.assertEquals((Object)job.getStatus(), (Object)Job.Status.COMPLETED);
        Assert.assertEquals((String)((Domain)job.getResource().get()).getName(), (String)JCLOUDS_EXAMPLE);
    }
}

